/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import java.util.Collection;
import java.util.Date;
import junit.framework.TestCase;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MetricsTest {
    protected static final ProcessEngineRule ENGINE_RULE = new ProvidedProcessEngineRule();
    protected static final ProcessEngineTestRule TEST_RULE = new ProcessEngineTestRule(ENGINE_RULE);
    @ClassRule
    public static RuleChain RULE_CHAIN = RuleChain.outerRule((TestRule)ENGINE_RULE).around((TestRule)TEST_RULE);
    protected static RuntimeService runtimeService;
    protected static ProcessEngineConfigurationImpl processEngineConfiguration;
    protected static ManagementService managementService;

    protected static void clearMetrics() {
        Collection meters = processEngineConfiguration.getMetricsRegistry().getDbMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        managementService.deleteMetrics(null);
        processEngineConfiguration.setDbMetricsReporterActivate(false);
    }

    @BeforeClass
    public static void initMetrics() {
        runtimeService = ENGINE_RULE.getRuntimeService();
        processEngineConfiguration = ENGINE_RULE.getProcessEngineConfiguration();
        managementService = ENGINE_RULE.getManagementService();
        MetricsTest.clearMetrics();
        TEST_RULE.deploy(Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done());
    }

    @After
    public void cleanUp() {
        MetricsTest.clearMetrics();
    }

    @Test
    public void testStartAndEndMetricsAreEqual() {
        runtimeService.startProcessInstanceByKey("testProcess");
        processEngineConfiguration.getDbMetricsReporter().reportNow();
        long start = managementService.createMetricsQuery().name("activity-instance-start").sum();
        long end = managementService.createMetricsQuery().name("activity-instance-end").sum();
        TestCase.assertEquals((long)end, (long)start);
        TestCase.assertEquals((long)end, (long)managementService.createMetricsQuery().name("flow-node-instances-end").sum());
    }

    @Test
    public void testEndMetricWithWaitState() {
        TEST_RULE.deploy(Bpmn.createExecutableProcess((String)"userProcess").startEvent().userTask("Task").endEvent().done());
        runtimeService.startProcessInstanceByKey("userProcess");
        processEngineConfiguration.getDbMetricsReporter().reportNow();
        long start = managementService.createMetricsQuery().name("activity-instance-start").sum();
        long end = managementService.createMetricsQuery().name("activity-instance-end").sum();
        Assert.assertNotEquals((long)end, (long)start);
        TestCase.assertEquals((long)end, (long)managementService.createMetricsQuery().name("flow-node-instances-end").sum());
        TestCase.assertEquals((long)2L, (long)start);
        TestCase.assertEquals((long)1L, (long)end);
        String id = ((Task)ENGINE_RULE.getTaskService().createTaskQuery().processDefinitionKey("userProcess").singleResult()).getId();
        ENGINE_RULE.getTaskService().complete(id);
        start = managementService.createMetricsQuery().name("activity-instance-start").sum();
        end = managementService.createMetricsQuery().name("activity-instance-end").sum();
        TestCase.assertEquals((long)end, (long)start);
        TestCase.assertEquals((long)end, (long)managementService.createMetricsQuery().name("flow-node-instances-end").sum());
    }

    @Test
    public void testDeleteMetrics() {
        runtimeService.startProcessInstanceByKey("testProcess");
        processEngineConfiguration.getDbMetricsReporter().reportNow();
        TestCase.assertEquals((long)7L, (long)managementService.createMetricsQuery().sum());
        managementService.deleteMetrics(null);
        TestCase.assertEquals((long)0L, (long)managementService.createMetricsQuery().sum());
    }

    @Test
    public void testDeleteMetricsWithTimestamp() {
        runtimeService.startProcessInstanceByKey("testProcess");
        processEngineConfiguration.getDbMetricsReporter().reportNow();
        TestCase.assertEquals((long)7L, (long)managementService.createMetricsQuery().sum());
        managementService.deleteMetrics(ClockUtil.getCurrentTime());
        TestCase.assertEquals((long)0L, (long)managementService.createMetricsQuery().name("activity-instance-start").sum());
    }

    @Test
    public void testDeleteMetricsWithTimestampBefore() {
        runtimeService.startProcessInstanceByKey("testProcess");
        processEngineConfiguration.getDbMetricsReporter().reportNow();
        TestCase.assertEquals((long)7L, (long)managementService.createMetricsQuery().sum());
        managementService.deleteMetrics(new Date(ClockUtil.getCurrentTime().getTime() - 10000L));
        TestCase.assertEquals((long)7L, (long)managementService.createMetricsQuery().sum());
    }

    @Test
    public void testDeleteMetricsWithReporterId() {
        processEngineConfiguration.setDbMetricsReporterActivate(true);
        processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter1");
        runtimeService.startProcessInstanceByKey("testProcess");
        managementService.reportDbMetricsNow();
        processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter2");
        runtimeService.startProcessInstanceByKey("testProcess");
        managementService.reportDbMetricsNow();
        TestCase.assertEquals((long)3L, (long)managementService.createMetricsQuery().name("activity-instance-start").reporter("reporter1").sum());
        managementService.deleteMetrics(null, "reporter1");
        TestCase.assertEquals((long)0L, (long)managementService.createMetricsQuery().name("activity-instance-start").reporter("reporter1").sum());
        TestCase.assertEquals((long)3L, (long)managementService.createMetricsQuery().name("activity-instance-start").reporter("reporter2").sum());
        processEngineConfiguration.setDbMetricsReporterActivate(false);
        processEngineConfiguration.getDbMetricsReporter().setReporterId(null);
    }

    @Test
    public void testReportNow() {
        processEngineConfiguration.setDbMetricsReporterActivate(true);
        runtimeService.startProcessInstanceByKey("testProcess");
        managementService.reportDbMetricsNow();
        TestCase.assertEquals((long)3L, (long)managementService.createMetricsQuery().name("activity-instance-start").sum());
        processEngineConfiguration.setDbMetricsReporterActivate(false);
    }

    @Test
    public void testReportNowIfMetricsIsDisabled() {
        boolean defaultIsMetricsEnabled = processEngineConfiguration.isMetricsEnabled();
        processEngineConfiguration.setMetricsEnabled(false);
        try {
            managementService.reportDbMetricsNow();
            TestCase.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Metrics reporting is disabled"));
        }
        finally {
            processEngineConfiguration.setMetricsEnabled(defaultIsMetricsEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReportNowIfReporterIsNotActive() {
        boolean defaultIsMetricsEnabled = processEngineConfiguration.isMetricsEnabled();
        boolean defaultIsMetricsReporterActivate = processEngineConfiguration.isDbMetricsReporterActivate();
        processEngineConfiguration.setMetricsEnabled(true);
        processEngineConfiguration.setDbMetricsReporterActivate(false);
        try {
            managementService.reportDbMetricsNow();
            TestCase.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Metrics reporting to database is disabled"));
        }
        finally {
            processEngineConfiguration.setMetricsEnabled(defaultIsMetricsEnabled);
            processEngineConfiguration.setDbMetricsReporterActivate(defaultIsMetricsReporterActivate);
        }
    }

    @Test
    public void testQuery() {
        runtimeService.startProcessInstanceByKey("testProcess");
        processEngineConfiguration.getDbMetricsReporter().reportNow();
        TestCase.assertEquals((long)0L, (long)managementService.createMetricsQuery().name("UNKNOWN").sum());
        TestCase.assertEquals((long)3L, (long)managementService.createMetricsQuery().name("activity-instance-start").sum());
        TestCase.assertEquals((long)7L, (long)managementService.createMetricsQuery().sum());
        TestCase.assertEquals((long)7L, (long)managementService.createMetricsQuery().startDate(new Date(1000L)).sum());
        TestCase.assertEquals((long)7L, (long)managementService.createMetricsQuery().startDate(new Date(1000L)).endDate(new Date(ClockUtil.getCurrentTime().getTime() + 2000L)).sum());
        TestCase.assertEquals((long)0L, (long)managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).sum());
        TestCase.assertEquals((long)0L, (long)managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).endDate(ClockUtil.getCurrentTime()).sum());
        runtimeService.startProcessInstanceByKey("testProcess");
        processEngineConfiguration.getDbMetricsReporter().reportNow();
        TestCase.assertEquals((long)14L, (long)managementService.createMetricsQuery().sum());
        TestCase.assertEquals((long)14L, (long)managementService.createMetricsQuery().startDate(new Date(1000L)).sum());
        TestCase.assertEquals((long)14L, (long)managementService.createMetricsQuery().startDate(new Date(1000L)).endDate(new Date(ClockUtil.getCurrentTime().getTime() + 2000L)).sum());
        TestCase.assertEquals((long)0L, (long)managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).sum());
        TestCase.assertEquals((long)0L, (long)managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).endDate(ClockUtil.getCurrentTime()).sum());
    }

    @Test
    public void testQueryEndDateExclusive() {
        ClockUtil.setCurrentTime((Date)new Date(5000L));
        runtimeService.startProcessInstanceByKey("testProcess");
        processEngineConfiguration.getDbMetricsReporter().reportNow();
        ClockUtil.setCurrentTime((Date)new Date(6000L));
        runtimeService.startProcessInstanceByKey("testProcess");
        processEngineConfiguration.getDbMetricsReporter().reportNow();
        ClockUtil.setCurrentTime((Date)new Date(7000L));
        runtimeService.startProcessInstanceByKey("testProcess");
        processEngineConfiguration.getDbMetricsReporter().reportNow();
        TestCase.assertEquals((long)21L, (long)managementService.createMetricsQuery().sum());
        TestCase.assertEquals((long)21L, (long)managementService.createMetricsQuery().startDate(new Date(0L)).sum());
        TestCase.assertEquals((long)14L, (long)managementService.createMetricsQuery().startDate(new Date(0L)).endDate(new Date(7000L)).sum());
        TestCase.assertEquals((long)21L, (long)managementService.createMetricsQuery().startDate(new Date(0L)).endDate(new Date(8000L)).sum());
    }

    @Test
    public void testReportWithReporterId() {
        processEngineConfiguration.setDbMetricsReporterActivate(true);
        processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter1");
        runtimeService.startProcessInstanceByKey("testProcess");
        managementService.reportDbMetricsNow();
        processEngineConfiguration.getDbMetricsReporter().setReporterId("reporter2");
        runtimeService.startProcessInstanceByKey("testProcess");
        managementService.reportDbMetricsNow();
        TestCase.assertEquals((long)6L, (long)managementService.createMetricsQuery().name("activity-instance-start").sum());
        TestCase.assertEquals((long)3L, (long)managementService.createMetricsQuery().name("activity-instance-start").reporter("reporter1").sum());
        TestCase.assertEquals((long)3L, (long)managementService.createMetricsQuery().name("activity-instance-start").reporter("reporter2").sum());
        TestCase.assertEquals((long)0L, (long)managementService.createMetricsQuery().name("activity-instance-start").reporter("aNonExistingReporter").sum());
        processEngineConfiguration.setDbMetricsReporterActivate(false);
        processEngineConfiguration.getDbMetricsReporter().setReporterId(null);
    }
}

