/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DecisionRequirementsDefinitionQueryTest {
    protected static final String DRD_SCORE_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String DRD_DISH_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String DRD_XYZ_RESOURCE = "org/camunda/bpm/engine/test/api/repository/drdXyz_.dmn11.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected String decisionRequirementsDefinitionId;
    protected String firstDeploymentId;
    protected String secondDeploymentId;
    protected String thirdDeploymentId;

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.firstDeploymentId = this.testRule.deploy(DRD_DISH_RESOURCE, DRD_SCORE_RESOURCE).getId();
        this.secondDeploymentId = this.testRule.deploy(DRD_DISH_RESOURCE).getId();
        this.thirdDeploymentId = this.testRule.deploy(DRD_XYZ_RESOURCE).getId();
        this.decisionRequirementsDefinitionId = ((DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey("score").singleResult()).getId();
    }

    @Test
    public void queryByDecisionRequirementsDefinitionId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionId("notExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionId(this.decisionRequirementsDefinitionId).count()).isEqualTo(1L);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)query.singleResult()).getKey()).isEqualTo((Object)"score");
    }

    @Test
    public void queryByDecisionRequirementsDefinitionIds() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionIdIn(new String[]{"not", "existing"}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionIdIn(new String[]{this.decisionRequirementsDefinitionId, "notExisting"}).count()).isEqualTo(1L);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)query.singleResult()).getKey()).isEqualTo((Object)"score");
    }

    @Test
    public void queryByDecisionRequirementsDefinitionKey() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionKey("notExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionKey("score").count()).isEqualTo(1L);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)query.singleResult()).getKey()).isEqualTo((Object)"score");
    }

    @Test
    public void queryByDecisionRequirementsDefinitionKeyLike() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionKeyLike("%notExisting%").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionKeyLike("%sco%").count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionKeyLike("%dis%").count()).isEqualTo(2L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionKeyLike("%s%").count()).isEqualTo(3L);
    }

    @Test
    public void queryByDecisionRequirementsDefinitionName() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionName("notExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionName("Score").count()).isEqualTo(1L);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)query.singleResult()).getKey()).isEqualTo((Object)"score");
    }

    @Test
    public void queryByDecisionRequirementsDefinitionNameLike() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionNameLike("%notExisting%").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionNameLike("%Sco%").count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionNameLike("%ish%").count()).isEqualTo(2L);
    }

    @Test
    public void queryByDecisionRequirementsDefinitionCategory() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionCategory("notExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionCategory("test-drd-1").count()).isEqualTo(1L);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)query.singleResult()).getKey()).isEqualTo((Object)"score");
    }

    @Test
    public void queryByDecisionRequirementsDefinitionCategoryLike() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionCategoryLike("%notExisting%").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionCategoryLike("%test%").count()).isEqualTo(3L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionCategoryLike("%z\\_").count()).isEqualTo(1L);
    }

    @Test
    public void queryByResourceName() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionResourceName("notExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionResourceName(DRD_SCORE_RESOURCE).count()).isEqualTo(1L);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)query.singleResult()).getKey()).isEqualTo((Object)"score");
    }

    @Test
    public void queryByResourceNameLike() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionResourceNameLike("%notExisting%").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionResourceNameLike("%.dmn11.xml%").count()).isEqualTo(4L);
    }

    @Test
    public void queryByResourceNameLikeEscape() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionResourceNameLike("%z\\_.%").count()).isEqualTo(1L);
    }

    @Test
    public void queryByVersion() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionVersion(Integer.valueOf(1)).count()).isEqualTo(3L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionVersion(Integer.valueOf(2)).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionVersion(Integer.valueOf(3)).count()).isEqualTo(0L);
    }

    @Test
    public void queryByLatest() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.latestVersion().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionKey("score").latestVersion().count()).isEqualTo(1L);
    }

    @Test
    public void queryByDeploymentId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.deploymentId("notExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.deploymentId(this.firstDeploymentId).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.deploymentId(this.secondDeploymentId).count()).isEqualTo(1L);
    }

    @Test
    public void orderByDecisionRequirementsDefinitionId() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionId().asc()).list();
        Assertions.assertThat((int)decisionRequirementsDefinitions.size()).isEqualTo(4);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getId()).startsWith((CharSequence)"dish:1");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getId()).startsWith((CharSequence)"dish:2");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getId()).startsWith((CharSequence)"score:1");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getId()).startsWith((CharSequence)"xyz:1");
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionId().desc()).list();
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getId()).startsWith((CharSequence)"xyz:1");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getId()).startsWith((CharSequence)"score:1");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getId()).startsWith((CharSequence)"dish:2");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getId()).startsWith((CharSequence)"dish:1");
    }

    @Test
    public void orderByDecisionRequirementsDefinitionKey() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionKey().asc()).list();
        Assertions.assertThat((int)decisionRequirementsDefinitions.size()).isEqualTo(4);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getKey()).isEqualTo((Object)"dish");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getKey()).isEqualTo((Object)"dish");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getKey()).isEqualTo((Object)"score");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getKey()).isEqualTo((Object)"xyz");
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionKey().desc()).list();
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getKey()).isEqualTo((Object)"xyz");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getKey()).isEqualTo((Object)"score");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getKey()).isEqualTo((Object)"dish");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getKey()).isEqualTo((Object)"dish");
    }

    @Test
    public void orderByDecisionRequirementsDefinitionName() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionName().asc()).list();
        Assertions.assertThat((int)decisionRequirementsDefinitions.size()).isEqualTo(4);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getName()).isEqualTo((Object)"Dish");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getName()).isEqualTo((Object)"Dish");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getName()).isEqualTo((Object)"Score");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getName()).isEqualTo((Object)"Xyz");
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionName().desc()).list();
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getName()).isEqualTo((Object)"Xyz");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getName()).isEqualTo((Object)"Score");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getName()).isEqualTo((Object)"Dish");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getName()).isEqualTo((Object)"Dish");
    }

    @Test
    public void orderByDecisionRequirementsDefinitionCategory() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionCategory().asc()).list();
        Assertions.assertThat((int)decisionRequirementsDefinitions.size()).isEqualTo(4);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getCategory()).isEqualTo((Object)"test-drd-1");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getCategory()).isEqualTo((Object)"test-drd-2");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getCategory()).isEqualTo((Object)"test-drd-2");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getCategory()).isEqualTo((Object)"xyz_");
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionCategory().desc()).list();
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getCategory()).isEqualTo((Object)"xyz_");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getCategory()).isEqualTo((Object)"test-drd-2");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getCategory()).isEqualTo((Object)"test-drd-2");
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getCategory()).isEqualTo((Object)"test-drd-1");
    }

    @Test
    public void orderByDecisionRequirementsDefinitionVersion() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionVersion().asc()).list();
        Assertions.assertThat((int)decisionRequirementsDefinitions.size()).isEqualTo(4);
        Assertions.assertThat((int)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getVersion()).isEqualTo(2);
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionVersion().desc()).list();
        Assertions.assertThat((int)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getVersion()).isEqualTo(2);
        Assertions.assertThat((int)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getVersion()).isEqualTo(1);
    }

    @Test
    public void orderByDeploymentId() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDeploymentId().asc()).list();
        Assertions.assertThat((int)decisionRequirementsDefinitions.size()).isEqualTo(4);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getDeploymentId()).isEqualTo((Object)this.firstDeploymentId);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getDeploymentId()).isEqualTo((Object)this.firstDeploymentId);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getDeploymentId()).isEqualTo((Object)this.secondDeploymentId);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getDeploymentId()).isEqualTo((Object)this.thirdDeploymentId);
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDeploymentId().desc()).list();
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getDeploymentId()).isEqualTo((Object)this.thirdDeploymentId);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getDeploymentId()).isEqualTo((Object)this.secondDeploymentId);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getDeploymentId()).isEqualTo((Object)this.firstDeploymentId);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getDeploymentId()).isEqualTo((Object)this.firstDeploymentId);
    }
}

