/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variables;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.variables.FailingJavaSerializable;
import org.camunda.bpm.engine.test.api.variables.JavaSerializable;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.TypedValueAssert;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ExclusiveGatewayBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JavaSerializationTest {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml";
    protected static final String JAVA_DATA_FORMAT = Variables.SerializationDataFormats.JAVA.getName();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJavaSerializationFormatEnabled(true));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private TaskService taskService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSerializationAsJava() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)Variables.objectValue((Object)javaSerializable).serializationDataFormat(JAVA_DATA_FORMAT).create());
        JavaSerializable value = (JavaSerializable)this.runtimeService.getVariable(instance.getId(), "simpleBean");
        Assert.assertEquals((Object)javaSerializable, (Object)value);
        ObjectValue typedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "simpleBean");
        TypedValueAssert.assertObjectValueDeserialized(typedValue, javaSerializable);
        TypedValueAssert.assertObjectValueSerializedJava(typedValue, javaSerializable);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaObjectSerialized() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        this.runtimeService.setVariable(instance.getId(), "simpleBean", (Object)Variables.serializedObjectValue((String)serializedObject).serializationDataFormat(JAVA_DATA_FORMAT).objectTypeName(JavaSerializable.class.getName()).create());
        JavaSerializable value = (JavaSerializable)this.runtimeService.getVariable(instance.getId(), "simpleBean");
        Assert.assertEquals((Object)javaSerializable, (Object)value);
        ObjectValue typedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "simpleBean");
        TypedValueAssert.assertObjectValueDeserialized(typedValue, javaSerializable);
        TypedValueAssert.assertObjectValueSerializedJava(typedValue, javaSerializable);
    }

    @Test
    @Deployment
    public void testJavaObjectDeserializedInFirstCommand() throws Exception {
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("varName", (Object)Variables.serializedObjectValue((String)serializedObject).serializationDataFormat(JAVA_DATA_FORMAT).objectTypeName(JavaSerializable.class.getName()).create()));
    }

    @Test
    @Deployment
    public void testJavaObjectNotDeserializedIfNotRequested() throws Exception {
        FailingJavaSerializable javaSerializable = new FailingJavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        byte[] serializedObjectBytes = baos.toByteArray();
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])serializedObjectBytes), (ProcessEngine)this.engineRule.getProcessEngine());
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(serializedObjectBytes));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> objectInputStream.readObject()).isInstanceOf(RuntimeException.class)).hasMessageContaining("Exception while deserializing object");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("varName", (Object)Variables.serializedObjectValue((String)serializedObject).serializationDataFormat(JAVA_DATA_FORMAT).objectTypeName(JavaSerializable.class.getName()).create()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaObjectNullDeserialized() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(instance.getId(), "nullObject", (Object)Variables.objectValue(null).serializationDataFormat(JAVA_DATA_FORMAT).create());
        Assert.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "nullObject"));
        ObjectValue typedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "nullObject");
        TypedValueAssert.assertObjectValueDeserializedNull(typedValue);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaObjectNullSerialized() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(instance.getId(), "nullObject", (Object)Variables.serializedObjectValue().serializationDataFormat(JAVA_DATA_FORMAT).create());
        Assert.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "nullObject"));
        ObjectValue deserializedTypedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "nullObject");
        TypedValueAssert.assertObjectValueDeserializedNull(deserializedTypedValue);
        ObjectValue serializedTypedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "nullObject", false);
        TypedValueAssert.assertObjectValueSerializedNull(serializedTypedValue);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetJavaObjectNullSerializedObjectTypeName() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String typeName = "some.type.Name";
        this.runtimeService.setVariable(instance.getId(), "nullObject", (Object)Variables.serializedObjectValue().serializationDataFormat(JAVA_DATA_FORMAT).objectTypeName(typeName).create());
        Assert.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "nullObject"));
        ObjectValue deserializedTypedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "nullObject");
        Assert.assertNotNull((Object)deserializedTypedValue);
        Assert.assertTrue((boolean)deserializedTypedValue.isDeserialized());
        Assert.assertEquals((Object)JAVA_DATA_FORMAT, (Object)deserializedTypedValue.getSerializationDataFormat());
        Assert.assertNull((Object)deserializedTypedValue.getValue());
        Assert.assertNull((Object)deserializedTypedValue.getValueSerialized());
        Assert.assertNull((Object)deserializedTypedValue.getObjectType());
        Assert.assertEquals((Object)typeName, (Object)deserializedTypedValue.getObjectTypeName());
        ObjectValue serializedTypedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "nullObject", false);
        Assert.assertNotNull((Object)serializedTypedValue);
        Assert.assertFalse((boolean)serializedTypedValue.isDeserialized());
        Assert.assertEquals((Object)JAVA_DATA_FORMAT, (Object)serializedTypedValue.getSerializationDataFormat());
        Assert.assertNull((Object)serializedTypedValue.getValueSerialized());
        Assert.assertEquals((Object)typeName, (Object)serializedTypedValue.getObjectTypeName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetUntypedNullForExistingVariable() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        this.runtimeService.setVariable(instance.getId(), "varName", (Object)Variables.objectValue((Object)javaSerializable).serializationDataFormat(JAVA_DATA_FORMAT).create());
        Assert.assertEquals((Object)javaSerializable, (Object)this.runtimeService.getVariable(instance.getId(), "varName"));
        this.runtimeService.setVariable(instance.getId(), "varName", null);
        TypedValue nullValue = this.runtimeService.getVariableTyped(instance.getId(), "varName");
        TypedValueAssert.assertUntypedNullValue(nullValue);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml"})
    public void testSetTypedNullForExistingVariable() throws Exception {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        JavaSerializable javaSerializable = new JavaSerializable("foo");
        this.runtimeService.setVariable(instance.getId(), "varName", (Object)Variables.objectValue((Object)javaSerializable).serializationDataFormat(JAVA_DATA_FORMAT).create());
        Assert.assertEquals((Object)javaSerializable, (Object)this.runtimeService.getVariable(instance.getId(), "varName"));
        this.runtimeService.setVariable(instance.getId(), "varName", (Object)Variables.objectValue(null));
        ObjectValue typedValue = (ObjectValue)this.runtimeService.getVariableTyped(instance.getId(), "varName");
        TypedValueAssert.assertObjectValueDeserializedNull(typedValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStandaloneTaskTransientVariable() throws IOException {
        Task task = this.taskService.newTask();
        task.setName("gonzoTask");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ObjectOutputStream(baos).writeObject(new String("trumpet"));
            String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
            this.taskService.setVariable(taskId, "instrument", (Object)Variables.serializedObjectValue((String)serializedObject).objectTypeName(String.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).setTransient(true));
            Assert.assertEquals((Object)"trumpet", (Object)this.taskService.getVariable(taskId, "instrument"));
        }
        finally {
            this.taskService.deleteTask(taskId, true);
        }
    }

    @Test
    public void testTransientObjectValue() throws IOException {
        BpmnModelInstance modelInstance = ((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"foo").startEvent().exclusiveGateway("gtw").sequenceFlowId("flow1")).condition("cond", "${x.property == \"bar\"}")).userTask("userTask1").endEvent().moveToLastGateway().sequenceFlowId("flow2").userTask("userTask2").endEvent().done();
        this.testRule.deploy(modelInstance);
        JavaSerializable bean = new JavaSerializable("bar");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(bean);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        ObjectValue javaValue = (ObjectValue)Variables.serializedObjectValue((String)serializedObject, (boolean)true).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName(JavaSerializable.class.getName()).create();
        VariableMap variables = Variables.createVariables().putValueTyped("x", (TypedValue)javaValue);
        this.runtimeService.startProcessInstanceByKey("foo", (Map)variables);
        List variableInstances = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variableInstances.size());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"userTask1", (Object)task.getTaskDefinitionKey());
    }
}

