/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.deploy;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.form.CamundaFormRef;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.form.FormDefinition;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessInstanceWithVariablesImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.standalone.deploy.DelegatingBpmnParseListener;
import org.camunda.bpm.engine.test.standalone.deploy.TestBPMNParseListener;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BPMNParseListenerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/engine/test/standalone/deploy/bpmn.parse.listener.camunda.cfg.xml");
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule);
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @After
    public void tearDown() {
        DelegatingBpmnParseListener.DELEGATE = null;
    }

    @Test
    public void testAlterProcessDefinitionKeyWhenDeploying() throws Exception {
        DelegatingBpmnParseListener.DELEGATE = new TestBPMNParseListener();
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/standalone/deploy/BPMNParseListenerTest.testAlterProcessDefinitionKeyWhenDeploying.bpmn20.xml");
        Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").count());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess-modified").count());
    }

    @Test
    public void testAlterActivityBehaviors() throws Exception {
        DelegatingBpmnParseListener.DELEGATE = new TestBPMNParseListener();
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/standalone/deploy/BPMNParseListenerTest.testAlterActivityBehaviors.bpmn20.xml");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskWithIntermediateThrowEvent-modified");
        ProcessDefinitionEntity processDefinition = ((ProcessInstanceWithVariablesImpl)processInstance).getExecutionEntity().getProcessDefinition();
        ActivityImpl cancelThrowEvent = processDefinition.findActivity("CancelthrowEvent");
        Assert.assertTrue((boolean)(cancelThrowEvent.getActivityBehavior() instanceof TestBPMNParseListener.TestCompensationEventActivityBehavior));
        ActivityImpl startEvent = processDefinition.findActivity("theStart");
        Assert.assertTrue((boolean)(startEvent.getActivityBehavior() instanceof TestBPMNParseListener.TestNoneStartEventActivityBehavior));
        ActivityImpl endEvent = processDefinition.findActivity("theEnd");
        Assert.assertTrue((boolean)(endEvent.getActivityBehavior() instanceof TestBPMNParseListener.TestNoneEndEventActivityBehavior));
    }

    @Test
    public void shouldModifyFormKeyViaTaskDefinition() {
        String originalFormKey = "some-form-key";
        final String modifiedFormKey = "another-form-key";
        BpmnModelInstance model = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task").camundaFormKey(originalFormKey)).endEvent().done();
        DelegatingBpmnParseListener.DELEGATE = new AbstractBpmnParseListener(){

            public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
                UserTaskActivityBehavior activityBehavior = (UserTaskActivityBehavior)activity.getActivityBehavior();
                TaskDefinition taskDefinition = activityBehavior.getTaskDefinition();
                ExpressionManager expressionManager = new ExpressionManager();
                Expression formKeyExpression = expressionManager.createExpression(modifiedFormKey);
                taskDefinition.setFormKey((org.camunda.bpm.engine.delegate.Expression)formKeyExpression);
            }
        };
        DeploymentWithDefinitions deployment = this.engineTestRule.deploy(model);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        FormService formService = this.engineRule.getFormService();
        String formKey = formService.getTaskFormKey(processDefinition.getId(), "task");
        Assertions.assertThat((String)formKey).isEqualTo((Object)modifiedFormKey);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        TaskFormData formData = formService.getTaskFormData(task.getId());
        Assertions.assertThat((String)formData.getFormKey()).isEqualTo((Object)modifiedFormKey);
    }

    @Test
    public void shouldModifyFormRefViaTaskDefinition() {
        String originalFormRef = "some-form-ref";
        String originalFormRefBinding = "deployment";
        final String modifiedFormRef = "another-form-ref";
        final String modifiedFormRefBinding = "version";
        final Integer modifiedFormRefVersion = 20;
        BpmnModelInstance model = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task").camundaFormRef(originalFormRef)).camundaFormRefBinding(originalFormRefBinding)).endEvent().done();
        DelegatingBpmnParseListener.DELEGATE = new AbstractBpmnParseListener(){

            public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
                UserTaskActivityBehavior activityBehavior = (UserTaskActivityBehavior)activity.getActivityBehavior();
                TaskDefinition taskDefinition = activityBehavior.getTaskDefinition();
                FormDefinition formDefinition = taskDefinition.getFormDefinition();
                ExpressionManager expressionManager = new ExpressionManager();
                Expression formRefExpression = expressionManager.createExpression(modifiedFormRef);
                formDefinition.setCamundaFormDefinitionKey((org.camunda.bpm.engine.delegate.Expression)formRefExpression);
                formDefinition.setCamundaFormDefinitionBinding(modifiedFormRefBinding);
                Expression formVersionExpression = expressionManager.createExpression(modifiedFormRefVersion.toString());
                formDefinition.setCamundaFormDefinitionVersion((org.camunda.bpm.engine.delegate.Expression)formVersionExpression);
            }
        };
        this.engineTestRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        FormService formService = this.engineRule.getFormService();
        TaskFormData formData = formService.getTaskFormData(task.getId());
        CamundaFormRef formRef = formData.getCamundaFormRef();
        Assertions.assertThat((String)formRef.getKey()).isEqualTo((Object)modifiedFormRef);
        Assertions.assertThat((String)formRef.getBinding()).isEqualTo((Object)modifiedFormRefBinding);
        Assertions.assertThat((Integer)formRef.getVersion()).isEqualTo((Object)modifiedFormRefVersion);
    }
}

