/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.deploy;

import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.standalone.deploy.TestCmmnTransformListener;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.cmmn.instance.Case;
import org.camunda.bpm.model.cmmn.instance.CasePlanModel;
import org.camunda.bpm.model.cmmn.instance.CaseTask;
import org.camunda.bpm.model.cmmn.instance.DecisionTask;
import org.camunda.bpm.model.cmmn.instance.Definitions;
import org.camunda.bpm.model.cmmn.instance.EventListener;
import org.camunda.bpm.model.cmmn.instance.HumanTask;
import org.camunda.bpm.model.cmmn.instance.Milestone;
import org.camunda.bpm.model.cmmn.instance.ProcessTask;
import org.camunda.bpm.model.cmmn.instance.Sentry;
import org.camunda.bpm.model.cmmn.instance.Stage;
import org.camunda.bpm.model.cmmn.instance.Task;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class CmmnTransformListenerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/engine/test/standalone/deploy/cmmn.transform.listener.camunda.cfg.xml");
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected RepositoryService repositoryService;

    @Before
    public void setUp() {
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @After
    public void tearDown() {
        TestCmmnTransformListener.reset();
    }

    @Deployment
    @Test
    public void testListenerInvocation() {
        Assert.assertEquals((long)0L, (long)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("testCase").count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("testCase-modified").count());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("testCase-modified-modified").count());
        Assert.assertEquals((long)1L, (long)TestCmmnTransformListener.numberOfRegistered(Definitions.class));
        Assert.assertEquals((long)1L, (long)TestCmmnTransformListener.numberOfRegistered(Case.class));
        Assert.assertEquals((long)1L, (long)TestCmmnTransformListener.numberOfRegistered(CasePlanModel.class));
        Assert.assertEquals((long)3L, (long)TestCmmnTransformListener.numberOfRegistered(HumanTask.class));
        Assert.assertEquals((long)1L, (long)TestCmmnTransformListener.numberOfRegistered(ProcessTask.class));
        Assert.assertEquals((long)1L, (long)TestCmmnTransformListener.numberOfRegistered(CaseTask.class));
        Assert.assertEquals((long)1L, (long)TestCmmnTransformListener.numberOfRegistered(DecisionTask.class));
        Assert.assertEquals((long)7L, (long)TestCmmnTransformListener.numberOfRegistered(Task.class));
        Assert.assertEquals((long)2L, (long)TestCmmnTransformListener.numberOfRegistered(Stage.class));
        Assert.assertEquals((long)1L, (long)TestCmmnTransformListener.numberOfRegistered(Milestone.class));
        Assert.assertEquals((long)0L, (long)TestCmmnTransformListener.numberOfRegistered(EventListener.class));
        Assert.assertEquals((long)3L, (long)TestCmmnTransformListener.numberOfRegistered(Sentry.class));
        Assert.assertEquals((long)11L, (long)TestCmmnTransformListener.cmmnActivities.size());
        Assert.assertEquals((long)24L, (long)TestCmmnTransformListener.modelElementInstances.size());
        Assert.assertEquals((long)3L, (long)TestCmmnTransformListener.sentryDeclarations.size());
    }
}

