/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.BatchStatistics;
import org.camunda.bpm.engine.batch.BatchStatisticsQuery;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BatchStatisticsQueryTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    protected ManagementService managementService;
    protected int defaultBatchJobsPerSeed;

    @Before
    public void initServices() {
        this.managementService = this.engineRule.getManagementService();
    }

    @Before
    public void saveAndReduceBatchJobsPerSeed() {
        ProcessEngineConfigurationImpl configuration = this.engineRule.getProcessEngineConfiguration();
        this.defaultBatchJobsPerSeed = configuration.getBatchJobsPerSeed();
        configuration.setBatchJobsPerSeed(10);
    }

    @After
    public void resetBatchJobsPerSeed() {
        this.engineRule.getProcessEngineConfiguration().setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void testQuery() {
        List statistics = this.managementService.createBatchStatisticsQuery().list();
        Assert.assertEquals((long)0L, (long)statistics.size());
        Batch batch1 = this.helper.createMigrationBatchWithSize(1);
        statistics = this.managementService.createBatchStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        Assert.assertEquals((Object)batch1.getId(), (Object)((BatchStatistics)statistics.get(0)).getId());
        Batch batch2 = this.helper.createMigrationBatchWithSize(1);
        Batch batch3 = this.helper.createMigrationBatchWithSize(1);
        statistics = this.managementService.createBatchStatisticsQuery().list();
        Assert.assertEquals((long)3L, (long)statistics.size());
        this.helper.completeBatch(batch1);
        this.helper.completeBatch(batch3);
        statistics = this.managementService.createBatchStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        Assert.assertEquals((Object)batch2.getId(), (Object)((BatchStatistics)statistics.get(0)).getId());
        this.helper.completeBatch(batch2);
        statistics = this.managementService.createBatchStatisticsQuery().list();
        Assert.assertEquals((long)0L, (long)statistics.size());
    }

    @Test
    public void testQueryCount() {
        long count = this.managementService.createBatchStatisticsQuery().count();
        Assert.assertEquals((long)0L, (long)count);
        Batch batch1 = this.helper.createMigrationBatchWithSize(1);
        count = this.managementService.createBatchStatisticsQuery().count();
        Assert.assertEquals((long)1L, (long)count);
        Batch batch2 = this.helper.createMigrationBatchWithSize(1);
        Batch batch3 = this.helper.createMigrationBatchWithSize(1);
        count = this.managementService.createBatchStatisticsQuery().count();
        Assert.assertEquals((long)3L, (long)count);
        this.helper.completeBatch(batch1);
        this.helper.completeBatch(batch3);
        count = this.managementService.createBatchStatisticsQuery().count();
        Assert.assertEquals((long)1L, (long)count);
        this.helper.completeBatch(batch2);
        count = this.managementService.createBatchStatisticsQuery().count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testQueryById() {
        this.helper.createMigrationBatchWithSize(1);
        Batch batch = this.helper.createMigrationBatchWithSize(1);
        BatchStatistics statistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().batchId(batch.getId()).singleResult();
        Assert.assertEquals((Object)batch.getId(), (Object)statistics.getId());
    }

    @Test
    public void testQueryByNullId() {
        try {
            this.managementService.createBatchStatisticsQuery().batchId(null).singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Batch id is null"));
        }
    }

    @Test
    public void testQueryByUnknownId() {
        this.helper.createMigrationBatchWithSize(1);
        this.helper.createMigrationBatchWithSize(1);
        List statistics = this.managementService.createBatchStatisticsQuery().batchId("unknown").list();
        Assert.assertEquals((long)0L, (long)statistics.size());
    }

    @Test
    public void testQueryByType() {
        this.helper.createMigrationBatchWithSize(1);
        this.helper.createMigrationBatchWithSize(1);
        List statistics = this.managementService.createBatchStatisticsQuery().type("instance-migration").list();
        Assert.assertEquals((long)2L, (long)statistics.size());
    }

    @Test
    public void testQueryByNullType() {
        try {
            this.managementService.createBatchStatisticsQuery().type(null).list();
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Type is null"));
        }
    }

    @Test
    public void testQueryByUnknownType() {
        this.helper.createMigrationBatchWithSize(1);
        this.helper.createMigrationBatchWithSize(1);
        List statistics = this.managementService.createBatchStatisticsQuery().type("unknown").list();
        Assert.assertEquals((long)0L, (long)statistics.size());
    }

    @Test
    public void testQueryOrderByIdAsc() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        List statistics = ((BatchStatisticsQuery)this.managementService.createBatchStatisticsQuery().orderById().asc()).list();
        TestOrderingUtil.verifySorting(statistics, TestOrderingUtil.batchStatisticsById());
    }

    @Test
    public void testQueryOrderByIdDec() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        List statistics = ((BatchStatisticsQuery)this.managementService.createBatchStatisticsQuery().orderById().desc()).list();
        TestOrderingUtil.verifySorting(statistics, TestOrderingUtil.inverted(TestOrderingUtil.batchStatisticsById()));
    }

    @Test
    public void testQueryOrderingPropertyWithoutOrder() {
        try {
            this.managementService.createBatchStatisticsQuery().orderById().list();
            Assert.fail((String)"exception expected");
        }
        catch (NotValidException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Invalid query: call asc() or desc() after using orderByXX()"));
        }
    }

    @Test
    public void testQueryOrderWithoutOrderingProperty() {
        try {
            ((BatchStatisticsQuery)this.managementService.createBatchStatisticsQuery().asc()).list();
            Assert.fail((String)"exception expected");
        }
        catch (NotValidException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"You should call any of the orderBy methods first before specifying a direction"));
        }
    }

    @Test
    public void testStatisticsNoExecutionJobsGenerated() {
        this.helper.createMigrationBatchWithSize(3);
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().singleResult();
        Assert.assertEquals((long)3L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)3L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getFailedJobs());
    }

    @Test
    public void testStatisticsMostExecutionJobsGenerated() {
        Batch batch = this.helper.createMigrationBatchWithSize(13);
        this.helper.executeJob(this.helper.getSeedJob(batch));
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().singleResult();
        Assert.assertEquals((long)13L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)10L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)13L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getFailedJobs());
    }

    @Test
    public void testStatisticsAllExecutionJobsGenerated() {
        Batch batch = this.helper.createMigrationBatchWithSize(3);
        this.helper.completeSeedJobs(batch);
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().singleResult();
        Assert.assertEquals((long)3L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)3L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)3L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getFailedJobs());
    }

    @Test
    public void testStatisticsOneCompletedJob() {
        Batch batch = this.helper.createMigrationBatchWithSize(3);
        this.helper.completeSeedJobs(batch);
        this.helper.completeJobs(batch, 1);
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().singleResult();
        Assert.assertEquals((long)3L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)3L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)2L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)1L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getFailedJobs());
    }

    @Test
    public void testStatisticsOneFailedJob() {
        Batch batch = this.helper.createMigrationBatchWithSize(3);
        this.helper.completeSeedJobs(batch);
        this.helper.failExecutionJobs(batch, 1);
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().singleResult();
        Assert.assertEquals((long)3L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)3L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)3L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)1L, (long)batchStatistics.getFailedJobs());
    }

    @Test
    public void testStatisticsOneCompletedAndOneFailedJob() {
        Batch batch = this.helper.createMigrationBatchWithSize(3);
        this.helper.completeSeedJobs(batch);
        this.helper.completeJobs(batch, 1);
        this.helper.failExecutionJobs(batch, 1);
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().singleResult();
        Assert.assertEquals((long)3L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)3L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)2L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)1L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)1L, (long)batchStatistics.getFailedJobs());
    }

    @Test
    public void testStatisticsRetriedFailedJobs() {
        Batch batch = this.helper.createMigrationBatchWithSize(3);
        this.helper.completeSeedJobs(batch);
        this.helper.failExecutionJobs(batch, 3);
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().singleResult();
        Assert.assertEquals((long)3L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)3L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)3L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)3L, (long)batchStatistics.getFailedJobs());
        this.helper.setRetries(batch, 3, 1);
        this.helper.completeJobs(batch, 3);
        batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().singleResult();
        Assert.assertEquals((long)3L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)3L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)0L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)3L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getFailedJobs());
    }

    @Test
    public void testStatisticsWithDeletedJobs() {
        Batch batch = this.helper.createMigrationBatchWithSize(13);
        this.helper.executeJob(this.helper.getSeedJob(batch));
        this.deleteMigrationJobs(batch);
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().singleResult();
        Assert.assertEquals((long)13L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)10L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)3L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)10L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)0L, (long)batchStatistics.getFailedJobs());
    }

    @Test
    public void testStatisticsWithNotAllGeneratedAndAlreadyCompletedAndFailedJobs() {
        Batch batch = this.helper.createMigrationBatchWithSize(13);
        this.helper.executeJob(this.helper.getSeedJob(batch));
        this.helper.completeJobs(batch, 2);
        this.helper.failExecutionJobs(batch, 2);
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().singleResult();
        Assert.assertEquals((long)13L, (long)batchStatistics.getTotalJobs());
        Assert.assertEquals((long)10L, (long)batchStatistics.getJobsCreated());
        Assert.assertEquals((long)11L, (long)batchStatistics.getRemainingJobs());
        Assert.assertEquals((long)2L, (long)batchStatistics.getCompletedJobs());
        Assert.assertEquals((long)2L, (long)batchStatistics.getFailedJobs());
    }

    @Test
    public void testMultipleBatchesStatistics() {
        Batch batch1 = this.helper.createMigrationBatchWithSize(3);
        Batch batch2 = this.helper.createMigrationBatchWithSize(13);
        Batch batch3 = this.helper.createMigrationBatchWithSize(15);
        this.helper.executeJob(this.helper.getSeedJob(batch2));
        this.helper.completeJobs(batch2, 2);
        this.helper.failExecutionJobs(batch2, 3);
        this.helper.executeJob(this.helper.getSeedJob(batch3));
        this.deleteMigrationJobs(batch3);
        this.helper.executeJob(this.helper.getSeedJob(batch3));
        this.helper.completeJobs(batch3, 2);
        this.helper.failExecutionJobs(batch3, 3);
        List batchStatisticsList = this.managementService.createBatchStatisticsQuery().list();
        for (BatchStatistics batchStatistics : batchStatisticsList) {
            if (batch1.getId().equals(batchStatistics.getId())) {
                Assert.assertEquals((long)3L, (long)batchStatistics.getTotalJobs());
                Assert.assertEquals((long)0L, (long)batchStatistics.getJobsCreated());
                Assert.assertEquals((long)3L, (long)batchStatistics.getRemainingJobs());
                Assert.assertEquals((long)0L, (long)batchStatistics.getCompletedJobs());
                Assert.assertEquals((long)0L, (long)batchStatistics.getFailedJobs());
                continue;
            }
            if (batch2.getId().equals(batchStatistics.getId())) {
                Assert.assertEquals((long)13L, (long)batchStatistics.getTotalJobs());
                Assert.assertEquals((long)10L, (long)batchStatistics.getJobsCreated());
                Assert.assertEquals((long)11L, (long)batchStatistics.getRemainingJobs());
                Assert.assertEquals((long)2L, (long)batchStatistics.getCompletedJobs());
                Assert.assertEquals((long)3L, (long)batchStatistics.getFailedJobs());
                continue;
            }
            if (!batch3.getId().equals(batchStatistics.getId())) continue;
            Assert.assertEquals((long)15L, (long)batchStatistics.getTotalJobs());
            Assert.assertEquals((long)15L, (long)batchStatistics.getJobsCreated());
            Assert.assertEquals((long)3L, (long)batchStatistics.getRemainingJobs());
            Assert.assertEquals((long)12L, (long)batchStatistics.getCompletedJobs());
            Assert.assertEquals((long)3L, (long)batchStatistics.getFailedJobs());
        }
    }

    @Test
    public void testStatisticsSuspend() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().batchId(batch.getId()).singleResult();
        Assert.assertTrue((boolean)batchStatistics.isSuspended());
    }

    @Test
    public void testStatisticsActivate() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        this.managementService.activateBatchById(batch.getId());
        BatchStatistics batchStatistics = (BatchStatistics)this.managementService.createBatchStatisticsQuery().batchId(batch.getId()).singleResult();
        Assert.assertFalse((boolean)batchStatistics.isSuspended());
    }

    @Test
    public void testStatisticsQueryBySuspendedBatches() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch1.getId());
        this.managementService.suspendBatchById(batch2.getId());
        this.managementService.activateBatchById(batch1.getId());
        BatchStatisticsQuery query = this.managementService.createBatchStatisticsQuery().suspended();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((Object)batch2.getId(), (Object)((BatchStatistics)query.singleResult()).getId());
    }

    @Test
    public void testStatisticsQueryByActiveBatches() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch3 = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch1.getId());
        this.managementService.suspendBatchById(batch2.getId());
        this.managementService.activateBatchById(batch1.getId());
        BatchStatisticsQuery query = this.managementService.createBatchStatisticsQuery().active();
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        ArrayList<String> foundIds = new ArrayList<String>();
        for (Batch batch : query.list()) {
            foundIds.add(batch.getId());
        }
        Assertions.assertThat(foundIds).contains((Object[])new String[]{batch1.getId(), batch3.getId()});
    }

    protected void deleteMigrationJobs(Batch batch) {
        for (Job migrationJob : this.helper.getExecutionJobs(batch)) {
            this.managementService.deleteJob(migrationJob.getId());
        }
    }
}

