/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

public abstract class AbstractConditionalEventTestCase {
    protected static final String CONDITIONAL_EVENT_PROCESS_KEY = "conditionalEventProcess";
    protected static final String CONDITIONAL_EVENT = "conditionalEvent";
    protected static final String CONDITION_EXPR = "${variable == 1}";
    protected static final String EXPR_SET_VARIABLE = "${execution.setVariable(\"variable\", 1)}";
    protected static final String EXPR_SET_VARIABLE_ON_PARENT = "${execution.getParent().setVariable(\"variable\", 1)}";
    protected static final String CONDITIONAL_MODEL = "conditionalModel.bpmn20.xml";
    protected static final String CONDITIONAL_VAR_EVENTS = "create, update";
    protected static final String CONDITIONAL_VAR_EVENT_UPDATE = "update";
    protected static final String TASK_BEFORE_CONDITION = "Before Condition";
    protected static final String TASK_BEFORE_CONDITION_ID = "beforeConditionId";
    protected static final String TASK_AFTER_CONDITION = "After Condition";
    public static final String TASK_AFTER_CONDITION_ID = "afterConditionId";
    protected static final String TASK_AFTER_SERVICE_TASK = "afterServiceTask";
    protected static final String TASK_IN_SUB_PROCESS_ID = "taskInSubProcess";
    protected static final String TASK_IN_SUB_PROCESS = "Task in Subprocess";
    protected static final String TASK_WITH_CONDITION = "Task with condition";
    protected static final String TASK_WITH_CONDITION_ID = "taskWithCondition";
    protected static final String AFTER_TASK = "After Task";
    protected static final String VARIABLE_NAME = "variable";
    protected static final String TRUE_CONDITION = "${true}";
    protected static final String SUB_PROCESS_ID = "subProcess";
    protected static final String FLOW_ID = "flow";
    protected static final String DELEGATED_PROCESS_KEY = "delegatedProcess";
    protected static final BpmnModelInstance TASK_MODEL = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).endEvent().done();
    protected static final BpmnModelInstance DELEGATED_PROCESS = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"delegatedProcess").startEvent().serviceTask().camundaExpression("${execution.setVariable(\"variable\", 1)}")).endEvent().done();
    protected static final String TASK_AFTER_OUTPUT_MAPPING = "afterOutputMapping";
    protected List<Task> tasksAfterVariableIsSet;
    @Rule
    public final ProcessEngineRule engine = new ProvidedProcessEngineRule();
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected RepositoryService repositoryService;
    protected HistoryService historyService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected EventSubscriptionQueryImpl conditionEventSubscriptionQuery;

    @Before
    public void init() {
        this.runtimeService = this.engine.getRuntimeService();
        this.taskService = this.engine.getTaskService();
        this.repositoryService = this.engine.getRepositoryService();
        this.historyService = this.engine.getHistoryService();
        this.processEngineConfiguration = this.engine.getProcessEngineConfiguration();
        this.conditionEventSubscriptionQuery = new EventSubscriptionQueryImpl(this.processEngineConfiguration.getCommandExecutorTxRequired()).eventType(EventType.CONDITONAL.name());
    }

    @After
    public void checkIfProcessCanBeFinished() {
        Assert.assertNotNull(this.tasksAfterVariableIsSet);
        for (Task task : this.tasksAfterVariableIsSet) {
            this.taskService.complete(task.getId());
        }
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
        this.tasksAfterVariableIsSet = null;
    }

    public static void assertTaskNames(List<Task> actualTasks, String ... expectedTaskNames) {
        ArrayList<String> expectedNames = new ArrayList<String>(Arrays.asList(expectedTaskNames));
        for (Task task : actualTasks) {
            String actualTaskName = task.getName();
            if (!expectedNames.contains(actualTaskName)) continue;
            expectedNames.remove(actualTaskName);
        }
        Assert.assertTrue((boolean)expectedNames.isEmpty());
    }

    protected void deployConditionalEventSubProcess(BpmnModelInstance model, String parentId, boolean isInterrupting) {
        this.deployConditionalEventSubProcess(model, parentId, CONDITION_EXPR, isInterrupting);
    }

    protected void deployConditionalEventSubProcess(BpmnModelInstance model, String parentId, String conditionExpr, boolean isInterrupting) {
        BpmnModelInstance modelInstance = this.addConditionalEventSubProcess(model, parentId, conditionExpr, TASK_AFTER_CONDITION_ID, isInterrupting);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance(CONDITIONAL_MODEL, modelInstance).deploy());
    }

    protected BpmnModelInstance addConditionalEventSubProcess(BpmnModelInstance model, String parentId, String userTaskId, boolean isInterrupting) {
        return this.addConditionalEventSubProcess(model, parentId, CONDITION_EXPR, userTaskId, isInterrupting);
    }

    protected BpmnModelInstance addConditionalEventSubProcess(BpmnModelInstance model, String parentId, String conditionExpr, String userTaskId, boolean isInterrupting) {
        return ((UserTaskBuilder)((StartEventBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(model).addSubProcessTo(parentId).triggerByEvent()).embeddedSubProcess().startEvent().interrupting(isInterrupting)).condition(conditionExpr)).userTask(userTaskId).name(TASK_AFTER_CONDITION)).endEvent().done();
    }

    protected void deployConditionalBoundaryEventProcess(BpmnModelInstance model, String activityId, boolean isInterrupting) {
        this.deployConditionalBoundaryEventProcess(model, activityId, CONDITION_EXPR, isInterrupting);
    }

    protected void deployConditionalBoundaryEventProcess(BpmnModelInstance model, String activityId, String conditionExpr, boolean isInterrupting) {
        BpmnModelInstance modelInstance = this.addConditionalBoundaryEvent(model, activityId, conditionExpr, TASK_AFTER_CONDITION_ID, isInterrupting);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance(CONDITIONAL_MODEL, modelInstance).deploy());
    }

    protected BpmnModelInstance addConditionalBoundaryEvent(BpmnModelInstance model, String activityId, String userTaskId, boolean isInterrupting) {
        return this.addConditionalBoundaryEvent(model, activityId, CONDITION_EXPR, userTaskId, isInterrupting);
    }

    protected BpmnModelInstance addConditionalBoundaryEvent(BpmnModelInstance model, String activityId, String conditionExpr, String userTaskId, boolean isInterrupting) {
        return ((UserTaskBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(model).activityBuilder(activityId).boundaryEvent().cancelActivity(Boolean.valueOf(isInterrupting))).condition(conditionExpr)).userTask(userTaskId).name(TASK_AFTER_CONDITION)).endEvent().done();
    }
}

