/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.HistoryLevelSetupCommand;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.junit.After;
import org.junit.Test;

public class DatabaseHistoryPropertyAutoTest {
    protected List<ProcessEngineImpl> processEngines = new ArrayList<ProcessEngineImpl>();

    private static ProcessEngineConfigurationImpl config(String historyLevel) {
        return DatabaseHistoryPropertyAutoTest.config("false", historyLevel);
    }

    private static ProcessEngineConfigurationImpl config(String schemaUpdate, String historyLevel) {
        StandaloneInMemProcessEngineConfiguration engineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration.setProcessEngineName(UUID.randomUUID().toString());
        engineConfiguration.setDatabaseSchemaUpdate(schemaUpdate);
        engineConfiguration.setHistory(historyLevel);
        engineConfiguration.setDbMetricsReporterActivate(false);
        engineConfiguration.setJdbcUrl("jdbc:h2:mem:DatabaseHistoryPropertyAutoTest");
        return engineConfiguration;
    }

    @Test
    public void failWhenSecondEngineDoesNotHaveTheSameHistoryLevel() {
        this.buildEngine(DatabaseHistoryPropertyAutoTest.config("true", "full"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildEngine(DatabaseHistoryPropertyAutoTest.config("audit"))).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyLevel mismatch: configuration says HistoryLevelAudit(name=audit, id=2) and database says HistoryLevelFull(name=full, id=3)");
    }

    @Test
    public void secondEngineCopiesHistoryLevelFromFirst() {
        this.buildEngine(DatabaseHistoryPropertyAutoTest.config("true", "full"));
        ProcessEngineImpl processEngineTwo = this.buildEngine(DatabaseHistoryPropertyAutoTest.config("true", "auto"));
        Assertions.assertThat((String)processEngineTwo.getProcessEngineConfiguration().getHistory()).isSameAs((Object)"auto");
        Assertions.assertThat((Object)processEngineTwo.getProcessEngineConfiguration().getHistoryLevel()).isSameAs((Object)HistoryLevel.HISTORY_LEVEL_FULL);
    }

    @Test
    public void usesDefaultValueAuditWhenNoValueIsConfigured() {
        ProcessEngineConfigurationImpl config = DatabaseHistoryPropertyAutoTest.config("true", "auto");
        ProcessEngineImpl processEngine = this.buildEngine(config);
        Integer level = (Integer)config.getCommandExecutorSchemaOperations().execute((Command)new Command<Integer>(){

            public Integer execute(CommandContext commandContext) {
                return HistoryLevelSetupCommand.databaseHistoryLevel((CommandContext)commandContext);
            }
        });
        Assertions.assertThat((Integer)level).isEqualTo(HistoryLevel.HISTORY_LEVEL_AUDIT.getId());
        Assertions.assertThat((Object)processEngine.getProcessEngineConfiguration().getHistoryLevel()).isEqualTo((Object)HistoryLevel.HISTORY_LEVEL_AUDIT);
    }

    @After
    public void after() {
        for (ProcessEngineImpl engine : this.processEngines) {
            engine.close();
        }
        this.processEngines.clear();
    }

    protected ProcessEngineImpl buildEngine(ProcessEngineConfigurationImpl engineConfiguration) {
        ProcessEngineImpl engine = (ProcessEngineImpl)engineConfiguration.buildProcessEngine();
        this.processEngines.add(engine);
        return engine;
    }
}

