/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricIncidentQueryTest {
    protected static final BpmnModelInstance BPMN = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"failingProcess").startEvent().serviceTask().camundaAsyncBefore()).camundaExpression("${failing}")).endEvent().done();
    protected static final String TENANT_NULL = null;
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deployForTenant(TENANT_NULL, BPMN);
        this.testRule.deployForTenant(TENANT_ONE, BPMN);
        this.testRule.deployForTenant(TENANT_TWO, BPMN);
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_NULL);
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_ONE);
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_TWO);
    }

    @Test
    public void shouldQueryWithoutTenantId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void shouldQueryFilterWithoutTenantId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantId() {
        HistoricIncidentQuery queryTenantOne = this.historyService.createHistoricIncidentQuery().tenantIdIn(new String[]{TENANT_ONE});
        HistoricIncidentQuery queryTenantTwo = this.historyService.createHistoricIncidentQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)queryTenantOne.count()).isEqualTo(1L);
        Assertions.assertThat((long)queryTenantTwo.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantIds() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByNonExistingTenantId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void shouldFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricIncidentQuery().tenantIdIn(new String[]{null});
            Assertions.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void shouldQuerySortingAsc() {
        List historicIncidents = ((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByTenantId().asc()).list();
        Assertions.assertThat((int)historicIncidents.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicIncidents, TestOrderingUtil.historicIncidentByTenantId());
    }

    @Test
    public void shouldQuerySortingDesc() {
        List historicIncidents = ((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByTenantId().desc()).list();
        Assertions.assertThat((int)historicIncidents.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicIncidents, TestOrderingUtil.inverted(TestOrderingUtil.historicIncidentByTenantId()));
    }

    @Test
    public void shouldQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    protected void startProcessInstanceAndExecuteFailingJobForTenant(String tenant) {
        this.runtimeService.createProcessInstanceByKey("failingProcess").processDefinitionTenantId(tenant).execute();
        this.testRule.executeAvailableJobs();
    }
}

