/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class CustomHistoryEventHandlerTest {
    protected static RecorderHistoryEventHandler recorderHandler = new RecorderHistoryEventHandler();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(c -> c.setHistoryEventHandler((HistoryEventHandler)recorderHandler));
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    private RuntimeService runtimeService;
    private TaskService taskService;

    @After
    public void clearHistoryEvents() {
        recorderHandler.clear();
    }

    @Before
    public void initServices() {
        recorderHandler.clear();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReceiveMigrateEvents() {
        VariableMap variables = Variables.createVariables().putValue("foo", (Object)"bar");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)variables);
        String processDefinitionId = processInstance.getProcessDefinitionId();
        String processInstanceId = processInstance.getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId).getActivityInstances("theTask")[0];
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(processDefinitionId, processDefinitionId).mapEqualActivities().build();
        recorderHandler.clear();
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(new String[]{processInstanceId}).execute();
        Assertions.assertThat((int)recorderHandler.size()).isEqualTo(4);
        List<HistoryEvent> processInstanceEvents = recorderHandler.getEventsForEntity(processInstanceId);
        Assertions.assertThat(processInstanceEvents).hasSize(1);
        Assertions.assertThat((String)processInstanceEvents.get(0).getEventType()).isEqualTo((Object)HistoryEventTypes.PROCESS_INSTANCE_MIGRATE.getEventName());
        List<HistoryEvent> activityInstanceEvents = recorderHandler.getEventsForEntity(activityInstance.getId());
        Assertions.assertThat(activityInstanceEvents).hasSize(1);
        Assertions.assertThat((String)activityInstanceEvents.get(0).getEventType()).isEqualTo((Object)HistoryEventTypes.ACTIVITY_INSTANCE_MIGRATE.getEventName());
        List<HistoryEvent> taskEvents = recorderHandler.getEventsForEntity(task.getId());
        Assertions.assertThat(taskEvents).hasSize(1);
        Assertions.assertThat((String)taskEvents.get(0).getEventType()).isEqualTo((Object)HistoryEventTypes.TASK_INSTANCE_MIGRATE.getEventName());
        List<HistoryEvent> variableEvents = recorderHandler.getEventsForEntity(null);
        Assertions.assertThat(variableEvents).hasSize(1);
        Assertions.assertThat((String)variableEvents.get(0).getEventType()).isEqualTo((Object)HistoryEventTypes.VARIABLE_INSTANCE_MIGRATE.getEventName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReceiveMigrateEventForIncident() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processDefinitionId = processInstance.getProcessDefinitionId();
        String processInstanceId = processInstance.getId();
        Incident incident = this.runtimeService.createIncident("foo", processInstanceId, "bar");
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(processDefinitionId, processDefinitionId).mapEqualActivities().build();
        recorderHandler.clear();
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(new String[]{processInstanceId}).execute();
        List<HistoryEvent> incidentEvents = recorderHandler.getEventsForEntity(incident.getId());
        Assertions.assertThat(incidentEvents).hasSize(1);
        Assertions.assertThat((String)incidentEvents.get(0).getEventType()).isEqualTo((Object)HistoryEventTypes.INCIDENT_MIGRATE.getEventName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReceiveHistoricProcessInstanceEventFirstOnFormSubmit() {
        FormService formService = this.engineRule.getFormService();
        RepositoryService repositoryService = this.engineRule.getRepositoryService();
        ProcessDefinition procDef = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().singleResult();
        VariableMap formData = Variables.createVariables().putValue("foo", (Object)"bar");
        formService.submitStartForm(procDef.getId(), (Map)formData);
        List historyEvents = recorderHandler.getEvents().stream().filter(h -> h instanceof HistoricVariableUpdateEventEntity || h instanceof HistoricProcessInstanceEventEntity).collect(Collectors.toList());
        Assertions.assertThat(historyEvents).hasSize(2);
        HistoryEvent processInstanceEvent = (HistoryEvent)historyEvents.get(0);
        HistoryEvent variableInstanceEvent = (HistoryEvent)historyEvents.get(1);
        Assertions.assertThat((Object)processInstanceEvent).isInstanceOf(HistoricProcessInstanceEventEntity.class);
        Assertions.assertThat((String)processInstanceEvent.getEventType()).isEqualTo((Object)"start");
        Assertions.assertThat((Object)variableInstanceEvent).isInstanceOf(HistoricVariableUpdateEventEntity.class);
        Assertions.assertThat((String)variableInstanceEvent.getEventType()).isEqualTo((Object)"create");
    }

    public static class RecorderHistoryEventHandler
    implements HistoryEventHandler {
        private Map<String, List<HistoryEvent>> historyEventsByEntity = new HashMap<String, List<HistoryEvent>>();
        private List<HistoryEvent> historyEvents = new ArrayList<HistoryEvent>();

        public void handleEvent(HistoryEvent historyEvent) {
            CollectionUtil.addToMapOfLists(this.historyEventsByEntity, (Object)historyEvent.getId(), (Object)historyEvent);
            this.historyEvents.add(historyEvent);
        }

        public void handleEvents(List<HistoryEvent> historyEvents) {
            historyEvents.forEach(this::handleEvent);
        }

        public void clear() {
            this.historyEventsByEntity.clear();
            this.historyEvents.clear();
        }

        public List<HistoryEvent> getEventsForEntity(String id) {
            return this.historyEventsByEntity.getOrDefault(id, Collections.emptyList());
        }

        public List<HistoryEvent> getEvents() {
            return this.historyEvents;
        }

        public int size() {
            return this.historyEvents.size();
        }
    }
}

