/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class CaseServiceCaseTaskTest
extends PluggableProcessEngineTest {
    protected final String DEFINITION_KEY = "oneCaseTaskCase";
    protected final String DEFINITION_KEY_2 = "oneTaskCase";
    protected final String CASE_TASK_KEY = "PI_CaseTask_1";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testManualStart() {
        this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNull((Object)subCaseInstance);
        this.caseService.withCaseExecution(caseTaskId).manualStart();
        subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testManualStartWithVariable() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNull((Object)subCaseInstance);
        this.caseService.withCaseExecution(caseTaskId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).manualStart();
        subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        this.verifyVariables(superCaseInstanceId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testManualStartWithVariables() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNull((Object)subCaseInstance);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseTaskId).setVariables(variables).manualStart();
        subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        this.verifyVariables(superCaseInstanceId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testStart() {
        this.createCaseInstance("oneCaseTaskCase").getId();
        this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testStartWithVariable() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase", (Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"abc").putValue("anotherVariableName", (Object)999)).getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        this.verifyVariables(superCaseInstanceId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testStartWithVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase", variables).getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        this.verifyVariables(superCaseInstanceId, result);
    }

    protected void verifyVariables(String superCaseInstanceId, List<VariableInstance> result) {
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)superCaseInstanceId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)superCaseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testManualStartWithLocalVariable() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNull((Object)subCaseInstance);
        this.caseService.withCaseExecution(caseTaskId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseTaskId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)superCaseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testManualStartWithLocalVariables() {
        String superCaseInstanceId = this.createCaseInstance("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNull((Object)subCaseInstance);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseTaskId).setVariablesLocal(variables).manualStart();
        subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseTaskId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)superCaseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testReenableAnEnabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNull((Object)subCaseInstance);
        try {
            this.caseService.withCaseExecution(caseTaskId).reenable();
            Assert.fail((String)"It should not be possible to re-enable an enabled case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskAndOneHumanTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testReenableADisabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNull((Object)subCaseInstance);
        this.caseService.withCaseExecution(caseTaskId).disable();
        this.caseService.withCaseExecution(caseTaskId).reenable();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testReenableAnActiveCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).reenable();
            Assert.fail((String)"It should not be possible to re-enable an active case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskAndOneHumanTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testDisableAnEnabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertNull((Object)subCaseInstance);
        this.caseService.withCaseExecution(caseTaskId).disable();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isDisabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskAndOneHumanTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testDisableADisabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).disable();
        try {
            this.caseService.withCaseExecution(caseTaskId).disable();
            Assert.fail((String)"It should not be possible to disable a already disabled case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testDisableAnActiveCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).disable();
            Assert.fail((String)"It should not be possible to disable an active case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskAndOneHumanTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testManualStartOfADisabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).disable();
        try {
            this.caseService.withCaseExecution(caseTaskId).manualStart();
            Assert.fail((String)"It should not be possible to start a disabled case task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testManualStartOfAnActiveCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).manualStart();
            Assert.fail((String)"It should not be possible to start an already active case task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testComplete() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).complete();
            Assert.fail((String)"It should not be possible to complete a case task, while the process instance is still running.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCloseCaseInstanceShouldCompleteCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        CaseInstance subCaseInstance = this.queryCaseInstanceByKey("oneTaskCase");
        Assert.assertTrue((boolean)subCaseInstance.isCompleted());
        this.caseService.withCaseExecution(subCaseInstance.getId()).close();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertNull((Object)caseTask);
        CaseInstance superCaseInstance = this.queryCaseInstanceByKey("oneCaseTaskCase");
        Assert.assertNotNull((Object)superCaseInstance);
        Assert.assertTrue((boolean)superCaseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testDisableShouldCompleteCaseInstance() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).disable();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        CaseInstance superCaseInstance = this.queryCaseInstanceByKey("oneCaseTaskCase");
        Assert.assertNotNull((Object)superCaseInstance);
        Assert.assertTrue((boolean)superCaseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testCompleteAnEnabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).complete();
            Assert.fail((String)"Should not be able to complete an enabled case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskAndOneHumanTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testCompleteADisabledCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).disable();
        try {
            this.caseService.withCaseExecution(caseTaskId).complete();
            Assert.fail((String)"Should not be able to complete a disabled case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testClose() {
        this.createCaseInstance("oneCaseTaskCase");
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).close();
            Assert.fail((String)"It should not be possible to close a case task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testTerminate() {
        this.createCaseInstance("oneCaseTaskCase");
        CaseExecution caseTaskExecution = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        this.caseService.withCaseExecution(caseTaskExecution.getId()).terminate();
        caseTaskExecution = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertNull((Object)caseTaskExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testTerminateNonFluent() {
        this.createCaseInstance("oneCaseTaskCase");
        CaseExecution caseTaskExecution = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        this.caseService.terminateCaseExecution(caseTaskExecution.getId());
        caseTaskExecution = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertNull((Object)caseTaskExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testTerminateNonActiveCaseTask() {
        this.createCaseInstance("oneCaseTaskCase");
        CaseExecution caseTaskExecution = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        try {
            this.caseService.terminateCaseExecution(caseTaskExecution.getId());
            Assert.fail((String)"It should not be possible to terminate a case task.");
        }
        catch (NotAllowedException e) {
            boolean result = e.getMessage().contains("The case execution must be in state 'active' to terminate");
            Assert.assertTrue((boolean)result);
        }
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey) {
        return this.caseService.withCaseDefinitionByKey(caseDefinitionKey).create();
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey, Map<String, Object> variables) {
        return this.caseService.withCaseDefinitionByKey(caseDefinitionKey).setVariables(variables).create();
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }

    protected CaseInstance queryCaseInstanceByKey(String caseDefinitionKey) {
        return (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey(caseDefinitionKey).singleResult();
    }

    protected Task queryTask() {
        return (Task)this.taskService.createTaskQuery().singleResult();
    }
}

