/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.test.api.multitenancy.listener.AssertingCaseExecutionListener;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Test;

public class MultiTenancyDelegateCaseExecutionTest
extends PluggableProcessEngineTest {
    protected static final String HUMAN_TASK_CMMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/HumanTaskCaseExecutionListener.cmmn";
    protected static final String CASE_TASK_CMMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/CaseTaskCaseExecutionListener.cmmn";
    protected static final String CMMN_FILE = "org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn";
    protected static final String TENANT_ID = "tenant1";

    @After
    public void tearDown() throws Exception {
        AssertingCaseExecutionListener.clear();
    }

    @Test
    public void testSingleExecution() {
        this.testRule.deployForTenant(TENANT_ID, HUMAN_TASK_CMMN_FILE);
        AssertingCaseExecutionListener.addAsserts(MultiTenancyDelegateCaseExecutionTest.hasTenantId(TENANT_ID));
        this.testRule.createCaseInstanceByKey("case");
    }

    @Test
    public void testCallCaseTask() {
        this.testRule.deployForTenant(TENANT_ID, CMMN_FILE);
        this.testRule.deploy(CASE_TASK_CMMN_FILE);
        AssertingCaseExecutionListener.addAsserts(MultiTenancyDelegateCaseExecutionTest.hasTenantId(TENANT_ID));
        this.testRule.createCaseInstanceByKey("oneCaseTaskCase");
    }

    protected static AssertingCaseExecutionListener.DelegateCaseExecutionAsserter hasTenantId(String expectedTenantId) {
        return execution -> Assertions.assertThat((String)execution.getTenantId()).isEqualTo((Object)expectedTenantId);
    }
}

