/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.CommentEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Event;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskEventsTest
extends AbstractUserOperationLogTest {
    static String JONNY = "jonny";
    static String ACCOUNTING = "accounting";
    static String IMAGE_PNG = "application/png";
    static String IMAGE_NAME = "my-image.png";
    static String IMAGE_DESC = "a super duper image";
    static String IMAGE_URL = "file://some/location/my-image.png";
    private Task task;

    @Before
    public void setUp() throws Exception {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
    }

    @After
    public void tearDown() throws Exception {
        this.taskService.deleteTask(this.task.getId(), true);
    }

    @Test
    public void testAddUserLinkEvents() {
        Assert.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.taskService.addCandidateUser(this.task.getId(), JONNY);
        List events = this.taskService.getTaskEvents(this.task.getId());
        Assert.assertEquals((long)1L, (long)events.size());
        Event event = (Event)events.get(0);
        Assert.assertEquals((Object)JONNY, event.getMessageParts().get(0));
        Assert.assertEquals((Object)"candidate", event.getMessageParts().get(1));
        Assert.assertEquals((Object)this.task.getId(), (Object)event.getTaskId());
        Assert.assertEquals((Object)"AddUserLink", (Object)event.getAction());
        Assert.assertEquals((Object)(JONNY + CommentEntity.MESSAGE_PARTS_MARKER + "candidate"), (Object)event.getMessage());
        Assert.assertEquals(null, (Object)event.getProcessInstanceId());
        Assert.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    @Test
    public void testDeleteUserLinkEvents() {
        Assert.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.taskService.addCandidateUser(this.task.getId(), JONNY);
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 5000L));
        this.taskService.deleteCandidateUser(this.task.getId(), JONNY);
        List events = this.taskService.getTaskEvents(this.task.getId());
        Assert.assertEquals((long)2L, (long)events.size());
        Event event = (Event)events.get(0);
        Assert.assertEquals((Object)JONNY, event.getMessageParts().get(0));
        Assert.assertEquals((Object)"candidate", event.getMessageParts().get(1));
        Assert.assertEquals((Object)this.task.getId(), (Object)event.getTaskId());
        Assert.assertEquals((Object)"DeleteUserLink", (Object)event.getAction());
        Assert.assertEquals((Object)(JONNY + CommentEntity.MESSAGE_PARTS_MARKER + "candidate"), (Object)event.getMessage());
        Assert.assertEquals(null, (Object)event.getProcessInstanceId());
        Assert.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    @Test
    public void testAddGroupLinkEvents() {
        Assert.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.taskService.addCandidateGroup(this.task.getId(), ACCOUNTING);
        List events = this.taskService.getTaskEvents(this.task.getId());
        Assert.assertEquals((long)1L, (long)events.size());
        Event event = (Event)events.get(0);
        Assert.assertEquals((Object)ACCOUNTING, event.getMessageParts().get(0));
        Assert.assertEquals((Object)"candidate", event.getMessageParts().get(1));
        Assert.assertEquals((Object)this.task.getId(), (Object)event.getTaskId());
        Assert.assertEquals((Object)"AddGroupLink", (Object)event.getAction());
        Assert.assertEquals((Object)(ACCOUNTING + CommentEntity.MESSAGE_PARTS_MARKER + "candidate"), (Object)event.getMessage());
        Assert.assertEquals(null, (Object)event.getProcessInstanceId());
        Assert.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    @Test
    public void testDeleteGroupLinkEvents() {
        Assert.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.taskService.addCandidateGroup(this.task.getId(), ACCOUNTING);
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 5000L));
        this.taskService.deleteCandidateGroup(this.task.getId(), ACCOUNTING);
        List events = this.taskService.getTaskEvents(this.task.getId());
        Assert.assertEquals((long)2L, (long)events.size());
        Event event = (Event)events.get(0);
        Assert.assertEquals((Object)ACCOUNTING, event.getMessageParts().get(0));
        Assert.assertEquals((Object)"candidate", event.getMessageParts().get(1));
        Assert.assertEquals((Object)this.task.getId(), (Object)event.getTaskId());
        Assert.assertEquals((Object)"DeleteGroupLink", (Object)event.getAction());
        Assert.assertEquals((Object)(ACCOUNTING + CommentEntity.MESSAGE_PARTS_MARKER + "candidate"), (Object)event.getMessage());
        Assert.assertEquals(null, (Object)event.getProcessInstanceId());
        Assert.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    @Test
    public void testAddAttachmentEvents() {
        Assert.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.identityService.setAuthenticatedUserId(JONNY);
        this.taskService.createAttachment(IMAGE_PNG, this.task.getId(), null, IMAGE_NAME, IMAGE_DESC, IMAGE_URL);
        List events = this.taskService.getTaskEvents(this.task.getId());
        Assert.assertEquals((long)1L, (long)events.size());
        Event event = (Event)events.get(0);
        Assert.assertEquals((long)1L, (long)event.getMessageParts().size());
        Assert.assertEquals((Object)IMAGE_NAME, event.getMessageParts().get(0));
        Assert.assertEquals((Object)this.task.getId(), (Object)event.getTaskId());
        Assert.assertEquals((Object)"AddAttachment", (Object)event.getAction());
        Assert.assertEquals((Object)IMAGE_NAME, (Object)event.getMessage());
        Assert.assertEquals(null, (Object)event.getProcessInstanceId());
        Assert.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    @Test
    public void testDeleteAttachmentEvents() {
        Assert.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.identityService.setAuthenticatedUserId(JONNY);
        Attachment attachment = this.taskService.createAttachment(IMAGE_PNG, this.task.getId(), null, IMAGE_NAME, IMAGE_DESC, IMAGE_URL);
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 5000L));
        this.taskService.deleteAttachment(attachment.getId());
        List events = this.taskService.getTaskEvents(this.task.getId());
        Assert.assertEquals((long)2L, (long)events.size());
        Event event = (Event)events.get(0);
        Assert.assertEquals((long)1L, (long)event.getMessageParts().size());
        Assert.assertEquals((Object)IMAGE_NAME, event.getMessageParts().get(0));
        Assert.assertEquals((Object)this.task.getId(), (Object)event.getTaskId());
        Assert.assertEquals((Object)"DeleteAttachment", (Object)event.getAction());
        Assert.assertEquals((Object)IMAGE_NAME, (Object)event.getMessage());
        Assert.assertEquals(null, (Object)event.getProcessInstanceId());
        Assert.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    private void assertNoCommentsForTask() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                Assert.assertTrue((boolean)commandContext.getCommentManager().findCommentsByTaskId(TaskEventsTest.this.task.getId()).isEmpty());
                return null;
            }
        });
    }
}

