/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.CrdbTransactionRetryException;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.FetchExternalTasksCmd;
import org.camunda.bpm.engine.impl.externaltask.TopicFetchInstruction;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CompetingExternalTaskFetchingTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;

    @Before
    public void initializeServices() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Deployment
    @Test
    public void testCompetingExternalTaskFetching() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTaskFetcherThread thread1 = new ExternalTaskFetcherThread("thread1", 5, "externalTaskTopic");
        ExternalTaskFetcherThread thread2 = new ExternalTaskFetcherThread("thread2", 5, "externalTaskTopic");
        thread1.startAndWaitUntilControlIsReturned();
        thread2.startAndWaitUntilControlIsReturned();
        thread1.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)thread1.exception));
        Assert.assertEquals((long)1L, (long)thread1.fetchedTasks.size());
        thread2.proceedAndWaitTillDone();
        Assert.assertEquals((long)0L, (long)thread2.fetchedTasks.size());
        if (this.testRule.isOptimisticLockingExceptionSuppressible()) {
            Assert.assertNull((Object)((Object)thread2.exception));
        } else {
            Assert.assertTrue((boolean)(thread2.exception instanceof CrdbTransactionRetryException));
        }
    }

    public class ExternalTaskFetcherThread
    extends ControllableThread {
        protected String workerId;
        protected int results;
        protected String topic;
        protected List<LockedExternalTask> fetchedTasks = Collections.emptyList();
        protected OptimisticLockingException exception;

        public ExternalTaskFetcherThread(String workerId, int results, String topic) {
            this.workerId = workerId;
            this.results = results;
            this.topic = topic;
        }

        @Override
        public void run() {
            HashMap<String, TopicFetchInstruction> instructions = new HashMap<String, TopicFetchInstruction>();
            TopicFetchInstruction instruction = new TopicFetchInstruction(this.topic, 10000L);
            instructions.put(this.topic, instruction);
            ControlledCommand cmd = new ControlledCommand((ControllableThread)Thread.currentThread(), new FetchExternalTasksCmd(this.workerId, this.results, instructions));
            try {
                this.fetchedTasks = (List)CompetingExternalTaskFetchingTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(cmd);
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
        }
    }
}

