/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;
import org.junit.Before;
import org.junit.Test;

@Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/JobExecutorAcquireJobsForPriorityRangeTest.jobPrioProcess.bpmn20.xml"})
public class JobExecutorAcquireJobsForPriorityRangeTest
extends AbstractJobExecutorAcquireJobsTest {
    @Before
    public void setUp() {
        this.configuration.setJobExecutorAcquireByPriority(true);
        this.createJobs();
    }

    @Test
    public void shouldAcquireAllJobsNoBounds() {
        int i;
        this.configuration.setJobExecutorPriorityRangeMin(null);
        this.configuration.setJobExecutorPriorityRangeMax(null);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(10);
        for (i = 0; i < 5; ++i) {
            Assertions.assertThat((long)this.findJobById(acquirableJobs.get(i).getId()).getPriority()).isEqualTo(10L);
        }
        for (i = 5; i < 10; ++i) {
            Assertions.assertThat((long)this.findJobById(acquirableJobs.get(i).getId()).getPriority()).isEqualTo(5L);
        }
    }

    @Test
    public void shouldAcquireOnlyJobsInRangeWithUpperBound() {
        this.configuration.setJobExecutorPriorityRangeMin(null);
        this.configuration.setJobExecutorPriorityRangeMax(Long.valueOf(7L));
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(5);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertThat((long)this.findJobById(acquirableJobs.get(i).getId()).getPriority()).isEqualTo(5L);
        }
    }

    @Test
    public void shouldAcquireOnlyJobsInRangeWithLowerBound() {
        this.configuration.setJobExecutorPriorityRangeMin(Long.valueOf(7L));
        this.configuration.setJobExecutorPriorityRangeMax(null);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(5);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertThat((long)this.findJobById(acquirableJobs.get(i).getId()).getPriority()).isEqualTo(10L);
        }
    }

    @Test
    public void shouldAcquireOnlyJobsInBoundWithUpperAndLowerBound() {
        this.configuration.setJobExecutorPriorityRangeMin(Long.valueOf(7L));
        this.configuration.setJobExecutorPriorityRangeMax(Long.valueOf(12L));
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(5);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertThat((long)this.findJobById(acquirableJobs.get(i).getId()).getPriority()).isEqualTo(10L);
        }
    }

    @Test
    public void shouldAcquireOnlyJobsInBoundWithUpperAndLowerBoundNoJobsFound() {
        this.configuration.setJobExecutorPriorityRangeMin(Long.valueOf(12L));
        this.configuration.setJobExecutorPriorityRangeMax(Long.valueOf(15L));
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(0);
    }

    private void createJobs() {
        this.startProcess("jobPrioProcess", "task1", 5);
        this.startProcess("jobPrioProcess", "task2", 5);
    }
}

