/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobExecutorCleanupTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ProcessEngineConfigurationImpl configuration;

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.configuration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void resetConfig() {
        this.configuration.setHistoryCleanupEnabled(true);
    }

    @Test
    public void shouldNotExecuteCleanupJob() {
        this.historyService.cleanUpHistoryAsync(true);
        this.configuration.setHistoryCleanupEnabled(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRule.waitForJobExecutorToProcessAllJobs()).isInstanceOf(AssertionError.class)).hasMessageContaining("time limit of 10000 was exceeded");
    }

    @After
    public void resetDatabase() {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                String handlerType = "history-cleanup";
                List jobsByHandlerType = commandContext.getJobManager().findJobsByHandlerType(handlerType);
                for (Job job : jobsByHandlerType) {
                    commandContext.getJobManager().deleteJob((JobEntity)job);
                }
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType(handlerType);
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
    }
}

