/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class BatchRule
extends TestWatcher {
    protected ProcessEngineRule engineRule;
    protected ProcessEngineTestRule engineTestRule;
    protected List<String> batchIds = new ArrayList<String>();

    public BatchRule(ProcessEngineRule engineRule, ProcessEngineTestRule engineTestRule) {
        this.engineRule = engineRule;
        this.engineTestRule = engineTestRule;
    }

    protected void finished(Description description) {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(1);
        ClockUtil.reset();
        this.clearDatabase();
    }

    public void clearDatabase() {
        if (!this.batchIds.isEmpty()) {
            for (String batchId : this.batchIds) {
                HistoricBatch historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().batchId(batchId).singleResult();
                if (historicBatch == null) continue;
                this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
            }
        }
    }

    public void syncExec(Batch batch) {
        this.syncExec(batch, true);
    }

    public void syncExec(Batch batch, boolean isClear) {
        if (isClear) {
            this.batchIds.add(batch.getId());
        }
        this.executeSeedJobs(batch);
        List<Job> jobs = this.getExecutionJobs(batch);
        for (Job job : jobs) {
            this.engineRule.getManagementService().executeJob(job.getId());
        }
        this.engineRule.getManagementService().executeJob(this.getJobForDefinition(batch.getMonitorJobDefinitionId()).getId());
    }

    public void executeSeedJobs(Batch batch) {
        while (this.getSeedJob(batch) != null) {
            this.engineRule.getManagementService().executeJob(this.getSeedJob(batch).getId());
        }
    }

    public Job getSeedJob(Batch batch) {
        return this.getJobForDefinition(batch.getSeedJobDefinitionId());
    }

    protected Job getJobForDefinition(String definitionId) {
        return (Job)this.engineRule.getManagementService().createJobQuery().jobDefinitionId(definitionId).singleResult();
    }

    public List<Job> getExecutionJobs(Batch batch) {
        return this.engineRule.getManagementService().createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list();
    }
}

