/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatisticsQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessDefinitionStatisticsAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Test
    public void testQueryWithoutAuthorizations() {
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryWithReadPermissionOnOneTaskProcess() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        this.verifyQueryResults(query, 1);
        ProcessDefinitionStatistics statistics = (ProcessDefinitionStatistics)query.singleResult();
        Assert.assertEquals((Object)ONE_TASK_PROCESS_KEY, (Object)statistics.getKey());
        Assert.assertEquals((long)0L, (long)statistics.getInstances());
        Assert.assertEquals((long)0L, (long)statistics.getFailedJobs());
        Assert.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    @Test
    public void testQueryWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryWithReadPermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        this.verifyQueryResults(query, 2);
        List statistics = query.list();
        for (ProcessDefinitionStatistics result : statistics) {
            this.verifyStatisticsResult(result, 0, 0, 0);
        }
    }

    @Test
    public void testQueryIncludingInstancesWithoutProcessInstanceAuthorizations() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 0, 0);
    }

    @Test
    public void testQueryIncludingFailedJobsWithoutProcessInstanceAuthorizations() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 3, 0);
    }

    @Test
    public void testQueryIncludingIncidentsWithoutProcessInstanceAuthorizations() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 0, 3);
    }

    @Test
    public void testQueryIncludingIncidentsAndFailedJobsWithoutProcessInstanceAuthorizations() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 3, 3);
    }

    protected void verifyQueryResults(ProcessDefinitionStatisticsQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyStatisticsResult(ProcessDefinitionStatistics statistics, int instances, int failedJobs, int incidents) {
        Assert.assertEquals((String)"Instances", (long)instances, (long)statistics.getInstances());
        Assert.assertEquals((String)"Failed Jobs", (long)failedJobs, (long)statistics.getFailedJobs());
        List incidentStatistics = statistics.getIncidentStatistics();
        if (incidents == 0) {
            Assert.assertTrue((String)"Incidents supposed to be empty", (boolean)incidentStatistics.isEmpty());
        } else {
            Assert.assertEquals((String)"Incidents", (long)incidents, (long)((IncidentStatistics)incidentStatistics.get(0)).getIncidentCount());
        }
    }

    protected ProcessDefinitionStatistics getStatisticsByKey(List<ProcessDefinitionStatistics> statistics, String key) {
        for (ProcessDefinitionStatistics result : statistics) {
            if (!key.equals(result.getKey())) continue;
            return result;
        }
        Assert.fail((String)("No statistics found for key '" + key + "'."));
        return null;
    }
}

