/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyDeploymentQueryTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() throws Exception {
        BpmnModelInstance emptyProcess = Bpmn.createExecutableProcess().startEvent().done();
        this.testRule.deploy(emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_TWO, emptyProcess);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByTenantId() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIds() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void testQueryWithoutTenantId() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIdsIncludeDeploymentsWithoutTenantId() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{TENANT_ONE}).includeDeploymentsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{TENANT_TWO}).includeDeploymentsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDeploymentsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List deployments = ((DeploymentQuery)this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat((String)((Deployment)deployments.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((Deployment)deployments.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void testQuerySortingDesc() {
        List deployments = ((DeploymentQuery)this.repositoryService.createDeploymentQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat((String)((Deployment)deployments.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((Deployment)deployments.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDeploymentsWithoutTenantId().count()).isEqualTo(2L);
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }
}

