/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ProcessInstantiationAtActivitiesTest
extends PluggableProcessEngineTest {
    protected static final String PARALLEL_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml";
    protected static final String EXCLUSIVE_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml";
    protected static final String SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml";
    protected static final String LISTENERS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.listeners.bpmn20.xml";
    protected static final String IO_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.ioMappings.bpmn20.xml";
    protected static final String ASYNC_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml";
    protected static final String SYNC_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.synchronous.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testSingleActivityInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task1")).execute();
        Assert.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").done());
        this.completeTasksInOrder("task1");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testSingleActivityInstantiationById() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("task1")).execute();
        Assert.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").done());
        this.completeTasksInOrder("task1");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testSingleActivityInstantiationSetBusinessKey() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").businessKey("businessKey").startBeforeActivity("task1")).execute();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"businessKey", (Object)instance.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testSingleActivityInstantiationSetCaseInstanceId() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").caseInstanceId("caseInstanceId").startBeforeActivity("task1")).execute();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"caseInstanceId", (Object)instance.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartEventInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("theStart")).execute();
        Assert.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").done());
        this.completeTasksInOrder("task1");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartEventInstantiationWithVariables() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("theStart")).setVariable("aVariable", (Object)"aValue")).execute();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"aValue", (Object)this.runtimeService.getVariable(instance.getId(), "aVariable"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartWithInvalidInitialActivity() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("someNonExistingActivity")).execute();
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresentIgnoreCase("element 'someNonExistingActivity' does not exist in process ", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testMultipleActivitiesInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task1")).startBeforeActivity("task2")).startBeforeActivity("task1")).execute();
        Assert.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").activity("task2").activity("task1").done());
        this.completeTasksInOrder("task1", "task2", "task1");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testMultipleActivitiesInstantiationWithVariables() {
        ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task1")).setVariableLocal("aVar1", (Object)"aValue1")).startBeforeActivity("task2")).setVariableLocal("aVar2", (Object)"aValue2")).execute();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        Assert.assertNotNull((Object)task2Execution);
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(task2Execution.getId(), "aVar1"));
        Assert.assertEquals((Object)"aValue2", (Object)this.runtimeService.getVariableLocal(task2Execution.getId(), "aVar2"));
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        Assert.assertNotNull((Object)task1Execution);
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(task1Execution.getId(), "aVar2"));
        Assert.assertNull((Object)this.runtimeService.getVariableLocal(task1Execution.getId(), "aVar1"));
        Assert.assertEquals((Object)"aValue1", (Object)this.runtimeService.getVariable(task1Execution.getId(), "aVar1"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    @Test
    public void testNestedActivitiesInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("subprocess").startBeforeActivity("innerTask")).startBeforeActivity("outerTask")).startBeforeActivity("innerTask")).execute();
        Assert.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").activity("innerTask").done());
        this.completeTasksInOrder("innerTask", "innerTask", "outerTask", "innerTask");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Test
    public void testStartNonExistingProcessDefinition() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById("I don't exist").startBeforeActivity("start")).execute();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("no deployed process definition found with id", e.getMessage());
        }
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("I don't exist either").startBeforeActivity("start")).execute();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("no processes deployed with key", e.getMessage());
        }
    }

    @Test
    public void testStartNullProcessDefinition() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(null).startBeforeActivity("start")).execute();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(null).startBeforeActivity("start")).execute();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.listeners.bpmn20.xml"})
    @Test
    public void testListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("listenerProcess").startBeforeActivity("innerTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask").done());
        List<RecorderExecutionListener.RecordedEvent> events = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)3L, (long)events.size());
        RecorderExecutionListener.RecordedEvent processStartEvent = events.get(0);
        Assert.assertEquals((Object)"start", (Object)processStartEvent.getEventName());
        Assert.assertEquals((Object)"innerTask", (Object)processStartEvent.getActivityId());
        RecorderExecutionListener.RecordedEvent subProcessStartEvent = events.get(1);
        Assert.assertEquals((Object)"start", (Object)subProcessStartEvent.getEventName());
        Assert.assertEquals((Object)"subProcess", (Object)subProcessStartEvent.getActivityId());
        RecorderExecutionListener.RecordedEvent innerTaskStartEvent = events.get(2);
        Assert.assertEquals((Object)"start", (Object)innerTaskStartEvent.getEventName());
        Assert.assertEquals((Object)"innerTask", (Object)innerTaskStartEvent.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.listeners.bpmn20.xml"})
    @Test
    public void testSkipListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("listenerProcess").startBeforeActivity("innerTask")).execute(true, true);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask").done());
        List<RecorderExecutionListener.RecordedEvent> events = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)0L, (long)events.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.ioMappings.bpmn20.xml"})
    @Test
    public void testIoMappingInvocation() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("ioProcess").startBeforeActivity("innerTask")).execute();
        List variables = ((VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableName().asc()).list();
        Assert.assertEquals((long)2L, (long)variables.size());
        Execution innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        VariableInstance innerTaskVariable = (VariableInstance)variables.get(0);
        Assert.assertEquals((Object)"innerTaskVariable", (Object)innerTaskVariable.getName());
        Assert.assertEquals((Object)"innerTaskValue", (Object)innerTaskVariable.getValue());
        Assert.assertEquals((Object)innerTaskExecution.getId(), (Object)innerTaskVariable.getExecutionId());
        VariableInstance subProcessVariable = (VariableInstance)variables.get(1);
        Assert.assertEquals((Object)"subProcessVariable", (Object)subProcessVariable.getName());
        Assert.assertEquals((Object)"subProcessValue", (Object)subProcessVariable.getValue());
        Assert.assertEquals((Object)((ExecutionEntity)innerTaskExecution).getParentId(), (Object)subProcessVariable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.ioMappings.bpmn20.xml"})
    @Test
    public void testSkipIoMappingInvocation() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("ioProcess").startBeforeActivity("innerTask")).execute(true, true);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    @Test
    public void testSetProcessInstanceVariable() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("subprocess").setVariable("aVariable1", (Object)"aValue1")).setVariableLocal("aVariable2", (Object)"aValue2")).setVariables((Map)Variables.createVariables().putValue("aVariable3", (Object)"aValue3"))).setVariablesLocal((Map)Variables.createVariables().putValue("aVariable4", (Object)"aValue4"))).startBeforeActivity("innerTask")).execute();
        List variables = ((VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableName().asc()).list();
        Assert.assertEquals((long)4L, (long)variables.size());
        Assert.assertEquals((Object)"aVariable1", (Object)((VariableInstance)variables.get(0)).getName());
        Assert.assertEquals((Object)"aValue1", (Object)((VariableInstance)variables.get(0)).getValue());
        Assert.assertEquals((Object)instance.getId(), (Object)((VariableInstance)variables.get(0)).getExecutionId());
        Assert.assertEquals((Object)"aVariable2", (Object)((VariableInstance)variables.get(1)).getName());
        Assert.assertEquals((Object)"aValue2", (Object)((VariableInstance)variables.get(1)).getValue());
        Assert.assertEquals((Object)instance.getId(), (Object)((VariableInstance)variables.get(1)).getExecutionId());
        Assert.assertEquals((Object)"aVariable3", (Object)((VariableInstance)variables.get(2)).getName());
        Assert.assertEquals((Object)"aValue3", (Object)((VariableInstance)variables.get(2)).getValue());
        Assert.assertEquals((Object)instance.getId(), (Object)((VariableInstance)variables.get(2)).getExecutionId());
        Assert.assertEquals((Object)"aVariable4", (Object)((VariableInstance)variables.get(3)).getName());
        Assert.assertEquals((Object)"aValue4", (Object)((VariableInstance)variables.get(3)).getValue());
        Assert.assertEquals((Object)instance.getId(), (Object)((VariableInstance)variables.get(3)).getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml"})
    @Test
    public void testStartAsyncTask() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task2")).execute();
        Assert.assertNotNull((Object)instance);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).transition("task2").done());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.completeTasksInOrder("task2");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstantiationAtActivitiesTest.synchronous.bpmn20.xml"})
    @Test
    public void testStartMultipleTasksInSyncProcess() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("syncProcess").startBeforeActivity("syncTask")).startBeforeActivity("syncTask")).startBeforeActivity("syncTask")).execute();
        Assert.assertNotNull((Object)instance);
        this.testRule.assertProcessEnded(instance.getId());
        List<RecorderExecutionListener.RecordedEvent> events = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)8L, (long)events.size());
        Assert.assertEquals((Object)"start", (Object)events.get(0).getEventName());
        Assert.assertEquals((Object)"syncTask", (Object)events.get(0).getActivityId());
        Assert.assertEquals((Object)"start", (Object)events.get(1).getEventName());
        Assert.assertEquals((Object)"syncTask", (Object)events.get(1).getActivityId());
        Assert.assertEquals((Object)"end", (Object)events.get(2).getEventName());
        Assert.assertEquals((Object)"syncTask", (Object)events.get(2).getActivityId());
        Assert.assertEquals((Object)"start", (Object)events.get(3).getEventName());
        Assert.assertEquals((Object)"syncTask", (Object)events.get(3).getActivityId());
        Assert.assertEquals((Object)"end", (Object)events.get(4).getEventName());
        Assert.assertEquals((Object)"syncTask", (Object)events.get(4).getActivityId());
        Assert.assertEquals((Object)"start", (Object)events.get(5).getEventName());
        Assert.assertEquals((Object)"syncTask", (Object)events.get(5).getActivityId());
        Assert.assertEquals((Object)"end", (Object)events.get(6).getEventName());
        Assert.assertEquals((Object)"syncTask", (Object)events.get(6).getActivityId());
        Assert.assertEquals((Object)"end", (Object)events.get(7).getEventName());
        Assert.assertEquals((Object)"end", (Object)events.get(7).getActivityId());
    }

    @Deployment
    @Test
    public void testInitiatorVariable() {
        this.identityService.setAuthenticatedUserId("kermit");
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("initiatorProcess").startBeforeActivity("task")).execute();
        String initiator = (String)this.runtimeService.getVariable(instance.getId(), "initiator");
        Assert.assertEquals((Object)"kermit", (Object)initiator);
        this.identityService.clearAuthentication();
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            Assert.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

