/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.filter;

import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class FilterAuthorizationsTest
extends PluggableProcessEngineTest {
    protected User testUser;
    protected Authorization createAuthorization;
    protected Authorization updateAuthorization;
    protected Authorization readAuthorization;
    protected Authorization deleteAuthorization;

    @Before
    public void setUp() {
        this.testUser = this.createTestUser("test");
        this.createAuthorization = this.createAuthorization((Permission)Permissions.CREATE, "*");
        this.updateAuthorization = this.createAuthorization((Permission)Permissions.UPDATE, null);
        this.readAuthorization = this.createAuthorization((Permission)Permissions.READ, null);
        this.deleteAuthorization = this.createAuthorization((Permission)Permissions.DELETE, null);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(this.testUser.getId());
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        for (Filter filter : this.filterService.createFilterQuery().list()) {
            this.filterService.deleteFilter(filter.getId());
        }
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    @Test
    public void testCreateFilterNotPermitted() {
        try {
            this.filterService.newTaskFilter();
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFilterPermitted() {
        this.grantCreateFilter();
        Filter filter = this.filterService.newTaskFilter();
        Assert.assertNotNull((Object)filter);
    }

    @Test
    public void testSaveFilterNotPermitted() {
        FilterEntity filter = new FilterEntity("Task");
        try {
            this.filterService.saveFilter((Filter)filter);
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testSaveFilterPermitted() {
        Filter filter = new FilterEntity("Task").setName("testFilter");
        this.grantCreateFilter();
        this.filterService.saveFilter(filter);
        Assert.assertNotNull((Object)filter.getId());
    }

    @Test
    public void testUpdateFilterNotPermitted() {
        Filter filter = this.createTestFilter();
        filter.setName("anotherName");
        try {
            this.filterService.saveFilter(filter);
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateFilterPermitted() {
        Filter filter = this.createTestFilter();
        filter.setName("anotherName");
        this.grantUpdateFilter(filter.getId());
        filter = this.filterService.saveFilter(filter);
        Assert.assertEquals((Object)"anotherName", (Object)filter.getName());
    }

    @Test
    public void testDeleteFilterNotPermitted() {
        Filter filter = this.createTestFilter();
        try {
            this.filterService.deleteFilter(filter.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteFilterPermitted() {
        Filter filter = this.createTestFilter();
        this.grantDeleteFilter(filter.getId());
        this.filterService.deleteFilter(filter.getId());
        long count = this.filterService.createFilterQuery().count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testReadFilterNotPermitted() {
        Filter filter = this.createTestFilter();
        long count = this.filterService.createFilterQuery().count();
        Assert.assertEquals((long)0L, (long)count);
        Filter returnedFilter = (Filter)this.filterService.createFilterQuery().filterId(filter.getId()).singleResult();
        Assert.assertNull((Object)returnedFilter);
        try {
            this.filterService.getFilter(filter.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
        try {
            this.filterService.singleResult(filter.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
        try {
            this.filterService.list(filter.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
        try {
            this.filterService.listPage(filter.getId(), 1, 2);
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
        try {
            this.filterService.count(filter.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testReadFilterPermitted() {
        Filter filter = this.createTestFilter();
        this.grantReadFilter(filter.getId());
        long count = this.filterService.createFilterQuery().count();
        Assert.assertEquals((long)1L, (long)count);
        Filter returnedFilter = (Filter)this.filterService.createFilterQuery().filterId(filter.getId()).singleResult();
        Assert.assertNotNull((Object)returnedFilter);
        returnedFilter = this.filterService.getFilter(filter.getId());
        Assert.assertNotNull((Object)returnedFilter);
        Task task = this.taskService.newTask("test");
        this.taskService.saveTask(task);
        Task result = (Task)this.filterService.singleResult(filter.getId());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)task.getId(), (Object)result.getId());
        List resultList = this.filterService.list(filter.getId());
        Assert.assertNotNull((Object)resultList);
        Assert.assertEquals((long)1L, (long)resultList.size());
        Assert.assertEquals((Object)task.getId(), (Object)((Task)resultList.get(0)).getId());
        resultList = this.filterService.listPage(filter.getId(), 0, 2);
        Assert.assertNotNull((Object)resultList);
        Assert.assertEquals((long)1L, (long)resultList.size());
        Assert.assertEquals((Object)task.getId(), (Object)((Task)resultList.get(0)).getId());
        count = this.filterService.count(filter.getId());
        Assert.assertEquals((long)1L, (long)count);
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testReadFilterPermittedWithMultiple() {
        Filter filter = this.createTestFilter();
        this.grantReadFilter(filter.getId());
        Authorization authorization = this.processEngine.getAuthorizationService().createNewAuthorization(1);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.setUserId("*");
        authorization.setResource((Resource)Resources.FILTER);
        authorization.setResourceId("*");
        this.processEngine.getAuthorizationService().saveAuthorization(authorization);
        long count = this.filterService.createFilterQuery().count();
        Assert.assertEquals((long)1L, (long)count);
        Filter returnedFilter = (Filter)this.filterService.createFilterQuery().filterId(filter.getId()).singleResult();
        Assert.assertNotNull((Object)returnedFilter);
        returnedFilter = this.filterService.getFilter(filter.getId());
        Assert.assertNotNull((Object)returnedFilter);
        this.processEngine.getAuthorizationService().deleteAuthorization(authorization.getId());
    }

    @Test
    public void testDefaultFilterAuthorization() {
        User ownerUser = this.createTestUser("ownerUser");
        User anotherUser = this.createTestUser("anotherUser");
        this.grantCreateFilter();
        Filter filter = this.filterService.newTaskFilter("testFilter");
        filter.setOwner(ownerUser.getId());
        this.filterService.saveFilter(filter);
        this.assertFilterPermission((Permission)Permissions.CREATE, this.testUser, null, true);
        this.assertFilterPermission((Permission)Permissions.CREATE, ownerUser, null, false);
        this.assertFilterPermission((Permission)Permissions.CREATE, anotherUser, null, false);
        this.assertFilterPermission((Permission)Permissions.UPDATE, this.testUser, filter.getId(), false);
        this.assertFilterPermission((Permission)Permissions.UPDATE, ownerUser, filter.getId(), true);
        this.assertFilterPermission((Permission)Permissions.UPDATE, anotherUser, filter.getId(), false);
        this.assertFilterPermission((Permission)Permissions.READ, this.testUser, filter.getId(), false);
        this.assertFilterPermission((Permission)Permissions.READ, ownerUser, filter.getId(), true);
        this.assertFilterPermission((Permission)Permissions.READ, anotherUser, filter.getId(), false);
        this.assertFilterPermission((Permission)Permissions.DELETE, this.testUser, filter.getId(), false);
        this.assertFilterPermission((Permission)Permissions.DELETE, ownerUser, filter.getId(), true);
        this.assertFilterPermission((Permission)Permissions.DELETE, anotherUser, filter.getId(), false);
    }

    @Test
    public void testCreateFilterGenericOwnerId() {
        this.grantCreateFilter();
        Filter filter = this.filterService.newTaskFilter("someName");
        filter.setOwner("*");
        try {
            this.filterService.saveFilter(filter);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot create default authorization for filter owner *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
    }

    @Ignore(value="CAM-4889")
    @Test
    public void testUpdateFilterGenericOwnerId() {
        this.grantCreateFilter();
        Filter filter = this.filterService.newTaskFilter("someName");
        this.filterService.saveFilter(filter);
        this.grantUpdateFilter(filter.getId());
        filter.setOwner("*");
        try {
            this.filterService.saveFilter(filter);
            Assert.fail((String)"it should not be possible to save a filter with the generic owner id");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("foo", e.getMessage());
        }
    }

    protected User createTestUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(user.getId());
        authorization.setResource((Resource)Resources.AUTHORIZATION);
        authorization.setResourceId("*");
        authorization.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(authorization);
        authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(user.getId());
        authorization.setResource((Resource)Resources.USER);
        authorization.setResourceId("*");
        authorization.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(authorization);
        authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(user.getId());
        authorization.setResource((Resource)Resources.TASK);
        authorization.setResourceId("*");
        authorization.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(authorization);
        return user;
    }

    protected Filter createTestFilter() {
        this.grantCreateFilter();
        Filter filter = this.filterService.newTaskFilter("testFilter");
        return this.filterService.saveFilter(filter);
    }

    protected Authorization createAuthorization(Permission permission, String resourceId) {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(this.testUser.getId());
        authorization.setResource((Resource)Resources.FILTER);
        authorization.addPermission(permission);
        if (resourceId != null) {
            authorization.setResourceId(resourceId);
        }
        return authorization;
    }

    protected void grantCreateFilter() {
        this.grantFilterPermission(this.createAuthorization, null);
        this.assertFilterPermission((Permission)Permissions.CREATE, this.testUser, null, true);
    }

    protected void grantUpdateFilter(String filterId) {
        this.grantFilterPermission(this.updateAuthorization, filterId);
        this.assertFilterPermission((Permission)Permissions.UPDATE, this.testUser, filterId, true);
    }

    protected void grantReadFilter(String filterId) {
        this.grantFilterPermission(this.readAuthorization, filterId);
        this.assertFilterPermission((Permission)Permissions.READ, this.testUser, filterId, true);
    }

    protected void grantDeleteFilter(String filterId) {
        this.grantFilterPermission(this.deleteAuthorization, filterId);
        this.assertFilterPermission((Permission)Permissions.DELETE, this.testUser, filterId, true);
    }

    protected void grantFilterPermission(Authorization authorization, String filterId) {
        if (filterId != null) {
            authorization.setResourceId(filterId);
        }
        this.authorizationService.saveAuthorization(authorization);
    }

    protected void assertFilterPermission(Permission permission, User user, String filterId, boolean expected) {
        boolean result = filterId != null ? this.authorizationService.isUserAuthorized(user.getId(), null, permission, (Resource)Resources.FILTER, filterId) : this.authorizationService.isUserAuthorized(user.getId(), null, permission, (Resource)Resources.FILTER);
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

