/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.BatchHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class BatchHistoricDecisionInstanceDeletionTest {
    protected static String DECISION = "decision";
    protected static final Date TEST_DATE = new Date(1457326800000L);
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    protected BatchDeletionHelper helper = new BatchDeletionHelper(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    private int defaultBatchJobsPerSeed;
    private int defaultInvocationsPerBatchJob;
    private boolean defaultEnsureJobDueDateSet;
    protected ProcessEngineConfigurationImpl configuration;
    protected DecisionService decisionService;
    protected HistoryService historyService;
    protected List<String> decisionInstanceIds;
    @Parameterized.Parameter(value=0)
    public boolean ensureJobDueDateSet;
    @Parameterized.Parameter(value=1)
    public Date currentTime;

    @Parameterized.Parameters(name="Job DueDate is set: {0}")
    public static Collection<Object[]> scenarios() throws ParseException {
        return Arrays.asList({false, null}, {true, TEST_DATE});
    }

    @Before
    public void setup() {
        ClockUtil.setCurrentTime((Date)TEST_DATE);
        this.historyService = this.rule.getHistoryService();
        this.decisionService = this.rule.getDecisionService();
        this.decisionInstanceIds = new ArrayList<String>();
    }

    @Before
    public void storeEngineSettings() {
        this.configuration = this.rule.getProcessEngineConfiguration();
        this.defaultEnsureJobDueDateSet = this.configuration.isEnsureJobDueDateNotNull();
        this.defaultBatchJobsPerSeed = this.configuration.getBatchJobsPerSeed();
        this.defaultInvocationsPerBatchJob = this.configuration.getInvocationsPerBatchJob();
        this.configuration.setEnsureJobDueDateNotNull(this.ensureJobDueDateSet);
    }

    @Before
    public void executeDecisionInstances() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/dmn/Example.dmn");
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
        for (int i = 0; i < 10; ++i) {
            this.decisionService.evaluateDecisionByKey(DECISION).variables((Map)variables).evaluate();
        }
        List decisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        for (HistoricDecisionInstance decisionInstance : decisionInstances) {
            this.decisionInstanceIds.add(decisionInstance.getId());
        }
    }

    @After
    public void restoreEngineSettings() {
        this.configuration.setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
        this.configuration.setInvocationsPerBatchJob(this.defaultInvocationsPerBatchJob);
        this.configuration.setEnsureJobDueDateNotNull(this.defaultEnsureJobDueDateSet);
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
        ClockUtil.reset();
    }

    @Test
    public void createBatchDeletionByIds() {
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, null);
        this.assertBatchCreated(batch, 10);
    }

    @Test
    public void createBatchDeletionByInvalidIds() {
        Assertions.assertThatThrownBy(() -> this.historyService.deleteHistoricDecisionInstancesAsync((List)null, null)).isInstanceOf(BadUserRequestException.class);
    }

    @Test
    public void createBatchDeletionByQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(query, null);
        this.assertBatchCreated(batch, 10);
    }

    @Test
    public void createBatchDeletionByInvalidQuery() {
        Assertions.assertThatThrownBy(() -> this.historyService.deleteHistoricDecisionInstancesAsync((HistoricDecisionInstanceQuery)null, null)).isInstanceOf(BadUserRequestException.class);
    }

    @Test
    public void createBatchDeletionByInvalidQueryByKey() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("foo");
        Assertions.assertThatThrownBy(() -> this.historyService.deleteHistoricDecisionInstancesAsync(query, null)).isInstanceOf(BadUserRequestException.class);
    }

    @Test
    public void createBatchDeletionByIdsAndQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, query, null);
        this.assertBatchCreated(batch, 10);
    }

    @Test
    public void createSeedJobByIds() {
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, null);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Assert.assertNotNull((Object)seedJobDefinition.getDeploymentId());
        Assert.assertEquals((Object)batch.getId(), (Object)seedJobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)"batch-seed-job", (Object)seedJobDefinition.getJobType());
        JobDefinition deletionJobDefinition = this.helper.getExecutionJobDefinition(batch);
        Assert.assertNotNull((Object)deletionJobDefinition);
        Assert.assertEquals((Object)"historic-decision-instance-deletion", (Object)deletionJobDefinition.getJobType());
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNotNull((Object)seedJob);
        Assert.assertEquals((Object)seedJobDefinition.getId(), (Object)seedJob.getJobDefinitionId());
        Assert.assertEquals((Object)this.currentTime, (Object)seedJob.getDuedate());
        Assert.assertEquals((Object)seedJobDefinition.getDeploymentId(), (Object)seedJob.getDeploymentId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionKey());
        Assert.assertNull((Object)seedJob.getProcessInstanceId());
        Assert.assertNull((Object)seedJob.getExecutionId());
        List<Job> deletionJobs = this.helper.getExecutionJobs(batch);
        Assert.assertEquals((long)0L, (long)deletionJobs.size());
    }

    @Test
    public void createSeedJobByQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, query, null);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Assert.assertNotNull((Object)seedJobDefinition.getDeploymentId());
        Assert.assertEquals((Object)batch.getId(), (Object)seedJobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)"batch-seed-job", (Object)seedJobDefinition.getJobType());
        JobDefinition deletionJobDefinition = this.helper.getExecutionJobDefinition(batch);
        Assert.assertNotNull((Object)deletionJobDefinition);
        Assert.assertEquals((Object)"historic-decision-instance-deletion", (Object)deletionJobDefinition.getJobType());
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNotNull((Object)seedJob);
        Assert.assertEquals((Object)seedJobDefinition.getId(), (Object)seedJob.getJobDefinitionId());
        Assert.assertEquals((Object)this.currentTime, (Object)seedJob.getDuedate());
        Assert.assertEquals((Object)seedJobDefinition.getDeploymentId(), (Object)seedJob.getDeploymentId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionKey());
        Assert.assertNull((Object)seedJob.getProcessInstanceId());
        Assert.assertNull((Object)seedJob.getExecutionId());
        List<Job> deletionJobs = this.helper.getExecutionJobs(batch);
        Assert.assertEquals((long)0L, (long)deletionJobs.size());
    }

    @Test
    public void createSeedJobByIdsAndQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(query, null);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Assert.assertNotNull((Object)seedJobDefinition.getDeploymentId());
        Assert.assertEquals((Object)batch.getId(), (Object)seedJobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)"batch-seed-job", (Object)seedJobDefinition.getJobType());
        JobDefinition deletionJobDefinition = this.helper.getExecutionJobDefinition(batch);
        Assert.assertNotNull((Object)deletionJobDefinition);
        Assert.assertEquals((Object)"historic-decision-instance-deletion", (Object)deletionJobDefinition.getJobType());
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNotNull((Object)seedJob);
        Assert.assertEquals((Object)seedJobDefinition.getId(), (Object)seedJob.getJobDefinitionId());
        Assert.assertEquals((Object)this.currentTime, (Object)seedJob.getDuedate());
        Assert.assertEquals((Object)seedJobDefinition.getDeploymentId(), (Object)seedJob.getDeploymentId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionKey());
        Assert.assertNull((Object)seedJob.getProcessInstanceId());
        Assert.assertNull((Object)seedJob.getExecutionId());
        List<Job> deletionJobs = this.helper.getExecutionJobs(batch);
        Assert.assertEquals((long)0L, (long)deletionJobs.size());
    }

    @Test
    public void createDeletionJobsByIds() {
        this.rule.getProcessEngineConfiguration().setBatchJobsPerSeed(5);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, null);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        JobDefinition deletionJobDefinition = this.helper.getExecutionJobDefinition(batch);
        this.helper.executeSeedJob(batch);
        List<Job> deletionJobs = this.helper.getJobsForDefinition(deletionJobDefinition);
        Assert.assertEquals((long)5L, (long)deletionJobs.size());
        for (Job deletionJob : deletionJobs) {
            Assert.assertEquals((Object)deletionJobDefinition.getId(), (Object)deletionJob.getJobDefinitionId());
            Assert.assertEquals((Object)this.currentTime, (Object)deletionJob.getDuedate());
            Assert.assertNull((Object)deletionJob.getProcessDefinitionId());
            Assert.assertNull((Object)deletionJob.getProcessDefinitionKey());
            Assert.assertNull((Object)deletionJob.getProcessInstanceId());
            Assert.assertNull((Object)deletionJob.getExecutionId());
        }
        Job seedJob = this.helper.getJobForDefinition(seedJobDefinition);
        Assert.assertNotNull((Object)seedJob);
    }

    @Test
    public void createDeletionJobsByIdsInDifferentDeployments() {
        this.executeDecisionInstances();
        List definitions = ((DecisionDefinitionQuery)this.rule.getRepositoryService().createDecisionDefinitionQuery().orderByDecisionDefinitionVersion().asc()).list();
        Assert.assertEquals((long)2L, (long)definitions.size());
        String deploymentIdOne = ((DecisionDefinition)definitions.get(0)).getDeploymentId();
        String deploymentIdTwo = ((DecisionDefinition)definitions.get(1)).getDeploymentId();
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, null);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertEquals((Object)deploymentIdOne, (Object)seedJob.getDeploymentId());
        this.helper.executeSeedJob(batch);
        Job seedJobTwo = this.helper.getSeedJob(batch);
        Assert.assertNotNull((Object)seedJobTwo);
        Assert.assertEquals((Object)seedJob.getDeploymentId(), (Object)seedJobTwo.getDeploymentId());
        this.helper.executeSeedJob(batch);
        Assert.assertNull((Object)this.helper.getSeedJob(batch));
        List<Job> deletionJobs = this.helper.getExecutionJobs(batch);
        Assert.assertEquals((long)20L, (long)deletionJobs.size());
        Assert.assertEquals((long)10L, (long)this.getJobCountByDeployment(deletionJobs, deploymentIdOne));
        Assert.assertEquals((long)10L, (long)this.getJobCountByDeployment(deletionJobs, deploymentIdTwo));
    }

    @Test
    public void createDeletionJobsByIdsWithDeletedDeployment() {
        this.executeDecisionInstances();
        List definitions = ((DecisionDefinitionQuery)this.rule.getRepositoryService().createDecisionDefinitionQuery().orderByDecisionDefinitionVersion().asc()).list();
        Assert.assertEquals((long)2L, (long)definitions.size());
        String deploymentIdOne = ((DecisionDefinition)definitions.get(0)).getDeploymentId();
        String deploymentIdTwo = ((DecisionDefinition)definitions.get(1)).getDeploymentId();
        this.rule.getRepositoryService().deleteDeployment(deploymentIdTwo);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, null);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertEquals((Object)deploymentIdOne, (Object)seedJob.getDeploymentId());
        this.helper.executeSeedJob(batch);
        Job seedJobTwo = this.helper.getSeedJob(batch);
        Assert.assertNotNull((Object)seedJobTwo);
        Assert.assertEquals((Object)seedJob.getDeploymentId(), (Object)seedJobTwo.getDeploymentId());
        this.helper.executeSeedJob(batch);
        Assert.assertNull((Object)this.helper.getSeedJob(batch));
        List<Job> deletionJobs = this.helper.getExecutionJobs(batch);
        Assert.assertEquals((long)20L, (long)deletionJobs.size());
        Assert.assertEquals((long)10L, (long)this.getJobCountByDeployment(deletionJobs, deploymentIdOne));
        Assert.assertEquals((long)10L, (long)this.getJobCountByDeployment(deletionJobs, null));
        this.helper.executeJobs(batch);
    }

    @Test
    public void createDeletionJobsByQuery() {
        this.rule.getProcessEngineConfiguration().setBatchJobsPerSeed(5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(query, null);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        JobDefinition deletionJobDefinition = this.helper.getExecutionJobDefinition(batch);
        this.helper.executeSeedJob(batch);
        List<Job> deletionJobs = this.helper.getJobsForDefinition(deletionJobDefinition);
        Assert.assertEquals((long)5L, (long)deletionJobs.size());
        for (Job deletionJob : deletionJobs) {
            Assert.assertEquals((Object)deletionJobDefinition.getId(), (Object)deletionJob.getJobDefinitionId());
            Assert.assertEquals((Object)this.currentTime, (Object)deletionJob.getDuedate());
            Assert.assertNull((Object)deletionJob.getProcessDefinitionId());
            Assert.assertNull((Object)deletionJob.getProcessDefinitionKey());
            Assert.assertNull((Object)deletionJob.getProcessInstanceId());
            Assert.assertNull((Object)deletionJob.getExecutionId());
        }
        Job seedJob = this.helper.getJobForDefinition(seedJobDefinition);
        Assert.assertNotNull((Object)seedJob);
    }

    @Test
    public void createDeletionJobsByIdsAndQuery() {
        this.rule.getProcessEngineConfiguration().setBatchJobsPerSeed(5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, query, null);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        JobDefinition deletionJobDefinition = this.helper.getExecutionJobDefinition(batch);
        this.helper.executeSeedJob(batch);
        List<Job> deletionJobs = this.helper.getJobsForDefinition(deletionJobDefinition);
        Assert.assertEquals((long)5L, (long)deletionJobs.size());
        for (Job deletionJob : deletionJobs) {
            Assert.assertEquals((Object)deletionJobDefinition.getId(), (Object)deletionJob.getJobDefinitionId());
            Assert.assertEquals((Object)this.currentTime, (Object)deletionJob.getDuedate());
            Assert.assertNull((Object)deletionJob.getProcessDefinitionId());
            Assert.assertNull((Object)deletionJob.getProcessDefinitionKey());
            Assert.assertNull((Object)deletionJob.getProcessInstanceId());
            Assert.assertNull((Object)deletionJob.getExecutionId());
        }
        Job seedJob = this.helper.getJobForDefinition(seedJobDefinition);
        Assert.assertNotNull((Object)seedJob);
    }

    @Test
    public void createMonitorJobByIds() {
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, null);
        this.helper.completeSeedJobs(batch);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNull((Object)seedJob);
        JobDefinition monitorJobDefinition = this.helper.getMonitorJobDefinition(batch);
        Assert.assertNotNull((Object)monitorJobDefinition);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertNotNull((Object)monitorJob);
    }

    @Test
    public void createMonitorJobByQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(query, null);
        this.helper.completeSeedJobs(batch);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNull((Object)seedJob);
        JobDefinition monitorJobDefinition = this.helper.getMonitorJobDefinition(batch);
        Assert.assertNotNull((Object)monitorJobDefinition);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertNotNull((Object)monitorJob);
    }

    @Test
    public void createMonitorJobByIdsAndQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, query, null);
        this.helper.completeSeedJobs(batch);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNull((Object)seedJob);
        JobDefinition monitorJobDefinition = this.helper.getMonitorJobDefinition(batch);
        Assert.assertNotNull((Object)monitorJobDefinition);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertNotNull((Object)monitorJob);
    }

    @Test
    public void deleteInstancesByIds() {
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, null);
        this.helper.completeSeedJobs(batch);
        List<Job> deletionJobs = this.helper.getExecutionJobs(batch);
        for (Job deletionJob : deletionJobs) {
            this.helper.executeJob(deletionJob);
        }
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
    }

    @Test
    public void deleteInstancesByQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(query, null);
        this.helper.completeSeedJobs(batch);
        List<Job> deletionJobs = this.helper.getExecutionJobs(batch);
        for (Job deletionJob : deletionJobs) {
            this.helper.executeJob(deletionJob);
        }
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
    }

    @Test
    public void deleteInstancesByIdsAndQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, query, null);
        this.helper.completeSeedJobs(batch);
        List<Job> deletionJobs = this.helper.getExecutionJobs(batch);
        for (Job deletionJob : deletionJobs) {
            this.helper.executeJob(deletionJob);
        }
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
    }

    @Test
    public void shouldSetInvocationsPerBatchType() {
        this.configuration.getInvocationsPerBatchJobByBatchType().put("historic-decision-instance-deletion", 42);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(query, null);
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.configuration.setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    protected void assertBatchCreated(Batch batch, int decisionInstanceCount) {
        Assert.assertNotNull((Object)batch);
        Assert.assertNotNull((Object)batch.getId());
        Assert.assertEquals((Object)"historic-decision-instance-deletion", (Object)batch.getType());
        Assert.assertEquals((long)decisionInstanceCount, (long)batch.getTotalJobs());
        Assert.assertEquals((long)this.defaultBatchJobsPerSeed, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)this.defaultInvocationsPerBatchJob, (long)batch.getInvocationsPerBatchJob());
    }

    protected long getJobCountByDeployment(List<Job> jobs, String deploymentId) {
        return jobs.stream().filter(j -> Objects.equals(deploymentId, j.getDeploymentId())).count();
    }

    class BatchDeletionHelper
    extends BatchHelper {
        public BatchDeletionHelper(ProcessEngineRule engineRule) {
            super(engineRule);
        }

        @Override
        public JobDefinition getExecutionJobDefinition(Batch batch) {
            return (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).jobType("historic-decision-instance-deletion").singleResult();
        }
    }
}

