/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.incident.CompositeIncidentHandler;
import org.camunda.bpm.engine.impl.incident.IncidentContext;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class IncidentMultipleProcessingTest {
    private static final StubIncidentHandler JOB_HANDLER = new StubIncidentHandler("failedJob");
    @ClassRule
    public static ProcessEngineBootstrapRule processEngineBootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setCompositeIncidentHandlersEnabled(true);
        configuration.setCustomIncidentHandlers(Collections.singletonList(JOB_HANDLER));
    });
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(processEngineBootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private ManagementService managementService;

    @Before
    public void init() {
        JOB_HANDLER.reset();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
    }

    @Test
    public void jobHandlerShouldBeCompositeHandler() {
        IncidentHandler incidentHandler = this.engineRule.getProcessEngineConfiguration().getIncidentHandler("failedJob");
        Assertions.assertThat((Object)incidentHandler).isNotNull();
        Assertions.assertThat((Object)incidentHandler).isInstanceOf(CompositeIncidentHandler.class);
    }

    @Test
    public void externalTaskHandlerShouldBeCompositeHandler() {
        IncidentHandler incidentHandler = this.engineRule.getProcessEngineConfiguration().getIncidentHandler("failedExternalTask");
        Assertions.assertThat((Object)incidentHandler).isNotNull();
        Assertions.assertThat((Object)incidentHandler).isInstanceOf(CompositeIncidentHandler.class);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldCreateOneIncident() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.executeAvailableJobs();
        List incidents = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).list();
        Assertions.assertThat((List)incidents).hasSize(1);
        Assertions.assertThat(JOB_HANDLER.getCreateEvents()).hasSize(1);
        Assertions.assertThat(JOB_HANDLER.getResolveEvents()).isEmpty();
        Assertions.assertThat(JOB_HANDLER.getDeleteEvents()).isEmpty();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldResolveIncidentAfterJobRetriesRefresh() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)incident).isNotNull();
        this.managementService.setJobRetries(job.getId(), 1);
        incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)incident).isNull();
        Assertions.assertThat(JOB_HANDLER.getCreateEvents()).hasSize(1);
        Assertions.assertThat(JOB_HANDLER.getResolveEvents()).hasSize(1);
        Assertions.assertThat(JOB_HANDLER.getDeleteEvents()).isEmpty();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldDeleteIncidentAfterJobHasBeenDeleted() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)incident).isNotNull();
        this.managementService.deleteJob(job.getId());
        incident = (Incident)this.runtimeService.createIncidentQuery().incidentId(incident.getId()).singleResult();
        Assertions.assertThat((Object)incident).isNull();
        Assertions.assertThat(JOB_HANDLER.getCreateEvents()).hasSize(1);
        Assertions.assertThat(JOB_HANDLER.getResolveEvents()).isEmpty();
        Assertions.assertThat(JOB_HANDLER.getDeleteEvents()).hasSize(1);
    }

    public static class StubIncidentHandler
    implements IncidentHandler {
        private String incidentType;
        private List<IncidentContext> createEvents = new ArrayList<IncidentContext>();
        private List<IncidentContext> resolveEvents = new ArrayList<IncidentContext>();
        private List<IncidentContext> deleteEvents = new ArrayList<IncidentContext>();

        public StubIncidentHandler(String type) {
            this.incidentType = type;
        }

        public String getIncidentHandlerType() {
            return this.incidentType;
        }

        public Incident handleIncident(IncidentContext context, String message) {
            this.createEvents.add(context);
            return null;
        }

        public void resolveIncident(IncidentContext context) {
            this.resolveEvents.add(context);
        }

        public void deleteIncident(IncidentContext context) {
            this.deleteEvents.add(context);
        }

        public List<IncidentContext> getCreateEvents() {
            return this.createEvents;
        }

        public List<IncidentContext> getResolveEvents() {
            return this.resolveEvents;
        }

        public List<IncidentContext> getDeleteEvents() {
            return this.deleteEvents;
        }

        public void reset() {
            this.createEvents.clear();
            this.resolveEvents.clear();
            this.deleteEvents.clear();
        }
    }
}

