/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessInstanceSnapshot;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessInstanceSnapshotBuilder;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.junit.Assert;

public class MigrationTestRule
extends ProcessEngineTestRule {
    public ProcessInstanceSnapshot snapshotBeforeMigration;
    public ProcessInstanceSnapshot snapshotAfterMigration;

    public MigrationTestRule(ProcessEngineRule processEngineRule) {
        super(processEngineRule);
    }

    public String getSingleExecutionIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance singleInstance = this.getSingleActivityInstance(activityInstance, activityId);
        String[] executionIds = singleInstance.getExecutionIds();
        if (executionIds.length == 1) {
            return executionIds[0];
        }
        throw new RuntimeException("There is more than one execution assigned to activity instance " + singleInstance.getId());
    }

    public String getSingleExecutionIdForActivityBeforeMigration(String activityId) {
        return this.getSingleExecutionIdForActivity(this.snapshotBeforeMigration.getActivityTree(), activityId);
    }

    public String getSingleExecutionIdForActivityAfterMigration(String activityId) {
        return this.getSingleExecutionIdForActivity(this.snapshotAfterMigration.getActivityTree(), activityId);
    }

    public ActivityInstance getSingleActivityInstance(ActivityInstance tree, String activityId) {
        ActivityInstance[] activityInstances = tree.getActivityInstances(activityId);
        if (activityInstances.length == 1) {
            return activityInstances[0];
        }
        throw new RuntimeException("There is not exactly one activity instance for activity " + activityId);
    }

    public ActivityInstance getSingleActivityInstanceBeforeMigration(String activityId) {
        return this.getSingleActivityInstance(this.snapshotBeforeMigration.getActivityTree(), activityId);
    }

    public ActivityInstance getSingleActivityInstanceAfterMigration(String activityId) {
        return this.getSingleActivityInstance(this.snapshotAfterMigration.getActivityTree(), activityId);
    }

    public ProcessInstanceSnapshot takeFullProcessInstanceSnapshot(ProcessInstance processInstance) {
        return this.takeProcessInstanceSnapshot(processInstance).full();
    }

    public ProcessInstanceSnapshotBuilder takeProcessInstanceSnapshot(ProcessInstance processInstance) {
        return new ProcessInstanceSnapshotBuilder(processInstance, this.processEngine);
    }

    public ProcessInstance createProcessInstanceAndMigrate(MigrationPlan migrationPlan) {
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        this.migrateProcessInstance(migrationPlan, processInstance);
        return processInstance;
    }

    public ProcessInstance createProcessInstanceAndMigrate(MigrationPlan migrationPlan, Map<String, Object> variables) {
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId(), variables);
        this.migrateProcessInstance(migrationPlan, processInstance);
        return processInstance;
    }

    public void migrateProcessInstance(MigrationPlan migrationPlan, ProcessInstance processInstance) {
        this.snapshotBeforeMigration = this.takeFullProcessInstanceSnapshot(processInstance);
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.singletonList(this.snapshotBeforeMigration.getProcessInstanceId())).execute();
        processInstance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        this.snapshotAfterMigration = this.takeFullProcessInstanceSnapshot(processInstance);
    }

    public void triggerTimer() {
        Job job = this.assertTimerJobExists(this.snapshotAfterMigration);
        this.processEngine.getManagementService().executeJob(job.getId());
    }

    public ExecutionAssert assertExecutionTreeAfterMigration() {
        return ExecutionAssert.assertThat(this.snapshotAfterMigration.getExecutionTree());
    }

    public ActivityInstanceAssert.ActivityInstanceAssertThatClause assertActivityTreeAfterMigration() {
        return ActivityInstanceAssert.assertThat(this.snapshotAfterMigration.getActivityTree());
    }

    public void assertEventSubscriptionsMigrated(String activityIdBefore, String activityIdAfter, String eventName) {
        List<EventSubscription> eventSubscriptionsBefore = this.snapshotBeforeMigration.getEventSubscriptionsForActivityIdAndEventName(activityIdAfter, eventName);
        for (EventSubscription eventSubscription : eventSubscriptionsBefore) {
            this.assertEventSubscriptionMigrated(eventSubscription, activityIdAfter, eventName);
        }
    }

    protected void assertEventSubscriptionMigrated(EventSubscription eventSubscriptionBefore, String activityIdAfter, String eventName) {
        EventSubscription eventSubscriptionAfter = this.snapshotAfterMigration.getEventSubscriptionById(eventSubscriptionBefore.getId());
        Assert.assertNotNull((String)("Expected that an event subscription with id '" + eventSubscriptionBefore.getId() + "' exists after migration"), (Object)eventSubscriptionAfter);
        Assert.assertEquals((Object)eventSubscriptionBefore.getEventType(), (Object)eventSubscriptionAfter.getEventType());
        Assert.assertEquals((Object)activityIdAfter, (Object)eventSubscriptionAfter.getActivityId());
        Assert.assertEquals((Object)eventName, (Object)eventSubscriptionAfter.getEventName());
    }

    public void assertEventSubscriptionMigrated(String activityIdBefore, String activityIdAfter, String eventName) {
        EventSubscription eventSubscriptionBefore = this.snapshotBeforeMigration.getEventSubscriptionForActivityIdAndEventName(activityIdBefore, eventName);
        Assert.assertNotNull((String)("Expected that an event subscription for activity '" + activityIdBefore + "' exists before migration"), (Object)eventSubscriptionBefore);
        this.assertEventSubscriptionMigrated(eventSubscriptionBefore, activityIdAfter, eventName);
    }

    public void assertEventSubscriptionMigrated(String activityIdBefore, String eventNameBefore, String activityIdAfter, String eventNameAfter) {
        EventSubscription eventSubscriptionBefore = this.snapshotBeforeMigration.getEventSubscriptionForActivityIdAndEventName(activityIdBefore, eventNameBefore);
        Assert.assertNotNull((String)("Expected that an event subscription for activity '" + activityIdBefore + "' exists before migration"), (Object)eventSubscriptionBefore);
        this.assertEventSubscriptionMigrated(eventSubscriptionBefore, activityIdAfter, eventNameAfter);
    }

    public void assertEventSubscriptionRemoved(String activityId, String eventName) {
        EventSubscription eventSubscriptionBefore = this.snapshotBeforeMigration.getEventSubscriptionForActivityIdAndEventName(activityId, eventName);
        Assert.assertNotNull((String)("Expected an event subscription for activity '" + activityId + "' before the migration"), (Object)eventSubscriptionBefore);
        for (EventSubscription eventSubscription : this.snapshotAfterMigration.getEventSubscriptions()) {
            if (!eventSubscriptionBefore.getId().equals(eventSubscription.getId())) continue;
            Assert.fail((String)("Expected event subscription '" + eventSubscriptionBefore.getId() + "' to be removed after migration"));
        }
    }

    public void assertEventSubscriptionCreated(String activityId, String eventName) {
        EventSubscription eventSubscriptionAfter = this.snapshotAfterMigration.getEventSubscriptionForActivityIdAndEventName(activityId, eventName);
        Assert.assertNotNull((String)("Expected an event subscription for activity '" + activityId + "' after the migration"), (Object)eventSubscriptionAfter);
        for (EventSubscription eventSubscription : this.snapshotBeforeMigration.getEventSubscriptions()) {
            if (!eventSubscriptionAfter.getId().equals(eventSubscription.getId())) continue;
            Assert.fail((String)("Expected event subscription '" + eventSubscriptionAfter.getId() + "' to be created after migration"));
        }
    }

    public void assertTimerJob(Job job) {
        Assert.assertEquals((String)"Expected job to be a timer job", (Object)"timer", (Object)((JobEntity)job).getType());
    }

    public Job assertTimerJobExists(ProcessInstanceSnapshot snapshot) {
        List<Job> jobs = snapshot.getJobs();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = jobs.get(0);
        this.assertTimerJob(job);
        return job;
    }

    public void assertJobCreated(String activityId, String handlerType) {
        JobDefinition jobDefinitionAfter = this.snapshotAfterMigration.getJobDefinitionForActivityIdAndType(activityId, handlerType);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityId + "' exists after migration"), (Object)jobDefinitionAfter);
        Job jobAfter = this.snapshotAfterMigration.getJobForDefinitionId(jobDefinitionAfter.getId());
        Assert.assertNotNull((String)("Expected that a job for activity '" + activityId + "' exists after migration"), (Object)jobAfter);
        this.assertTimerJob(jobAfter);
        Assert.assertEquals((Object)jobDefinitionAfter.getProcessDefinitionId(), (Object)jobAfter.getProcessDefinitionId());
        Assert.assertEquals((Object)jobDefinitionAfter.getProcessDefinitionKey(), (Object)jobAfter.getProcessDefinitionKey());
        for (Job job : this.snapshotBeforeMigration.getJobs()) {
            if (!jobAfter.getId().equals(job.getId())) continue;
            Assert.fail((String)("Expected job '" + jobAfter.getId() + "' to be created first after migration"));
        }
    }

    public void assertJobsCreated(String activityId, String handlerType, int countJobs) {
        List<JobDefinition> jobDefinitionsAfter = this.snapshotAfterMigration.getJobDefinitionsForActivityIdAndType(activityId, handlerType);
        Assert.assertEquals((String)("Expected that " + countJobs + "job definitions for activity '" + activityId + "' exist after migration, but found " + jobDefinitionsAfter.size()), (long)countJobs, (long)jobDefinitionsAfter.size());
        for (JobDefinition jobDefinitionAfter : jobDefinitionsAfter) {
            Job jobAfter = this.snapshotAfterMigration.getJobForDefinitionId(jobDefinitionAfter.getId());
            Assert.assertNotNull((String)("Expected that a job for activity '" + activityId + "' exists after migration"), (Object)jobAfter);
            this.assertTimerJob(jobAfter);
            Assert.assertEquals((Object)jobDefinitionAfter.getProcessDefinitionId(), (Object)jobAfter.getProcessDefinitionId());
            Assert.assertEquals((Object)jobDefinitionAfter.getProcessDefinitionKey(), (Object)jobAfter.getProcessDefinitionKey());
            for (Job job : this.snapshotBeforeMigration.getJobs()) {
                if (!jobAfter.getId().equals(job.getId())) continue;
                Assert.fail((String)("Expected job '" + jobAfter.getId() + "' to be created first after migration"));
            }
        }
    }

    public void assertJobRemoved(String activityId, String handlerType) {
        JobDefinition jobDefinitionBefore = this.snapshotBeforeMigration.getJobDefinitionForActivityIdAndType(activityId, handlerType);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityId + "' exists before migration"), (Object)jobDefinitionBefore);
        Job jobBefore = this.snapshotBeforeMigration.getJobForDefinitionId(jobDefinitionBefore.getId());
        Assert.assertNotNull((String)("Expected that a job for activity '" + activityId + "' exists before migration"), (Object)jobBefore);
        this.assertTimerJob(jobBefore);
        for (Job job : this.snapshotAfterMigration.getJobs()) {
            if (!jobBefore.getId().equals(job.getId())) continue;
            Assert.fail((String)("Expected job '" + jobBefore.getId() + "' to be removed after migration"));
        }
    }

    public void assertJobMigrated(String activityIdBefore, String activityIdAfter, String handlerType) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, handlerType, null);
    }

    public void assertJobMigrated(String activityIdBefore, String activityIdAfter, String handlerType, Date dueDateAfter) {
        JobDefinition jobDefinitionBefore = this.snapshotBeforeMigration.getJobDefinitionForActivityIdAndType(activityIdBefore, handlerType);
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityIdBefore + "' exists before migration"), (Object)jobDefinitionBefore);
        Job jobBefore = this.snapshotBeforeMigration.getJobForDefinitionId(jobDefinitionBefore.getId());
        Assert.assertNotNull((String)("Expected that a timer job for activity '" + activityIdBefore + "' exists before migration"), (Object)jobBefore);
        this.assertJobMigrated(jobBefore, activityIdAfter, dueDateAfter == null ? jobBefore.getDuedate() : dueDateAfter);
    }

    public void assertJobMigrated(Job jobBefore, String activityIdAfter) {
        this.assertJobMigrated(jobBefore, activityIdAfter, jobBefore.getDuedate());
    }

    public void assertJobMigrated(Job jobBefore, String activityIdAfter, Date dueDateAfter) {
        Job jobAfter = this.snapshotAfterMigration.getJobById(jobBefore.getId());
        Assert.assertNotNull((String)("Expected that a job with id '" + jobBefore.getId() + "' exists after migration"), (Object)jobAfter);
        JobDefinition jobDefinitionAfter = this.snapshotAfterMigration.getJobDefinitionForActivityIdAndType(activityIdAfter, ((JobEntity)jobBefore).getJobHandlerType());
        Assert.assertNotNull((String)("Expected that a job definition for activity '" + activityIdAfter + "' exists after migration"), (Object)jobDefinitionAfter);
        Assert.assertEquals((Object)jobBefore.getId(), (Object)jobAfter.getId());
        Assert.assertEquals((String)("Expected that job is assigned to job definition '" + jobDefinitionAfter.getId() + "' after migration"), (Object)jobDefinitionAfter.getId(), (Object)jobAfter.getJobDefinitionId());
        Assert.assertEquals((String)("Expected that job is assigned to deployment '" + this.snapshotAfterMigration.getDeploymentId() + "' after migration"), (Object)this.snapshotAfterMigration.getDeploymentId(), (Object)jobAfter.getDeploymentId());
        Assert.assertEquals((Object)dueDateAfter, (Object)jobAfter.getDuedate());
        Assert.assertEquals((Object)((JobEntity)jobBefore).getType(), (Object)((JobEntity)jobAfter).getType());
        Assert.assertEquals((long)jobBefore.getPriority(), (long)jobAfter.getPriority());
        Assert.assertEquals((Object)jobDefinitionAfter.getProcessDefinitionId(), (Object)jobAfter.getProcessDefinitionId());
        Assert.assertEquals((Object)jobDefinitionAfter.getProcessDefinitionKey(), (Object)jobAfter.getProcessDefinitionKey());
    }

    public void assertBoundaryTimerJobCreated(String activityId) {
        this.assertJobCreated(activityId, "timer-transition");
    }

    public void assertBoundaryTimerJobRemoved(String activityId) {
        this.assertJobRemoved(activityId, "timer-transition");
    }

    public void assertBoundaryTimerJobMigrated(String activityIdBefore, String activityIdAfter) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, "timer-transition");
    }

    public void assertIntermediateTimerJobCreated(String activityId) {
        this.assertJobCreated(activityId, "timer-intermediate-transition");
    }

    public void assertIntermediateTimerJobRemoved(String activityId) {
        this.assertJobRemoved(activityId, "timer-intermediate-transition");
    }

    public void assertIntermediateTimerJobMigrated(String activityIdBefore, String activityIdAfter) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, "timer-intermediate-transition");
    }

    public void assertEventSubProcessTimerJobCreated(String activityId) {
        this.assertJobCreated(activityId, "timer-start-event-subprocess");
    }

    public void assertEventSubProcessTimerJobRemoved(String activityId) {
        this.assertJobRemoved(activityId, "timer-start-event-subprocess");
    }

    public void assertTaskListenerTimerJobCreated(String activityId) {
        this.assertJobCreated(activityId, "timer-task-listener");
    }

    public void assertTaskListenerTimerJobsCreated(String activityId, int countJobs) {
        this.assertJobsCreated(activityId, "timer-task-listener", countJobs);
    }

    public void assertTaskListenerTimerJobRemoved(String activityId) {
        this.assertJobRemoved(activityId, "timer-task-listener");
    }

    public void assertTaskListenerTimerJobMigrated(String activityIdBefore, String activityIdAfter) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, "timer-task-listener");
    }

    public void assertTaskListenerTimerJobMigrated(String activityIdBefore, String activityIdAfter, Date dueDateAfter) {
        this.assertJobMigrated(activityIdBefore, activityIdAfter, "timer-task-listener", dueDateAfter);
    }

    public void assertVariableMigratedToExecution(VariableInstance variableBefore, String executionId) {
        this.assertVariableMigratedToExecution(variableBefore, executionId, variableBefore.getActivityInstanceId());
    }

    public void assertVariableMigratedToExecution(VariableInstance variableBefore, String executionId, String activityInstanceId) {
        VariableInstance variableAfter = this.snapshotAfterMigration.getVariable(variableBefore.getId());
        Assert.assertNotNull((String)("Variable with id " + variableBefore.getId() + " does not exist"), (Object)variableAfter);
        Assert.assertEquals((Object)activityInstanceId, (Object)variableAfter.getActivityInstanceId());
        Assert.assertEquals((Object)variableBefore.getCaseExecutionId(), (Object)variableAfter.getCaseExecutionId());
        Assert.assertEquals((Object)variableBefore.getCaseInstanceId(), (Object)variableAfter.getCaseInstanceId());
        Assert.assertEquals((Object)variableBefore.getErrorMessage(), (Object)variableAfter.getErrorMessage());
        Assert.assertEquals((Object)executionId, (Object)variableAfter.getExecutionId());
        Assert.assertEquals((Object)variableBefore.getId(), (Object)variableAfter.getId());
        Assert.assertEquals((Object)variableBefore.getName(), (Object)variableAfter.getName());
        Assert.assertEquals((Object)variableBefore.getProcessInstanceId(), (Object)variableAfter.getProcessInstanceId());
        Assert.assertEquals((Object)variableBefore.getTaskId(), (Object)variableAfter.getTaskId());
        Assert.assertEquals((Object)variableBefore.getTenantId(), (Object)variableAfter.getTenantId());
        Assert.assertEquals((Object)variableBefore.getTypeName(), (Object)variableAfter.getTypeName());
        Assert.assertEquals((Object)variableBefore.getValue(), (Object)variableAfter.getValue());
    }

    public void assertSuperExecutionOfCaseInstance(String caseInstanceId, String expectedSuperExecutionId) {
        CaseExecutionEntity calledInstance = (CaseExecutionEntity)this.processEngine.getCaseService().createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertEquals((Object)expectedSuperExecutionId, (Object)calledInstance.getSuperExecutionId());
    }

    public void assertSuperExecutionOfProcessInstance(String processInstance, String expectedSuperExecutionId) {
        ExecutionEntity calledInstance = (ExecutionEntity)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstance).singleResult();
        Assert.assertEquals((Object)expectedSuperExecutionId, (Object)calledInstance.getSuperExecutionId());
    }
}

