/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.util.ResourceTypeUtil;

public class AuthorizationTestUtil {
    protected static Map<Integer, Resource> resourcesByType = new HashMap<Integer, Resource>();

    public static Resource getResourceByType(int type) {
        return resourcesByType.get(type);
    }

    public static void assertExceptionInfo(String expectedPermissionName, String expectedResourceName, String expectedResourceId, MissingAuthorization info) {
        TestCase.assertEquals((String)expectedPermissionName, (String)info.getViolatedPermissionName());
        TestCase.assertEquals((String)expectedResourceName, (String)info.getResourceType());
        TestCase.assertEquals((String)expectedResourceId, (String)info.getResourceId());
    }

    public static Permission[] getPermissions(Authorization authorization) {
        int resourceType = authorization.getResourceType();
        Permission[] permissionsByResourceType = ResourceTypeUtil.getPermissionsByResourceType((int)resourceType);
        return authorization.getPermissions(permissionsByResourceType);
    }

    static {
        for (Resources resource : Resources.values()) {
            resourcesByType.put(resource.resourceType(), (Resource)resource);
        }
    }
}

