/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import camundajar.impl.com.google.gson.Gson;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.metrics.reporter.DbMetricsReporter;
import org.camunda.bpm.engine.impl.telemetry.dto.InternalsImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.impl.util.JsonTestUtil;
import org.camunda.bpm.engine.telemetry.Metric;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class TelemetryMultipleEnginesTest {
    protected static final String TELEMETRY_ENDPOINT_PATH = "/pings";
    protected static final String TELEMETRY_ENDPOINT = "http://localhost:8081/pings";
    @ClassRule
    public static WireMockRule wireMockRule = new WireMockRule(8081);
    @ClassRule
    public static ProcessEngineBootstrapRule secondEngineRule = new ProcessEngineBootstrapRule(config -> config.setTelemetryEndpoint(TELEMETRY_ENDPOINT));
    @ClassRule
    public static ProcessEngineBootstrapRule defaultEngineRule = new ProcessEngineBootstrapRule(config -> config.setTelemetryEndpoint(TELEMETRY_ENDPOINT));
    protected ProcessEngine defaultEngine;
    protected ProcessEngine secondEngine;
    private TelemetryReporter defaultTelemetryReporter;
    private TelemetryReporter secondTelemetryReporter;

    @Before
    public void init() {
        this.defaultEngine = defaultEngineRule.getProcessEngine();
        this.secondEngine = secondEngineRule.getProcessEngine();
        this.defaultTelemetryReporter = this.getTelemetryReporter(this.defaultEngine);
        this.secondTelemetryReporter = this.getTelemetryReporter(this.secondEngine);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
    }

    @Test
    public void shouldPickUpTelemetryActivation() {
        this.defaultEngine.getManagementService().toggleTelemetry(true);
        this.secondTelemetryReporter.reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportMetricsPerEngine() {
        this.clearMetrics();
        this.defaultEngine.getManagementService().toggleTelemetry(true);
        this.secondEngine.getManagementService().toggleTelemetry(true);
        MetricsRegistry defaultMetricsRegistry = this.getMetricsRegistry(this.defaultEngine);
        MetricsRegistry secondMetricsRegistry = this.getMetricsRegistry(this.secondEngine);
        defaultMetricsRegistry.markOccurrence("executed-decision-instances");
        secondMetricsRegistry.markOccurrence("root-process-instance-start");
        this.persistMetrics();
        this.defaultTelemetryReporter.reportNow();
        this.secondTelemetryReporter.reportNow();
        List requests = wireMockRule.findAll(WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)));
        Assertions.assertThat((List)requests).hasSize(2);
        Gson gson = JsonTestUtil.createTelemetryDataMapper();
        LoggedRequest defaultRequest = (LoggedRequest)requests.get(0);
        TelemetryDataImpl defaultRequestBody = (TelemetryDataImpl)gson.fromJson(defaultRequest.getBodyAsString(), TelemetryDataImpl.class);
        this.assertReportedMetrics(defaultRequestBody, 0, 1, 0);
        LoggedRequest secondRequest = (LoggedRequest)requests.get(1);
        TelemetryDataImpl secondRequestBody = (TelemetryDataImpl)gson.fromJson(secondRequest.getBodyAsString(), TelemetryDataImpl.class);
        this.assertReportedMetrics(secondRequestBody, 1, 0, 0);
    }

    @Test
    public void shouldUpdateTelemetryFlagDuringReporting() {
        MetricsRegistry secondMetricsRegistry = this.getMetricsRegistry(this.secondEngine);
        secondMetricsRegistry.markOccurrence("root-process-instance-start");
        this.defaultEngine.getManagementService().toggleTelemetry(true);
        secondMetricsRegistry.markOccurrence("root-process-instance-start");
        this.secondTelemetryReporter.reportNow();
        Meter rootPiMeter = (Meter)secondMetricsRegistry.getTelemetryMeters().get("root-process-instance-start");
        Assertions.assertThat((long)rootPiMeter.get()).isEqualTo(0L);
        List requests = wireMockRule.findAll(WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)));
        Assertions.assertThat((List)requests).hasSize(1);
        Gson gson = JsonTestUtil.createTelemetryDataMapper();
        LoggedRequest defaultRequest = (LoggedRequest)requests.get(0);
        TelemetryDataImpl defaultRequestBody = (TelemetryDataImpl)gson.fromJson(defaultRequest.getBodyAsString(), TelemetryDataImpl.class);
        this.assertReportedMetrics(defaultRequestBody, 0, 0, 0);
    }

    private TelemetryReporter getTelemetryReporter(ProcessEngine engine) {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)engine.getProcessEngineConfiguration();
        return engineConfiguration.getTelemetryReporter();
    }

    private MetricsRegistry getMetricsRegistry(ProcessEngine engine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)engine.getProcessEngineConfiguration();
        return processEngineConfiguration.getMetricsRegistry();
    }

    private void assertReportedMetrics(TelemetryDataImpl data, int expectedRootInstances, int expectedDecisionInstances, int expectedFlowNodeInstances) {
        InternalsImpl internals = data.getProduct().getInternals();
        this.assertMetric(internals, "root-process-instance-start", expectedRootInstances);
        this.assertMetric(internals, "executed-decision-instances", expectedDecisionInstances);
        this.assertMetric(internals, "activity-instance-start", expectedFlowNodeInstances);
    }

    private void assertMetric(InternalsImpl internals, String name, int expectedCount) {
        Map metrics = internals.getMetrics();
        Metric rootMetric = (Metric)metrics.get(name);
        Assertions.assertThat((Object)rootMetric).isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)rootMetric.getCount()).describedAs("metric " + name, new Object[0])).isEqualTo((long)expectedCount);
    }

    private void persistMetrics() {
        this.persistMetrics(this.defaultEngine);
        this.persistMetrics(this.secondEngine);
    }

    private void persistMetrics(ProcessEngine engine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)engine.getProcessEngineConfiguration();
        DbMetricsReporter metricsReporter = processEngineConfiguration.getDbMetricsReporter();
        metricsReporter.reportNow();
    }

    @After
    public void tearDown() {
        WireMock.resetAllRequests();
        this.clearMetrics();
        this.defaultEngine.getManagementService().toggleTelemetry(false);
        this.secondEngine.getManagementService().toggleTelemetry(false);
    }

    protected void clearMetrics() {
        this.clearMetrics(this.defaultEngine);
        this.clearMetrics(this.secondEngine);
    }

    protected void clearMetrics(ProcessEngine engine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)engine.getProcessEngineConfiguration();
        MetricsRegistry metricsRegistry = processEngineConfiguration.getMetricsRegistry();
        Collection meters = metricsRegistry.getTelemetryMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        engine.getManagementService().deleteMetrics(null);
    }
}

