/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyIncidentQueryTest
extends PluggableProcessEngineTest {
    protected static final BpmnModelInstance BPMN = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"failingProcess").startEvent().serviceTask().camundaExpression("${failing}")).camundaAsyncBefore()).endEvent().done();
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN);
        this.testRule.deployForTenant(TENANT_TWO, BPMN);
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_ONE);
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_TWO);
    }

    @Test
    public void testQueryWithoutTenantId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void testQueryByTenantId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.runtimeService.createIncidentQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIds() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        IncidentQuery query = this.runtimeService.createIncidentQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.runtimeService.createIncidentQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List incidents = ((IncidentQuery)this.runtimeService.createIncidentQuery().orderByTenantId().asc()).list();
        Assertions.assertThat((List)incidents).hasSize(2);
        Assertions.assertThat((String)((Incident)incidents.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((Incident)incidents.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void testQuerySortingDesc() {
        List incidents = ((IncidentQuery)this.runtimeService.createIncidentQuery().orderByTenantId().desc()).list();
        Assertions.assertThat((List)incidents).hasSize(2);
        Assertions.assertThat((String)((Incident)incidents.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((Incident)incidents.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    protected void startProcessInstanceAndExecuteFailingJobForTenant(String tenant) {
        this.runtimeService.createProcessInstanceByKey("failingProcess").processDefinitionTenantId(tenant).execute();
        this.testRule.executeAvailableJobs();
    }
}

