/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeploymentQueryTest
extends PluggableProcessEngineTest {
    private String deploymentOneId;
    private String deploymentTwoId;

    @Before
    public void setUp() throws Exception {
        this.deploymentOneId = this.repositoryService.createDeployment().name("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").source("process application").deploy().getId();
        this.deploymentTwoId = this.repositoryService.createDeployment().name("org/camunda/bpm/engine/test/repository/two_.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/repository/two.bpmn20.xml").deploy().getId();
    }

    @After
    public void tearDown() throws Exception {
        this.repositoryService.deleteDeployment(this.deploymentOneId, true);
        this.repositoryService.deleteDeployment(this.deploymentTwoId, true);
    }

    @Test
    public void testQueryNoCriteria() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assert.assertEquals((long)2L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.count());
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByDeploymentId() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentId(this.deploymentOneId);
        Assert.assertNotNull((Object)query.singleResult());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidDeploymentId() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentId("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.repositoryService.createDeploymentQuery().deploymentId(null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByName() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentName("org/camunda/bpm/engine/test/repository/two_.bpmn20.xml");
        Assert.assertNotNull((Object)query.singleResult());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidName() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentName("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.repositoryService.createDeploymentQuery().deploymentName(null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNameLike() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentNameLike("%camunda%");
        Assert.assertEquals((long)2L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.count());
        query = this.repositoryService.createDeploymentQuery().deploymentNameLike("%two\\_%");
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/repository/two_.bpmn20.xml", (Object)((Deployment)query.singleResult()).getName());
    }

    @Test
    public void testQueryByInvalidNameLike() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentNameLike("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.repositoryService.createDeploymentQuery().deploymentNameLike(null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByDeploymentBefore() throws Exception {
        Date later = DateTimeUtil.now().plus(36000L).toDate();
        Date earlier = DateTimeUtil.now().minus(36000L).toDate();
        long count = this.repositoryService.createDeploymentQuery().deploymentBefore(later).count();
        Assert.assertEquals((long)2L, (long)count);
        count = this.repositoryService.createDeploymentQuery().deploymentBefore(earlier).count();
        Assert.assertEquals((long)0L, (long)count);
        try {
            this.repositoryService.createDeploymentQuery().deploymentBefore(null);
            Assert.fail((String)"Exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryDeploymentAfter() throws Exception {
        Date later = DateTimeUtil.now().plus(36000L).toDate();
        Date earlier = DateTimeUtil.now().minus(36000L).toDate();
        long count = this.repositoryService.createDeploymentQuery().deploymentAfter(later).count();
        Assert.assertEquals((long)0L, (long)count);
        count = this.repositoryService.createDeploymentQuery().deploymentAfter(earlier).count();
        Assert.assertEquals((long)2L, (long)count);
        try {
            this.repositoryService.createDeploymentQuery().deploymentAfter(null);
            Assert.fail((String)"Exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySource() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentSource("process application");
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByNullSource() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentSource(null);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidSource() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentSource("invalid");
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    public void testQueryDeploymentBetween() throws Exception {
        Date later = DateTimeUtil.now().plus(36000L).toDate();
        Date earlier = DateTimeUtil.now().minus(36000L).toDate();
        long count = this.repositoryService.createDeploymentQuery().deploymentAfter(earlier).deploymentBefore(later).count();
        Assert.assertEquals((long)2L, (long)count);
        count = this.repositoryService.createDeploymentQuery().deploymentAfter(later).deploymentBefore(later).count();
        Assert.assertEquals((long)0L, (long)count);
        count = this.repositoryService.createDeploymentQuery().deploymentAfter(earlier).deploymentBefore(earlier).count();
        Assert.assertEquals((long)0L, (long)count);
        count = this.repositoryService.createDeploymentQuery().deploymentAfter(later).deploymentBefore(earlier).count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testVerifyDeploymentProperties() {
        List deployments = ((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymentName().asc()).list();
        Deployment deploymentOne = (Deployment)deployments.get(0);
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/repository/one.bpmn20.xml", (Object)deploymentOne.getName());
        Assert.assertEquals((Object)this.deploymentOneId, (Object)deploymentOne.getId());
        Assert.assertEquals((Object)"process application", (Object)deploymentOne.getSource());
        Assert.assertNull((Object)deploymentOne.getTenantId());
        Deployment deploymentTwo = (Deployment)deployments.get(1);
        Assert.assertEquals((Object)"org/camunda/bpm/engine/test/repository/two_.bpmn20.xml", (Object)deploymentTwo.getName());
        Assert.assertEquals((Object)this.deploymentTwoId, (Object)deploymentTwo.getId());
        Assert.assertNull((Object)deploymentTwo.getSource());
        Assert.assertNull((Object)deploymentTwo.getTenantId());
    }

    @Test
    public void testQuerySorting() {
        Assert.assertEquals((long)2L, (long)((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymentName().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymentId().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymenTime().asc()).list().size());
        Assert.assertEquals((long)2L, (long)((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymentTime().asc()).list().size());
    }
}

