/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.GregorianCalendar;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class EventSubscriptionQueryTest
extends PluggableProcessEngineTest {
    @Test
    public void testQueryByEventSubscriptionId() {
        this.createExampleEventSubscriptions();
        List list = this.runtimeService.createEventSubscriptionQuery().eventName("messageName2").list();
        Assert.assertEquals((long)1L, (long)list.size());
        EventSubscription eventSubscription = (EventSubscription)list.get(0);
        EventSubscriptionQuery query = this.runtimeService.createEventSubscriptionQuery().eventSubscriptionId(eventSubscription.getId());
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertNotNull((Object)query.singleResult());
        try {
            this.runtimeService.createEventSubscriptionQuery().eventSubscriptionId(null).list();
            Assert.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.cleanDb();
    }

    @Test
    public void testQueryByEventName() {
        this.createExampleEventSubscriptions();
        List list = this.runtimeService.createEventSubscriptionQuery().eventName("messageName").list();
        Assert.assertEquals((long)2L, (long)list.size());
        list = this.runtimeService.createEventSubscriptionQuery().eventName("messageName2").list();
        Assert.assertEquals((long)1L, (long)list.size());
        try {
            this.runtimeService.createEventSubscriptionQuery().eventName(null).list();
            Assert.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.cleanDb();
    }

    @Test
    public void testQueryByEventType() {
        this.createExampleEventSubscriptions();
        List list = this.runtimeService.createEventSubscriptionQuery().eventType("signal").list();
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.runtimeService.createEventSubscriptionQuery().eventType("message").list();
        Assert.assertEquals((long)2L, (long)list.size());
        try {
            this.runtimeService.createEventSubscriptionQuery().eventType(null).list();
            Assert.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.cleanDb();
    }

    @Test
    public void testQueryByActivityId() {
        this.createExampleEventSubscriptions();
        List list = this.runtimeService.createEventSubscriptionQuery().activityId("someOtherActivity").list();
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.runtimeService.createEventSubscriptionQuery().activityId("someActivity").eventType("message").list();
        Assert.assertEquals((long)2L, (long)list.size());
        try {
            this.runtimeService.createEventSubscriptionQuery().activityId(null).list();
            Assert.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.cleanDb();
    }

    @Deployment
    @Test
    public void testQueryByExecutionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("catchSignal");
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)subscription);
        Execution executionWaitingForSignal = (Execution)this.runtimeService.createExecutionQuery().activityId("signalEvent").processInstanceId(processInstance.getId()).singleResult();
        EventSubscription signalSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().executionId(executionWaitingForSignal.getId()).singleResult();
        Assert.assertNotNull((Object)signalSubscription);
        Assert.assertEquals((Object)signalSubscription, (Object)subscription);
        try {
            this.runtimeService.createEventSubscriptionQuery().executionId(null).list();
            Assert.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.cleanDb();
    }

    @Test
    public void testQuerySorting() {
        this.createExampleEventSubscriptions();
        List eventSubscriptions = ((EventSubscriptionQuery)this.runtimeService.createEventSubscriptionQuery().orderByCreated().asc()).list();
        Assert.assertEquals((long)3L, (long)eventSubscriptions.size());
        Assert.assertTrue((((EventSubscription)eventSubscriptions.get(0)).getCreated().compareTo(((EventSubscription)eventSubscriptions.get(1)).getCreated()) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((((EventSubscription)eventSubscriptions.get(1)).getCreated().compareTo(((EventSubscription)eventSubscriptions.get(2)).getCreated()) < 0 ? 1 : 0) != 0);
        this.cleanDb();
    }

    @Deployment
    @Test
    public void testMultipleEventSubscriptions() {
        String message = "cancelation-requested";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertTrue((boolean)this.areJobsAvailable());
        long eventSubscriptionCount = this.runtimeService.createEventSubscriptionQuery().count();
        Assert.assertEquals((long)2L, (long)eventSubscriptionCount);
        EventSubscription messageEvent = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().eventType("message").singleResult();
        Assert.assertEquals((Object)message, (Object)messageEvent.getEventName());
        EventSubscription compensationEvent = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().eventType("compensate").singleResult();
        Assert.assertNull((Object)compensationEvent.getEventName());
        this.runtimeService.createMessageCorrelation(message).processInstanceId(processInstance.getId()).correlate();
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    protected void createExampleEventSubscriptions() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                GregorianCalendar calendar = new GregorianCalendar();
                EventSubscriptionEntity messageEventSubscriptionEntity1 = new EventSubscriptionEntity(EventType.MESSAGE);
                messageEventSubscriptionEntity1.setEventName("messageName");
                messageEventSubscriptionEntity1.setActivityId("someActivity");
                calendar.set(2001, 1, 1);
                messageEventSubscriptionEntity1.setCreated(calendar.getTime());
                messageEventSubscriptionEntity1.insert();
                EventSubscriptionEntity messageEventSubscriptionEntity2 = new EventSubscriptionEntity(EventType.MESSAGE);
                messageEventSubscriptionEntity2.setEventName("messageName");
                messageEventSubscriptionEntity2.setActivityId("someActivity");
                calendar.set(2000, 1, 1);
                messageEventSubscriptionEntity2.setCreated(calendar.getTime());
                messageEventSubscriptionEntity2.insert();
                EventSubscriptionEntity signalEventSubscriptionEntity3 = new EventSubscriptionEntity(EventType.SIGNAL);
                signalEventSubscriptionEntity3.setEventName("messageName2");
                signalEventSubscriptionEntity3.setActivityId("someOtherActivity");
                calendar.set(2002, 1, 1);
                signalEventSubscriptionEntity3.setCreated(calendar.getTime());
                signalEventSubscriptionEntity3.insert();
                return null;
            }
        });
    }

    protected void cleanDb() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List subscriptions = new EventSubscriptionQueryImpl().list();
                for (EventSubscription eventSubscriptionEntity : subscriptions) {
                    ((EventSubscriptionEntity)eventSubscriptionEntity).delete();
                }
                return null;
            }
        });
    }
}

