/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.tasklistener;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.bpmn.tasklistener.AbstractTaskListenerTest;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.AssigneeAssignment;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.CandidateUserAssignment;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.CompletingTaskListener;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Test;

public class TaskListenerEventLifecycleTest
extends AbstractTaskListenerTest {
    protected static final String[] TRACKED_EVENTS = new String[]{"create", "update", "assignment", "complete", "delete"};

    @Test
    public void shouldOnlyFireCreateAndAssignmentEventsWhenTaskIsCreated() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTaskWithAssignee("kermit", TRACKED_EVENTS);
        this.runtimeService.startProcessInstanceByKey("process");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "assignment"});
    }

    @Test
    public void shouldFireCompleteEventOnTaskCompletedInCreateListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "create", CompletingTaskListener.class);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "complete"});
    }

    @Test
    public void shouldFireCompleteEventOnTaskCompletedInAssignmentListenerWhenTaskCreated() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "assignment", CompletingTaskListener.class);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "gonzo");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(4);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "update", "assignment", "complete"});
    }

    @Test
    public void shouldFireCreateEventBeforeTimeoutEventWhenTaskCreated() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        Calendar now = Calendar.getInstance();
        now.add(10, -1);
        BpmnModelInstance model = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task").camundaTaskListenerClass("create", RecorderTaskListener.class)).camundaTaskListenerClassTimeoutWithDate("timeout", RecorderTaskListener.class, sdf.format(now.getTime()))).endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        this.testRule.waitForJobExecutorToProcessAllJobs(0L);
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "timeout"});
    }

    @Test
    public void shouldCancelTimeoutTaskListenerWhenTaskCompleted() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        Calendar now = Calendar.getInstance();
        now.add(12, 10);
        BpmnModelInstance model = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task").camundaTaskListenerClass("create", RecorderTaskListener.class)).camundaTaskListenerClass("complete", RecorderTaskListener.class)).camundaTaskListenerClassTimeoutWithDate("timeout", RecorderTaskListener.class, sdf.format(now.getTime()))).endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        long runningJobCount = this.managementService.createJobQuery().count();
        this.taskService.complete(task.getId());
        long completedJobCount = this.managementService.createJobQuery().count();
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((long)runningJobCount).isOne();
        Assertions.assertThat((long)completedJobCount).isZero();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"complete");
    }

    @Test
    public void shouldFireUpdateEventOnPropertyChangeWhenTaskUpdated() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask(TRACKED_EVENTS);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setOwner(task.getId(), "gonzo");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "update"});
    }

    @Test
    public void shouldFireUpdateEventBeforeAssignmentEventOnSetAssigneeWhenTaskUpdated() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask(TRACKED_EVENTS);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "gonzo");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(3);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "update", "assignment"});
    }

    @Test
    public void shouldFireCompleteEventOnTaskCompletedInUpdateListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "update", CompletingTaskListener.class);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setPriority(task.getId(), 3000);
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(3);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "update", "complete"});
    }

    @Test
    public void shouldFireCompleteEventOnTaskCompletedInAssignmentListenerWhenTaskUpdated() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "assignment", CompletingTaskListener.class);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "kermit");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(4);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "update", "assignment", "complete"});
    }

    @Test
    public void shouldNotFireUpdateEventAfterCreateTaskListenerUpdatesProperties() {
        BpmnModelInstance process = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "create", ModifyingTaskListener.class);
        this.testRule.deploy(process);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "assignment"});
    }

    @Test
    public void shouldNotFireUpdateEventAfterUpdateTaskListenerUpdatesProperties() {
        BpmnModelInstance process = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "update", ModifyingTaskListener.class);
        this.testRule.deploy(process);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.taskService.setPriority(task.getId(), 3000);
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(3);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "update", "assignment"});
    }

    @Test
    public void shouldNotFireUpdateEventAfterAssignmentTaskListenerUpdatesProperties() {
        BpmnModelInstance process = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "assignment", ModifyingTaskListener.class);
        this.testRule.deploy(process);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "john");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(3);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "update", "assignment"});
    }

    @Test
    public void shouldNotFireUpdateEventAfterCompleteTaskListenerUpdatesProperties() {
        BpmnModelInstance process = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "complete", ModifyingTaskListener.class);
        this.testRule.deploy(process);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "complete"});
    }

    @Test
    public void shouldNotFireUpdateEventAfterDeleteTaskListenerUpdatesProperties() {
        BpmnModelInstance process = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "delete", ModifyingTaskListener.class);
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "Trigger Delete Event");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "delete"});
    }

    @Test
    public void shouldFireCompleteEventLastWhenTaskCompleted() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask(TRACKED_EVENTS);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"complete");
    }

    @Test
    public void shouldNotFireUpdateEventOnPropertyChangesInCompleteListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "complete", CandidateUserAssignment.class);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"complete");
    }

    @Test
    public void shouldNotFireAssignmentEventOnAssigneeChangesInCompleteListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "complete", AssigneeAssignment.class);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotFireDeleteEventOnTaskDeletedInCompleteListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "complete", TaskDeleteTaskListener.class);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("The task cannot be deleted because is part of a running process");
        }
        finally {
            LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
            Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
            Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"complete");
        }
    }

    @Test
    public void shouldFireDeleteEventOnProcessInstanceDeletedInCompleteListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "complete", ProcessInstanceDeleteTaskListener.class);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(3);
        Assertions.assertThat(orderedEvents).containsExactly((Object[])new String[]{"create", "complete", "delete"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotFireCompleteEventOnTaskCompletedInCompleteListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "complete", CompletingTaskListener.class);
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("invalid task state");
        }
        finally {
            LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
            Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
            Assertions.assertThat((String)orderedEvents.getFirst()).isEqualToIgnoringCase((CharSequence)"create");
            Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"complete");
        }
    }

    @Test
    public void shouldFireDeleteEventLastWhenProcessDeleted() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask(TRACKED_EVENTS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "Canceled!");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat((String)orderedEvents.getFirst()).isEqualToIgnoringCase((CharSequence)"create");
        Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"delete");
    }

    @Test
    public void shouldNotFireUpdateEventOnPropertyChangesInDeleteListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "delete", CandidateUserAssignment.class);
        this.testRule.deploy(model);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "Canceled!");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat((String)orderedEvents.getFirst()).isEqualToIgnoringCase((CharSequence)"create");
        Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"delete");
    }

    @Test
    public void shouldNotFireAssignmentEventOnAssigneeChangesInDeleteListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "delete", AssigneeAssignment.class);
        this.testRule.deploy(model);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "Canceled!");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat((String)orderedEvents.getFirst()).isEqualToIgnoringCase((CharSequence)"create");
        Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotFireCompleteEventOnCompleteAttemptInDeleteListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "delete", CompletingTaskListener.class);
        this.testRule.deploy(model);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.deleteProcessInstance(processInstance.getId(), "Canceled!")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("invalid task state");
        }
        finally {
            LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
            Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
            Assertions.assertThat((String)orderedEvents.getFirst()).isEqualToIgnoringCase((CharSequence)"create");
            Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotFireDeleteEventOnTaskDeleteAttemptInDeleteListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "delete", TaskDeleteTaskListener.class);
        this.testRule.deploy(model);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.deleteProcessInstance(processInstance.getId(), "Canceled!")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("The task cannot be deleted because is part of a running process");
        }
        finally {
            LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
            Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
            Assertions.assertThat((String)orderedEvents.getFirst()).isEqualToIgnoringCase((CharSequence)"create");
            Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"delete");
        }
    }

    @Test
    public void shouldNotFireDeleteEventOnProcessDeleteAttemptInDeleteListener() {
        BpmnModelInstance model = this.createModelWithTaskEventsRecorderOnAssignedUserTask(TRACKED_EVENTS, null, "delete", ProcessInstanceDeleteTaskListener.class);
        this.testRule.deploy(model);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "Canceled!");
        LinkedList<String> orderedEvents = RecorderTaskListener.getOrderedEvents();
        Assertions.assertThat((int)orderedEvents.size()).isEqualTo(2);
        Assertions.assertThat((String)orderedEvents.getFirst()).isEqualToIgnoringCase((CharSequence)"create");
        Assertions.assertThat((String)orderedEvents.getLast()).isEqualToIgnoringCase((CharSequence)"delete");
    }

    public static class ProcessInstanceDeleteTaskListener
    implements TaskListener {
        public void notify(DelegateTask delegateTask) {
            delegateTask.getProcessEngineServices().getRuntimeService().deleteProcessInstance(delegateTask.getProcessInstanceId(), "Trigger a Task Delete event.");
        }
    }

    public static class TaskDeleteTaskListener
    implements TaskListener {
        public void notify(DelegateTask delegateTask) {
            delegateTask.getProcessEngineServices().getTaskService().deleteTask(delegateTask.getId());
        }
    }

    public static class ModifyingTaskListener
    implements TaskListener {
        public void notify(DelegateTask delegateTask) {
            delegateTask.setAssignee("demo");
            delegateTask.setOwner("john");
            delegateTask.setDueDate(new Date());
        }
    }
}

