/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.usertask;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class TaskFollowUpDateExtensionsTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/usertask/TaskFollowUpDateExtensionsTest.testUserTaskFollowUpDate.bpmn20.xml"})
    @Test
    public void testUserTaskFollowUpDateExtension() throws Exception {
        Date date = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss").parse("01-01-2015 12:10:00");
        HashMap<String, Date> variables = new HashMap<String, Date>();
        variables.put("dateVariable", date);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task.getFollowUpDate());
        Assert.assertEquals((Object)date, (Object)task.getFollowUpDate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/usertask/TaskFollowUpDateExtensionsTest.testUserTaskFollowUpDate.bpmn20.xml"})
    @Test
    public void testUserTaskFollowUpDateStringExtension() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("dateVariable", "2015-01-01T12:10:00");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task.getFollowUpDate());
        Date date = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").parse("01-01-2015 12:10:00");
        Assert.assertEquals((Object)date, (Object)task.getFollowUpDate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/usertask/TaskFollowUpDateExtensionsTest.testUserTaskFollowUpDate.bpmn20.xml"})
    @Test
    public void testUserTaskRelativeFollowUpDate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("dateVariable", "P2DT2H30M");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date followUpDate = task.getFollowUpDate();
        Assert.assertNotNull((Object)followUpDate);
        Period period = new Period(task.getCreateTime().getTime(), followUpDate.getTime());
        Assert.assertEquals((long)period.getDays(), (long)2L);
        Assert.assertEquals((long)period.getHours(), (long)2L);
        Assert.assertEquals((long)period.getMinutes(), (long)30L);
    }
}

