/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import java.util.List;
import org.camunda.bpm.engine.batch.BatchStatistics;
import org.camunda.bpm.engine.batch.BatchStatisticsQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.BatchQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class BatchStatisticsQueryImpl
extends AbstractQuery<BatchStatisticsQuery, BatchStatistics>
implements BatchStatisticsQuery {
    protected static final long serialVersionUID = 1L;
    protected String batchId;
    protected String type;
    protected boolean isTenantIdSet = false;
    protected String[] tenantIds;
    protected SuspensionState suspensionState;

    public BatchStatisticsQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public BatchStatisticsQuery batchId(String batchId) {
        EnsureUtil.ensureNotNull("Batch id", (Object)batchId);
        this.batchId = batchId;
        return this;
    }

    public String getBatchId() {
        return this.batchId;
    }

    @Override
    public BatchStatisticsQuery type(String type) {
        EnsureUtil.ensureNotNull("Type", (Object)type);
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public BatchStatisticsQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    public String[] getTenantIds() {
        return this.tenantIds;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    @Override
    public BatchStatisticsQuery withoutTenantId() {
        this.tenantIds = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public BatchStatisticsQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public BatchStatisticsQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public BatchStatisticsQuery orderById() {
        return (BatchStatisticsQuery)this.orderBy(BatchQueryProperty.ID);
    }

    @Override
    public BatchStatisticsQuery orderByTenantId() {
        return (BatchStatisticsQuery)this.orderBy(BatchQueryProperty.TENANT_ID);
    }

    @Override
    public BatchStatisticsQuery orderByStartTime() {
        return (BatchStatisticsQuery)this.orderBy(BatchQueryProperty.START_TIME);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsCountGroupedByBatch(this);
    }

    @Override
    public List<BatchStatistics> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsGroupedByBatch(this, page);
    }
}

