/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyExecutionPropagationTest
extends PluggableProcessEngineTest {
    protected static final String CMMN_FILE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String SET_VARIABLE_CMMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/HumanTaskSetVariableExecutionListener.cmmn";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final String TENANT_ID = "tenant1";

    @Test
    public void testPropagateTenantIdToProcessDefinition() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertNotNull((Object)processDefinition);
        Assert.assertEquals((Object)TENANT_ID, (Object)processDefinition.getTenantId());
    }

    @Test
    public void testPropagateTenantIdToProcessInstance() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToConcurrentExecution() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().parallelGateway("fork").userTask().parallelGateway("join").endEvent().moveToNode("fork").userTask().connectTo("join").done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        List executions = this.runtimeService.createExecutionQuery().list();
        Assertions.assertThat((int)executions.size()).isEqualTo(3);
        Assertions.assertThat((String)((Execution)executions.get(0)).getTenantId()).isEqualTo((Object)TENANT_ID);
        Assertions.assertThat((String)((Execution)executions.get(1)).getTenantId()).isEqualTo((Object)TENANT_ID);
        Assertions.assertThat((String)((Execution)executions.get(2)).getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToEmbeddedSubprocess() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().subProcess().embeddedSubProcess().startEvent().userTask().endEvent().subProcessDone().endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        List executions = this.runtimeService.createExecutionQuery().list();
        Assertions.assertThat((int)executions.size()).isEqualTo(2);
        Assertions.assertThat((String)((Execution)executions.get(0)).getTenantId()).isEqualTo((Object)TENANT_ID);
        Assertions.assertThat((String)((Execution)executions.get(1)).getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToTask() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((Object)task).isNotNull();
        Assertions.assertThat((String)task.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceOnStartProcessInstance() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done());
        VariableMap variables = Variables.putValue((String)"var", (Object)"test");
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), (Map)variables);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assertions.assertThat((Object)variableInstance).isNotNull();
        Assertions.assertThat((String)variableInstance.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceFromExecution() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaClass(SetVariableTask.class.getName())).camundaAsyncAfter()).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assertions.assertThat((Object)variableInstance).isNotNull();
        Assertions.assertThat((String)variableInstance.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceFromTask() {
        this.testRule.deployForTenant(TENANT_ID, ((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().camundaAsyncAfter()).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        VariableMap variables = Variables.createVariables().putValue("var", (Object)"test");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariablesLocal(task.getId(), (Map)variables);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assertions.assertThat((Object)variableInstance).isNotNull();
        Assertions.assertThat((String)variableInstance.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToStartMessageEventSubscription() {
        this.testRule.deployForTenant(TENANT_ID, ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().message("start")).endEvent().done());
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assertions.assertThat((Object)eventSubscription).isNotNull();
        Assertions.assertThat((String)eventSubscription.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToStartSignalEventSubscription() {
        this.testRule.deployForTenant(TENANT_ID, ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().signal("start")).endEvent().done());
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assertions.assertThat((Object)eventSubscription).isNotNull();
        Assertions.assertThat((String)eventSubscription.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToIntermediateMessageEventSubscription() {
        this.testRule.deployForTenant(TENANT_ID, ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().intermediateCatchEvent().message("start")).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assertions.assertThat((Object)eventSubscription).isNotNull();
        Assertions.assertThat((String)eventSubscription.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToIntermediateSignalEventSubscription() {
        this.testRule.deployForTenant(TENANT_ID, ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().intermediateCatchEvent().signal("start")).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assertions.assertThat((Object)eventSubscription).isNotNull();
        Assertions.assertThat((String)eventSubscription.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToCompensationEventSubscription() {
        this.testRule.deployForTenant(TENANT_ID, "org/camunda/bpm/engine/test/api/multitenancy/compensationBoundaryEvent.bpmn");
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assertions.assertThat((Object)eventSubscription).isNotNull();
        Assertions.assertThat((String)eventSubscription.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToStartTimerJobDefinition() {
        this.testRule.deployForTenant(TENANT_ID, ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().timerWithDuration("PT1M")).endEvent().done());
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Assertions.assertThat((Object)jobDefinition).isNotNull();
        Assertions.assertThat((String)jobDefinition.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToIntermediateTimerJob() {
        this.testRule.deployForTenant(TENANT_ID, ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().intermediateCatchEvent().timerWithDuration("PT1M")).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        Assertions.assertThat((String)job.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToAsyncJob() {
        this.testRule.deployForTenant(TENANT_ID, ((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().camundaAsyncBefore()).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        Assertions.assertThat((String)job.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToFailedJobIncident() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaExpression("${failing}")).camundaAsyncBefore()).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assertions.assertThat((Object)incident).isNotNull();
        Assertions.assertThat((String)incident.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToFailedStartTimerIncident() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().timerWithDuration("PT1M")).serviceTask().camundaExpression("${failing}")).endEvent().done());
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assertions.assertThat((Object)incident).isNotNull();
        Assertions.assertThat((String)incident.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToFailedExternalTaskIncident() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaType("external")).camundaTopic("test")).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        List tasks = this.externalTaskService.fetchAndLock(1, "test-worker").topic("test", 1000L).execute();
        this.externalTaskService.handleFailure(((LockedExternalTask)tasks.get(0)).getId(), "test-worker", "expected", 0, 0L);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assertions.assertThat((Object)incident).isNotNull();
        Assertions.assertThat((String)incident.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToExternalTask() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaType("external")).camundaTopic("test")).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assertions.assertThat((Object)externalTask).isNotNull();
        Assertions.assertThat((String)externalTask.getTenantId()).isEqualTo((Object)TENANT_ID);
        List externalTasks = this.externalTaskService.fetchAndLock(1, "test").topic("test", 1000L).execute();
        Assertions.assertThat((int)externalTasks.size()).isEqualTo(1);
        Assertions.assertThat((String)((LockedExternalTask)externalTasks.get(0)).getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceOnCreateCaseInstance() {
        this.testRule.deployForTenant(TENANT_ID, CMMN_FILE);
        VariableMap variables = Variables.putValue((String)"var", (Object)"test");
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.caseService.createCaseInstanceById(caseDefinition.getId(), (Map)variables);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assertions.assertThat((Object)variableInstance).isNotNull();
        Assertions.assertThat((String)variableInstance.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceFromCaseExecution() {
        this.testRule.deployForTenant(TENANT_ID, SET_VARIABLE_CMMN_FILE);
        this.createCaseInstance();
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assertions.assertThat((Object)variableInstance).isNotNull();
        Assertions.assertThat((String)variableInstance.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceFromHumanTask() {
        this.testRule.deployForTenant(TENANT_ID, CMMN_FILE);
        this.createCaseInstance();
        VariableMap variables = Variables.createVariables().putValue("var", (Object)"test");
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.caseService.setVariables(caseExecution.getId(), (Map)variables);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assertions.assertThat((Object)variableInstance).isNotNull();
        Assertions.assertThat((String)variableInstance.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void testPropagateTenantIdToTaskOnCreateCaseInstance() {
        this.testRule.deployForTenant(TENANT_ID, CMMN_FILE);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.caseService.createCaseInstanceById(caseDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().taskName("A HumanTask").singleResult();
        Assertions.assertThat((Object)task).isNotNull();
        Assertions.assertThat((String)task.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    protected void startProcessInstance(String processDefinitionKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
    }

    protected CaseInstance createCaseInstance() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        return this.caseService.createCaseInstanceById(caseDefinition.getId());
    }

    public static class SetVariableTask
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            execution.setVariable("var", (Object)"test");
        }
    }
}

