/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyDecisionRequirementsDefinitionQueryTest {
    protected static final String DECISION_REQUIREMENTS_DEFINITION_KEY = "score";
    protected static final String DMN = "org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deploy(DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
    }

    @Test
    public void queryNoTenantIdSet() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void queryByTenantId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void queryByTenantIds() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void queryByDefinitionsWithoutTenantId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void queryByTenantIdsIncludeDefinitionsWithoutTenantId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).includeDecisionRequirementsDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).includeDecisionRequirementsDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionRequirementsDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void queryByKey() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY);
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void queryByLatestNoTenantIdSet() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Map<String, DecisionRequirementsDefinition> definitionsForTenant = this.getDecisionRequirementsDefinitionsForTenant(query.list());
        Assertions.assertThat((int)definitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(2);
        Assertions.assertThat((int)definitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)definitionsForTenant.get(null).getVersion()).isEqualTo(1);
    }

    @Test
    public void queryByLatestWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        DecisionRequirementsDefinition DecisionRequirementsDefinition2 = (DecisionRequirementsDefinition)query.singleResult();
        Assertions.assertThat((String)DecisionRequirementsDefinition2.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((int)DecisionRequirementsDefinition2.getVersion()).isEqualTo(2);
        query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        DecisionRequirementsDefinition2 = (DecisionRequirementsDefinition)query.singleResult();
        Assertions.assertThat((String)DecisionRequirementsDefinition2.getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((int)DecisionRequirementsDefinition2.getVersion()).isEqualTo(1);
    }

    @Test
    public void queryByLatestWithTenantIds() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionRequirementsDefinitionQuery query = (DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Map<String, DecisionRequirementsDefinition> definitionsForTenant = this.getDecisionRequirementsDefinitionsForTenant(query.list());
        Assertions.assertThat((int)definitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(2);
        Assertions.assertThat((int)definitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
    }

    @Test
    public void queryByLatestWithoutTenantId() {
        this.testRule.deploy(DMN);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        DecisionRequirementsDefinition DecisionRequirementsDefinition2 = (DecisionRequirementsDefinition)query.singleResult();
        Assertions.assertThat((String)DecisionRequirementsDefinition2.getTenantId()).isNull();
        Assertions.assertThat((int)DecisionRequirementsDefinition2.getVersion()).isEqualTo(2);
    }

    @Test
    public void queryByLatestWithTenantIdsIncludeDefinitionsWithoutTenantId() {
        this.testRule.deploy(DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(DECISION_REQUIREMENTS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionRequirementsDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Map<String, DecisionRequirementsDefinition> definitionsForTenant = this.getDecisionRequirementsDefinitionsForTenant(query.list());
        Assertions.assertThat((int)definitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(3);
        Assertions.assertThat((int)definitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)definitionsForTenant.get(null).getVersion()).isEqualTo(2);
    }

    @Test
    public void queryByNonExistingTenantId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void failQueryByTenantIdNull() {
        Assertions.assertThatThrownBy(() -> this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{null})).isInstanceOf(NullValueException.class);
    }

    @Test
    public void querySortingAsc() {
        List DecisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assertions.assertThat((List)DecisionRequirementsDefinitions).hasSize(2);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)DecisionRequirementsDefinitions.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)DecisionRequirementsDefinitions.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void querySortingDesc() {
        List DecisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assertions.assertThat((List)DecisionRequirementsDefinitions).hasSize(2);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)DecisionRequirementsDefinitions.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((DecisionRequirementsDefinition)DecisionRequirementsDefinitions.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void queryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void queryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionRequirementsDefinitionsWithoutTenantId().count()).isEqualTo(2L);
    }

    @Test
    public void queryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void queryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    protected Map<String, DecisionRequirementsDefinition> getDecisionRequirementsDefinitionsForTenant(List<DecisionRequirementsDefinition> definitions) {
        HashMap<String, DecisionRequirementsDefinition> definitionsForTenant = new HashMap<String, DecisionRequirementsDefinition>();
        for (DecisionRequirementsDefinition definition : definitions) {
            definitionsForTenant.put(definition.getTenantId(), definition);
        }
        return definitionsForTenant;
    }
}

