/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.decisiontask;

import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnDecisionResultEntries;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.CmmnTest;
import org.camunda.bpm.engine.test.cmmn.decisiontask.DecisionResultTestListener;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DmnDecisionTaskResultListenerTest
extends CmmnTest {
    protected static final String TEST_CASE = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn";
    protected static final String TEST_DECISION = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml";
    protected static final String TEST_DECISION_COLLECT_SUM = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml";
    protected static final String TEST_DECISION_COLLECT_COUNT = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectCountHitPolicyTest.dmn11.xml";
    protected DmnDecisionResult results;

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testNoOutput() {
        this.startTestCase("no output");
        Assert.assertTrue((String)"The decision result 'ruleResult' should be empty", (boolean)this.results.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testEmptyOutput() {
        this.startTestCase("empty output");
        Assert.assertFalse((String)"The decision result 'ruleResult' should not be empty", (boolean)this.results.isEmpty());
        DmnDecisionResultEntries decisionOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertNull((Object)decisionOutput.getFirstEntry());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testEmptyMap() {
        this.startTestCase("empty map");
        Assert.assertEquals((long)2L, (long)this.results.size());
        for (DmnDecisionResultEntries output : this.results) {
            Assert.assertTrue((String)"The decision output should be empty", (boolean)output.isEmpty());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testSingleEntry() {
        this.startTestCase("single entry");
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertEquals((Object)"foo", (Object)firstOutput.getFirstEntry());
        Assert.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testMultipleEntries() {
        this.startTestCase("multiple entries");
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertEquals((Object)"foo", (Object)firstOutput.get((Object)"result1"));
        Assert.assertEquals((Object)"bar", (Object)firstOutput.get((Object)"result2"));
        Assert.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)firstOutput.getEntryTyped("result1"));
        Assert.assertEquals((Object)Variables.stringValue((String)"bar"), (Object)firstOutput.getEntryTyped("result2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testSingleEntryList() {
        this.startTestCase("single entry list");
        Assert.assertEquals((long)2L, (long)this.results.size());
        for (DmnDecisionResultEntries output : this.results) {
            Assert.assertEquals((Object)"foo", (Object)output.getFirstEntry());
            Assert.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)output.getFirstEntryTyped());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    @Test
    public void testMultipleEntriesList() {
        this.startTestCase("multiple entries list");
        Assert.assertEquals((long)2L, (long)this.results.size());
        for (DmnDecisionResultEntries output : this.results) {
            Assert.assertEquals((long)2L, (long)output.size());
            Assert.assertEquals((Object)"foo", (Object)output.get((Object)"result1"));
            Assert.assertEquals((Object)"bar", (Object)output.get((Object)"result2"));
            Assert.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)output.getEntryTyped("result1"));
            Assert.assertEquals((Object)Variables.stringValue((String)"bar"), (Object)output.getEntryTyped("result2"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectCountHitPolicyTest.dmn11.xml"})
    @Test
    public void testCollectCountHitPolicyNoOutput() {
        this.startTestCase("no output");
        Assert.assertEquals((long)1L, (long)this.results.size());
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertEquals((long)0L, (long)((Integer)firstOutput.getFirstEntry()).intValue());
        Assert.assertEquals((Object)Variables.integerValue((Integer)0), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    @Test
    public void testCollectSumHitPolicyNoOutput() {
        this.startTestCase("no output");
        Assert.assertTrue((String)"The decision result 'ruleResult' should be empty", (boolean)this.results.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    @Test
    public void testCollectSumHitPolicySingleEntry() {
        this.startTestCase("single entry");
        Assert.assertEquals((long)1L, (long)this.results.size());
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertEquals((long)12L, (long)((Integer)firstOutput.getFirstEntry()).intValue());
        Assert.assertEquals((Object)Variables.integerValue((Integer)12), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    @Test
    public void testCollectSumHitPolicySingleEntryList() {
        this.startTestCase("single entry list");
        Assert.assertEquals((long)1L, (long)this.results.size());
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        Assert.assertEquals((long)33L, (long)((Integer)firstOutput.getFirstEntry()).intValue());
        Assert.assertEquals((Object)Variables.integerValue((Integer)33), (Object)firstOutput.getFirstEntryTyped());
    }

    protected CaseInstance startTestCase(String input) {
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", Variables.createVariables().putValue("input", (Object)input));
        this.results = DecisionResultTestListener.getDecisionResult();
        Assert.assertNotNull((Object)this.results);
        return caseInstance;
    }

    @After
    public void tearDown() throws Exception {
        DecisionResultTestListener.reset();
    }
}

