/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.CachedDbEntity;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.junit.Assert;
import org.junit.Test;

public class CompetingVariableFetchingAndDeletionTest
extends ConcurrencyTestCase {
    private ConcurrencyTestHelper.ThreadControl asyncThread;

    @Test
    public void testConcurrentFetchAndDelete() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)"test").startEvent().userTask().endEvent().done());
        List<String> listVar = Arrays.asList("a", "b");
        String pid = this.runtimeService.startProcessInstanceByKey("test", (Map)Variables.createVariables().putValue("listVar", listVar)).getId();
        this.asyncThread = this.executeControllableCommand(new FetchVariableCmd(pid, "listVar"));
        this.asyncThread.waitForSync();
        this.runtimeService.deleteProcessInstance(pid, null);
        this.asyncThread.makeContinue();
        this.asyncThread.waitUntilDone();
    }

    static class FetchVariableCmd
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected String executionId;
        protected String varName;

        public FetchVariableCmd(String executionId, String varName) {
            this.executionId = executionId;
            this.varName = varName;
        }

        public Void execute(CommandContext commandContext) {
            ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
            VariableInstanceEntity varInstance = (VariableInstanceEntity)execution.getVariableInstanceLocal(this.varName);
            String byteArrayValueId = varInstance.getByteArrayValueId();
            Assert.assertNotNull((String)"Byte array id is expected to be not null", (Object)byteArrayValueId);
            CachedDbEntity cachedByteArray = commandContext.getDbEntityManager().getDbEntityCache().getCachedEntity(ByteArrayEntity.class, byteArrayValueId);
            Assert.assertNull((String)"Byte array is expected to be not fetched yet / lazily fetched.", (Object)cachedByteArray);
            this.monitor.sync();
            Object value = varInstance.getValue();
            Assert.assertNull((String)"Expecting the value to be null (deleted)", (Object)value);
            return null;
        }
    }
}

