/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.calendar;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.camunda.bpm.engine.impl.calendar.CycleBusinessCalendar;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CycleBusinessCalendarTest {
    @After
    public void tearDown() {
        ClockUtil.reset();
    }

    @Test
    public void testSimpleCron() throws Exception {
        CycleBusinessCalendar businessCalendar = new CycleBusinessCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd - HH:mm");
        Date now = simpleDateFormat.parse("2011 03 11 - 17:23");
        ClockUtil.setCurrentTime((Date)now);
        Date duedate = businessCalendar.resolveDuedate("0 0 0 1 * ?");
        Date expectedDuedate = simpleDateFormat.parse("2011 04 1 - 00:00");
        Assert.assertEquals((Object)expectedDuedate, (Object)duedate);
    }

    @Test
    public void testSimpleDuration() throws Exception {
        CycleBusinessCalendar businessCalendar = new CycleBusinessCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd - HH:mm");
        Date now = simpleDateFormat.parse("2010 06 11 - 17:23");
        ClockUtil.setCurrentTime((Date)now);
        Date duedate = businessCalendar.resolveDuedate("R/P2DT5H70M");
        Date expectedDuedate = simpleDateFormat.parse("2010 06 13 - 23:33");
        Assert.assertEquals((Object)expectedDuedate, (Object)duedate);
    }

    @Test
    public void testSimpleCronWithStartDate() throws Exception {
        CycleBusinessCalendar businessCalendar = new CycleBusinessCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd - HH:mm");
        Date now = simpleDateFormat.parse("2011 03 11 - 17:23");
        Date duedate = businessCalendar.resolveDuedate("0 0 0 1 * ?", now);
        Date expectedDuedate = simpleDateFormat.parse("2011 04 1 - 00:00");
        Assert.assertEquals((Object)expectedDuedate, (Object)duedate);
    }

    @Test
    public void testSimpleDurationWithStartDate() throws Exception {
        CycleBusinessCalendar businessCalendar = new CycleBusinessCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd - HH:mm");
        Date now = simpleDateFormat.parse("2010 06 11 - 17:23");
        Date duedate = businessCalendar.resolveDuedate("R/P2DT5H70M", now);
        Date expectedDuedate = simpleDateFormat.parse("2010 06 13 - 23:33");
        Assert.assertEquals((Object)expectedDuedate, (Object)duedate);
    }
}

