/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch.removaltime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchElementConfiguration;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.history.SetRemovalTimeToHistoricProcessInstancesBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricProcessInstancesCmd
implements Command<Batch> {
    protected SetRemovalTimeToHistoricProcessInstancesBuilderImpl builder;

    public SetRemovalTimeToHistoricProcessInstancesCmd(SetRemovalTimeToHistoricProcessInstancesBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        if (this.builder.getQuery() == null && this.builder.getIds() == null) {
            throw new BadUserRequestException("Neither query nor ids provided.");
        }
        BatchElementConfiguration elementConfiguration = this.collectInstances(commandContext);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "removalTime", (Object)this.builder.getMode());
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicProcessInstances", elementConfiguration.getIds());
        return new BatchBuilder(commandContext).type("process-set-removal-time").config(this.getConfiguration(elementConfiguration)).permission(BatchPermissions.CREATE_BATCH_SET_REMOVAL_TIME).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected BatchElementConfiguration collectInstances(CommandContext commandContext) {
        List<String> instanceIds;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        HistoricProcessInstanceQuery instanceQuery = this.builder.getQuery();
        if (instanceQuery != null) {
            elementConfiguration.addDeploymentMappings(((HistoricProcessInstanceQueryImpl)instanceQuery).listDeploymentIdMappings());
        }
        if (!CollectionUtil.isEmpty(instanceIds = this.builder.getIds())) {
            HistoricProcessInstanceQueryImpl query = new HistoricProcessInstanceQueryImpl();
            query.processInstanceIds(new HashSet<String>(instanceIds));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(query::listDeploymentIdMappings));
        }
        return elementConfiguration;
    }

    protected BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new SetRemovalTimeBatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings()).setHierarchical(this.builder.isHierarchical()).setHasRemovalTime(this.hasRemovalTime()).setRemovalTime(this.builder.getRemovalTime());
    }

    protected boolean hasRemovalTime() {
        return this.builder.getMode() == SetRemovalTimeToHistoricProcessInstancesBuilderImpl.Mode.ABSOLUTE_REMOVAL_TIME || this.builder.getMode() == SetRemovalTimeToHistoricProcessInstancesBuilderImpl.Mode.CLEARED_REMOVAL_TIME;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("mode", null, (Object)this.builder.getMode()));
        propertyChanges.add(new PropertyChange("removalTime", null, this.builder.getRemovalTime()));
        propertyChanges.add(new PropertyChange("hierarchical", null, this.builder.isHierarchical()));
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        commandContext.getOperationLogManager().logProcessInstanceOperation("SetRemovalTime", propertyChanges);
    }
}

