/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import camundajar.impl.com.google.gson.JsonObject;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.DeploymentMappingJsonConverter;
import org.camunda.bpm.engine.impl.batch.DeploymentMappings;
import org.camunda.bpm.engine.impl.batch.message.MessageCorrelationBatchConfiguration;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class MessageCorrelationBatchConfigurationJsonConverter
extends JsonObjectConverter<MessageCorrelationBatchConfiguration> {
    public static final MessageCorrelationBatchConfigurationJsonConverter INSTANCE = new MessageCorrelationBatchConfigurationJsonConverter();
    public static final String MESSAGE_NAME = "messageName";
    public static final String PROCESS_INSTANCE_IDS = "processInstanceIds";
    public static final String PROCESS_INSTANCE_ID_MAPPINGS = "processInstanceIdMappings";
    public static final String BATCH_ID = "batchId";

    @Override
    public JsonObject toJsonObject(MessageCorrelationBatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addField(json, MESSAGE_NAME, configuration.getMessageName());
        JsonUtil.addListField(json, PROCESS_INSTANCE_IDS, configuration.getIds());
        JsonUtil.addListField(json, PROCESS_INSTANCE_ID_MAPPINGS, DeploymentMappingJsonConverter.INSTANCE, configuration.getIdMappings());
        JsonUtil.addField(json, BATCH_ID, configuration.getBatchId());
        return json;
    }

    @Override
    public MessageCorrelationBatchConfiguration toObject(JsonObject json) {
        return new MessageCorrelationBatchConfiguration(this.readProcessInstanceIds(json), this.readIdMappings(json), JsonUtil.getString(json, MESSAGE_NAME, null), JsonUtil.getString(json, BATCH_ID));
    }

    protected List<String> readProcessInstanceIds(JsonObject jsonObject) {
        return JsonUtil.asStringList(JsonUtil.getArray(jsonObject, PROCESS_INSTANCE_IDS));
    }

    protected DeploymentMappings readIdMappings(JsonObject json) {
        return JsonUtil.asList(JsonUtil.getArray(json, PROCESS_INSTANCE_ID_MAPPINGS), DeploymentMappingJsonConverter.INSTANCE, DeploymentMappings::new);
    }
}

