/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.job;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SetJobRetriesAuthorizationTest {
    static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    ManagementService managementService;
    @Parameterized.Parameter
    public AuthorizationScenario scenario;
    protected String deploymentId;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "anyProcessInstanceId", "userId", new Permission[]{ProcessInstancePermissions.RETRY_JOB}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{ProcessDefinitionPermissions.RETRY_JOB}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "anyProcessInstanceId", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{Permissions.UPDATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.revoke((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{ProcessDefinitionPermissions.RETRY_JOB})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "anyProcessInstanceId", "userId", new Permission[]{ProcessInstancePermissions.RETRY_JOB}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{ProcessDefinitionPermissions.RETRY_JOB}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "anyProcessInstanceId", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{Permissions.UPDATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "specProcessInstanceId", "userId", new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.RETRY_JOB})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "anyProcessInstanceId", "userId", new Permission[]{ProcessInstancePermissions.RETRY_JOB}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{ProcessDefinitionPermissions.RETRY_JOB}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "anyProcessInstanceId", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{Permissions.UPDATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "anyProcessInstanceId", "userId", new Permission[]{ProcessInstancePermissions.RETRY_JOB})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{ProcessDefinitionPermissions.RETRY_JOB})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "anyProcessInstanceId", "userId", new Permission[]{Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "userId", new Permission[]{ProcessDefinitionPermissions.RETRY_JOB})).succeeds());
    }

    @Before
    public void setUp() throws Exception {
        this.managementService = this.engineRule.getManagementService();
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldSetJobRetriesByJobDefinitionId() {
        String processInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.authRule.init(this.scenario).withUser("userId").bindResource("anyProcessInstanceId", "*").bindResource("specProcessInstanceId", processInstanceId).start();
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 1);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobById(jobId);
            Assertions.assertThat((Object)job).isNotNull();
            Assertions.assertThat((int)job.getRetries()).isEqualTo(1);
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml"})
    public void shouldSetJobRetries() {
        String processInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("anyProcessInstanceId", processInstanceId).bindResource("specProcessInstanceId", "unexisting").start();
        this.managementService.setJobRetries(jobId, 1);
        if (this.authRule.assertScenario(this.scenario)) {
            Job job = this.selectJobById(jobId);
            Assertions.assertThat((Object)job).isNotNull();
            Assertions.assertThat((int)job.getRetries()).isEqualTo(1);
        }
    }

    protected Job selectJobByProcessInstanceId(String processInstanceId) {
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        return job;
    }

    protected Job selectJobById(String jobId) {
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        return job;
    }

    protected JobDefinition selectJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
        return jobDefinition;
    }
}

