/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.batch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.history.removaltime.batch.helper.BatchSetRemovalTimeRule;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BatchSetRemovalTimeHierarchicalTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchSetRemovalTimeRule testRule = new BatchSetRemovalTimeRule(this.engineRule, this.engineTestRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule).around((TestRule)this.testRule);
    protected final Date CURRENT_DATE;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected ExternalTaskService externalTaskService;
    protected DecisionService decisionService;
    protected AuthorizationService authorizationService;

    public BatchSetRemovalTimeHierarchicalTest() {
        this.CURRENT_DATE = this.testRule.CURRENT_DATE;
    }

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.decisionService = this.engineRule.getDecisionService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionInstance() {
        this.testRule.process().call().passVars("temperature", "dayType").ruleTask("dish-decision").userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeToStandaloneDecision_RootDecisionInstance() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("dish-decision").list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("dish-decision").list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeToStandaloneDecision_ChildDecisionInstance() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionInputInstance() {
        this.testRule.process().call().passVars("temperature", "dayType").ruleTask("dish-decision").userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_RootDecisionInputInstance() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().decisionDefinitionKey("dish-decision").singleResult();
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().decisionDefinitionKey("dish-decision").singleResult();
        historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_ChildDecisionInputInstance() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().decisionDefinitionKey("season").singleResult();
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().decisionDefinitionKey("season").singleResult();
        historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionOutputInstance() {
        this.testRule.process().call().passVars("temperature", "dayType").ruleTask("dish-decision").userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_RootDecisionOutputInstance() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().decisionDefinitionKey("dish-decision").singleResult();
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().decisionDefinitionKey("dish-decision").singleResult();
        historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_ChildDecisionOutputInstance() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().decisionDefinitionKey("season").singleResult();
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().decisionDefinitionKey("season").singleResult();
        historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ProcessInstance() {
        this.testRule.process().call().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ActivityInstance() {
        this.testRule.process().call().userTask().deploy().start();
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityName("userTask").singleResult();
        Assertions.assertThat((Date)historicActivityInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityName("userTask").singleResult();
        Assertions.assertThat((Date)historicActivityInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_TaskInstance() {
        this.testRule.process().call().userTask().deploy().start();
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicTaskInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicTaskInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_HistoricTaskInstanceAuthorization() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(true);
        this.testRule.enableAuth();
        this.testRule.process().call().userTask().deploy().start();
        this.testRule.disableAuth();
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicTaskInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Assertions.assertThat((Date)authorization.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldNotSetRemovalTime_HistoricTaskInstancePermissionsDisabled() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(true);
        this.testRule.enableAuth();
        this.testRule.process().call().userTask().deploy().start();
        this.testRule.disableAuth();
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(false);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Assertions.assertThat((Date)authorization.getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_HistoricProcessInstanceAuthorization() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(true);
        String rootProcessInstanceId = this.testRule.process().call().userTask().deploy().start();
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{"userTask"}).singleResult()).getId();
        authorization.setResourceId(processInstanceId);
        authorization.setUserId("foo");
        this.authorizationService.saveAuthorization(authorization);
        AuthorizationQuery authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, processInstanceId, rootProcessInstanceId})});
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Date removalTime = BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{removalTime, processInstanceId, rootProcessInstanceId})});
    }

    @Test
    public void shouldNotSetRemovalTime_HistoricProcessInstancePermissionsDisabled() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(false);
        String rootProcessInstanceId = this.testRule.process().call().userTask().deploy().start();
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{"userTask"}).singleResult()).getId();
        authorization.setResourceId(processInstanceId);
        authorization.setUserId("foo");
        this.authorizationService.saveAuthorization(authorization);
        AuthorizationQuery authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, processInstanceId, rootProcessInstanceId})});
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, processInstanceId, rootProcessInstanceId})});
    }

    @Test
    public void shouldSetRemovalTime_VariableInstance() {
        this.testRule.process().call().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue"));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicVariableInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicVariableInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_Detail() {
        this.testRule.process().call().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue"));
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        Assertions.assertThat((Date)historicDetail.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        Assertions.assertThat((Date)historicDetail.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ExternalTaskLog() {
        this.testRule.process().call().externalTask().deploy().start();
        HistoricExternalTaskLog historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_JobLog() {
        this.testRule.process().call().async().userTask().deploy().start();
        HistoricJobLog job = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processDefinitionKey("process").singleResult();
        Assertions.assertThat((Date)job.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        job = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processDefinitionKey("process").singleResult();
        Assertions.assertThat((Date)job.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_Incident() {
        String rootProcessInstanceId = this.testRule.process().call().async().userTask().deploy().start();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        String leafProcessInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(rootProcessInstanceId).singleResult()).getId();
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().processInstanceId(leafProcessInstanceId).singleResult();
        Assertions.assertThat((Date)historicIncident.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().processInstanceId(leafProcessInstanceId).singleResult();
        Assertions.assertThat((Date)historicIncident.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_OperationLog() {
        String processInstanceId = this.testRule.process().call().async().userTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_IdentityLinkLog() {
        this.testRule.process().call().userTask().deploy().start();
        HistoricIdentityLinkLog identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_CommentByTaskId() {
        this.testRule.process().call().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        this.taskService.createComment(taskId, null, "aComment");
        Comment comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)comment.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_CommentByProcessInstanceId() {
        String processInstanceId = this.testRule.process().call().userTask().deploy().start();
        this.taskService.createComment(null, processInstanceId, "aComment");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)comment.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_AttachmentByTaskId() {
        this.testRule.process().call().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        Attachment attachment = this.taskService.createAttachment(null, taskId, null, null, null, "http://camunda.com");
        Assertions.assertThat((Date)attachment.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        attachment = (Attachment)this.taskService.getTaskAttachments(taskId).get(0);
        Assertions.assertThat((Date)attachment.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_AttachmentByProcessInstanceId() {
        String processInstanceId = this.testRule.process().call().userTask().deploy().start();
        Attachment attachment = this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com");
        Assertions.assertThat((Date)attachment.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        attachment = (Attachment)this.taskService.getProcessInstanceAttachments(processInstanceId).get(0);
        Assertions.assertThat((Date)attachment.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_AttachmentByTaskId() {
        this.testRule.process().call().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, taskId, null, null, null, (InputStream)new ByteArrayInputStream("".getBytes()));
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(attachment.getContentId());
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(attachment.getContentId());
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_AttachmentByProcessInstanceId() {
        String processInstanceId = this.testRule.process().call().userTask().deploy().start();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, null, processInstanceId, null, null, (InputStream)new ByteArrayInputStream("".getBytes()));
        String byteArrayId = attachment.getContentId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_Variable() {
        this.testRule.process().call().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)Variables.fileValue((String)"file.xml").file("<root />".getBytes())));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        String byteArrayId = ((HistoricVariableInstanceEntity)historicVariableInstance).getByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_JobLog() {
        this.testRule.process().call().async().scriptTask().deploy().start();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLog historicJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        String byteArrayId = ((HistoricJobLogEventEntity)historicJobLog).getExceptionByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_ExternalTaskLog() {
        this.testRule.process().call().externalTask().deploy().start();
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("aTopicName", Integer.MAX_VALUE).execute().get(0)).getId();
        this.externalTaskService.handleFailure(externalTaskId, "aWorkerId", null, "errorDetails", 5, 3000L);
        HistoricExternalTaskLog externalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult();
        String byteArrayId = ((HistoricExternalTaskLogEntity)externalTaskLog).getErrorDetailsByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldSetRemovalTime_ByteArray_DecisionInputInstance() {
        this.testRule.process().call().passVars("pojo").ruleTask("testDecision").userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        String byteArrayId = ((HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/removaltime/drd.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_ByteArray_RootDecisionInputInstance() {
        this.decisionService.evaluateDecisionByKey("root").variables((Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37))).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().decisionDefinitionKey("root").singleResult();
        String byteArrayId = ((HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0)).getByteArrayValueId();
        this.testRule.updateHistoryTimeToLiveDmn("root", 5);
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/removaltime/drd.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_ByteArray_ChildDecisionInputInstance() {
        this.decisionService.evaluateDecisionByKey("root").variables((Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37))).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().decisionDefinitionKey("child").singleResult();
        String byteArrayId = ((HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0)).getByteArrayValueId();
        this.testRule.updateHistoryTimeToLiveDmn("root", 5);
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldSetRemovalTime_ByteArray_DecisionOutputInstance() {
        this.testRule.process().call().passVars("pojo").ruleTask("testDecision").userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        String byteArrayId = ((HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/removaltime/drd.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_ByteArray_RootDecisionOutputInstance() {
        this.decisionService.evaluateDecisionByKey("root").variables((Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37))).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().decisionDefinitionKey("root").singleResult();
        String byteArrayId = ((HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0)).getByteArrayValueId();
        this.testRule.updateHistoryTimeToLiveDmn("root", 5);
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/removaltime/drd.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_ByteArray_ChildDecisionOutputInstance() {
        this.decisionService.evaluateDecisionByKey("root").variables((Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37))).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().decisionDefinitionKey("child").singleResult();
        String byteArrayId = ((HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0)).getByteArrayValueId();
        this.testRule.updateHistoryTimeToLiveDmn("root", 5);
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }
}

