/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.ManagementServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.telemetry.ApplicationServer;
import org.camunda.bpm.engine.telemetry.Command;
import org.camunda.bpm.engine.telemetry.Metric;
import org.camunda.bpm.engine.telemetry.TelemetryData;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ManagementServiceGetTelemetryDataTest {
    protected static final String TELEMETRY_CONFIGURE_CMD_NAME = "TelemetryConfigureCmd";
    protected static final String IS_TELEMETRY_ENABLED_CMD_NAME = "IsTelemetryEnabledCmd";
    protected static final String GET_TELEMETRY_DATA_CMD_NAME = "GetTelemetryDataCmd";
    protected static final String GET_HISTORY_LEVEL_CMD_NAME = "GetHistoryLevelCmd";
    protected static final String GET_LICENSE_KEY_CMD_NAME = "GetLicenseKeyCmd";
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl configuration;
    protected ManagementServiceImpl managementService;
    protected RuntimeService runtimeService;
    protected TelemetryRegistry telemetryRegistry;
    protected MetricsRegistry metricsRegistry;
    protected TelemetryDataImpl defaultTelemetryData;
    protected TelemetryReporter defaultTelemetryReporter;

    @Before
    public void setup() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.telemetryRegistry = this.configuration.getTelemetryRegistry();
        this.metricsRegistry = this.configuration.getMetricsRegistry();
        this.defaultTelemetryData = new TelemetryDataImpl(this.configuration.getTelemetryData());
        this.defaultTelemetryReporter = this.configuration.getTelemetryReporter();
        this.clearTelemetry();
    }

    @After
    public void tearDown() {
        if (Boolean.TRUE.equals(this.managementService.isTelemetryEnabled())) {
            this.managementService.toggleTelemetry(false);
        }
        this.clearTelemetry();
        this.configuration.setTelemetryData(this.defaultTelemetryData);
        this.configuration.setTelemetryReporter(this.defaultTelemetryReporter);
    }

    protected void clearTelemetry() {
        this.metricsRegistry.clearTelemetryMetrics();
        this.managementService.deleteMetrics(null);
        this.configuration.getTelemetryRegistry().clear();
    }

    @Test
    public void shouldReturnTelemetryData_TelemetryEnabled() {
        this.managementService.toggleTelemetry(true);
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Object)telemetryData).isNotNull();
        Assertions.assertThat((String)telemetryData.getInstallation()).isNotEmpty();
    }

    @Test
    public void shouldReturnTelemetryData_TelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Object)telemetryData).isNotNull();
        Assertions.assertThat((String)telemetryData.getInstallation()).isNotEmpty();
    }

    @Test
    public void shouldReturnLicenseKey() {
        this.managementService.setLicenseKeyForTelemetry(new LicenseKeyDataImpl(null, null, null, null, null, "test license"));
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((String)telemetryData.getProduct().getInternals().getLicenseKey().getRaw()).isEqualTo((Object)"test license");
    }

    @Test
    public void shouldReturnWebapps() {
        this.managementService.addWebappToTelemetry("cockpit");
        this.managementService.addWebappToTelemetry("admin");
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Iterable)telemetryData.getProduct().getInternals().getWebapps()).containsExactlyInAnyOrder((Object[])new String[]{"cockpit", "admin"});
    }

    @Test
    public void shouldReturnApplicationServerInfo() {
        this.managementService.addApplicationServerInfoToTelemetry("Apache Tomcat/10.0.1");
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        ApplicationServer applicationServer = telemetryData.getProduct().getInternals().getApplicationServer();
        Assertions.assertThat((String)applicationServer.getVendor()).isEqualTo((Object)"Apache Tomcat");
        Assertions.assertThat((String)applicationServer.getVersion()).isEqualTo((Object)"Apache Tomcat/10.0.1");
    }

    @Test
    public void shouldStartWithCommandCountZero() {
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Map)telemetryData.getProduct().getInternals().getCommands()).isEmpty();
    }

    @Test
    public void shouldNotResetCommandCount() {
        this.managementService.isTelemetryEnabled();
        this.managementService.getTelemetryData();
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Command)telemetryData.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(1L);
    }

    @Test
    public void shouldStartWithMetricsCountZero() {
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Map metrics = telemetryData.getProduct().getInternals().getMetrics();
        Assertions.assertThat((Map)metrics).containsOnlyKeys((Object[])new String[]{"flow-node-instances", "process-instances", "executed-decision-elements", "decision-instances"});
        Assertions.assertThat((long)((Metric)metrics.get("flow-node-instances")).getCount()).isZero();
        Assertions.assertThat((long)((Metric)metrics.get("process-instances")).getCount()).isZero();
        Assertions.assertThat((long)((Metric)metrics.get("executed-decision-elements")).getCount()).isZero();
        Assertions.assertThat((long)((Metric)metrics.get("decision-instances")).getCount()).isZero();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldNotResetMetricsCount() {
        this.engineRule.getRuntimeService().startProcessInstanceByKey("oneTaskProcess");
        this.managementService.getTelemetryData();
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Metric)telemetryData.getProduct().getInternals().getMetrics().get("flow-node-instances")).getCount()).isEqualTo(2L);
        Assertions.assertThat((long)((Metric)telemetryData.getProduct().getInternals().getMetrics().get("process-instances")).getCount()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCollectMetrics_TelemetryEnabled() {
        this.managementService.toggleTelemetry(true);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("oneTaskProcess");
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Metric)telemetryData.getProduct().getInternals().getMetrics().get("process-instances")).getCount()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCollectMetrics_TelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("oneTaskProcess");
        TelemetryData telemetryDataAfterPiStart = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Metric)telemetryDataAfterPiStart.getProduct().getInternals().getMetrics().get("process-instances")).getCount()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCollectCommands_TelemetryEnabled() {
        this.managementService.toggleTelemetry(true);
        this.managementService.isTelemetryEnabled();
        TelemetryData telemetryDataAfterPiStart = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Command)telemetryDataAfterPiStart.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCollectCommands_TelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        this.managementService.isTelemetryEnabled();
        TelemetryData telemetryDataAfterPiStart = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Command)telemetryDataAfterPiStart.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(1L);
    }

    @Test
    public void shouldThrowExceptionOnNullTelemetryReporter() {
        this.configuration.setTelemetryReporter(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.getTelemetryData()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Error while retrieving telemetry data. Telemetry registry was not initialized.");
    }

    @Test
    public void shouldResetCollectedCommandsDataWhenTelemetryEnabled() {
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        this.managementService.toggleTelemetry(true);
        this.managementService.getTelemetryData();
        this.managementService.getTelemetryData();
        this.managementService.isTelemetryEnabled();
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Map commands = telemetryData.getProduct().getInternals().getCommands();
        Assertions.assertThat((int)commands.size()).isEqualTo(3);
        Assertions.assertThat((long)((Command)commands.get(GET_TELEMETRY_DATA_CMD_NAME)).getCount()).isEqualTo(2L);
        Assertions.assertThat((long)((Command)commands.get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(1L);
        Assertions.assertThat((long)((Command)commands.get(TELEMETRY_CONFIGURE_CMD_NAME)).getCount()).isEqualTo(1L);
        Assertions.assertThat((Object)((Command)commands.get(GET_HISTORY_LEVEL_CMD_NAME))).isNull();
        Assertions.assertThat((Object)((Command)commands.get(GET_LICENSE_KEY_CMD_NAME))).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldResetCollectedMetricsDataWhenTelemetryEnabled() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.managementService.toggleTelemetry(true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Map metrics = telemetryData.getProduct().getInternals().getMetrics();
        Assertions.assertThat((int)metrics.size()).isEqualTo(4);
        Assertions.assertThat((long)((Metric)metrics.get("flow-node-instances")).getCount()).isEqualTo(2L);
        Assertions.assertThat((long)((Metric)metrics.get("process-instances")).getCount()).isEqualTo(1L);
        Assertions.assertThat((long)((Metric)metrics.get("decision-instances")).getCount()).isEqualTo(0L);
        Assertions.assertThat((long)((Metric)metrics.get("executed-decision-elements")).getCount()).isEqualTo(0L);
    }
}

