/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.el;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.bpmn.el.ExecutionTestVariable;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ExclusiveGatewayBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionManagerTest
extends PluggableProcessEngineTest {
    protected String deploymentId;

    @After
    public void clear() {
        if (this.deploymentId != null) {
            this.repositoryService.deleteDeployment(this.deploymentId, true);
            this.deploymentId = null;
        }
    }

    @Deployment
    @Test
    public void testMethodExpressions() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("aString", "abcdefgh");
        this.runtimeService.startProcessInstanceByKey("methodExpressionProcess", vars);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("methodExpressionProcess").count());
    }

    @Deployment
    @Test
    public void testExecutionAvailable() {
        HashMap<String, ExecutionTestVariable> vars = new HashMap<String, ExecutionTestVariable>();
        vars.put("myVar", new ExecutionTestVariable());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testExecutionAvailableProcess", vars);
        String value = (String)this.runtimeService.getVariable(processInstance.getId(), "testVar");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"myValue", (Object)value);
    }

    @Deployment
    @Test
    public void testAuthenticatedUserIdAvailable() {
        try {
            this.identityService.setAuthenticatedUserId("frederik");
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testAuthenticatedUserIdAvailableProcess");
            String value = (String)this.runtimeService.getVariable(processInstance.getId(), "theUser");
            Assert.assertNotNull((Object)value);
            Assert.assertEquals((Object)"frederik", (Object)value);
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    @Deployment
    @Test
    public void testResolvesVariablesFromDifferentScopes() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("assignee", "michael");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"michael", (Object)task.getAssignee());
        variables.put("assignee", "johnny");
        ProcessInstance secondInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(secondInstance.getId()).singleResult();
        Assert.assertEquals((Object)"johnny", (Object)task.getAssignee());
    }

    @Deployment
    @RequiredHistoryLevel(value="full")
    @Test
    public void testSetVariableByExpressionFromListener() {
        this.runtimeService.startProcessInstanceByKey("fieldInjectionTest", (Map)Variables.putValue((String)"myCounter", (Object)5));
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myCounter", (Object)6).count());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testJuelExpressionWithNonPublicClass() {
        BpmnModelInstance process = ((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().exclusiveGateway().condition("true", "${list.contains('foo')}")).userTask("userTask").moveToLastGateway().condition("false", "${!list.contains('foo')}").endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("list", Arrays.asList("foo", "bar")));
        HistoricActivityInstance userTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        Assertions.assertThat((Object)userTask).isNotNull();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldCompareWithBigDecimal() {
        BpmnModelInstance process = ((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().exclusiveGateway().condition("true", "${total.compareTo(myValue) >= 0}")).userTask("userTask").moveToLastGateway().condition("false", "${total.compareTo(myValue) < 0}").endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("total", (Object)new BigDecimal(123)).putValue("myValue", (Object)new BigDecimal(0)));
        HistoricActivityInstance userTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        Assertions.assertThat((Object)userTask).isNotNull();
    }
}

