/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricIncidentTest
extends PluggableProcessEngineTest {
    private static String PROCESS_DEFINITION_KEY = "oneFailingServiceTaskProcess";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testPropertiesOfHistoricIncident() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assert.assertNotNull((Object)historicIncident);
        HistoricJobLog jobLog = this.getHistoricJobLogOrdered(incident.getConfiguration()).get(0);
        Assert.assertEquals((Object)incident.getId(), (Object)historicIncident.getId());
        Assert.assertEquals((Object)incident.getIncidentTimestamp(), (Object)historicIncident.getCreateTime());
        Assert.assertNull((Object)historicIncident.getEndTime());
        Assert.assertEquals((Object)incident.getIncidentType(), (Object)historicIncident.getIncidentType());
        Assert.assertEquals((Object)incident.getIncidentMessage(), (Object)historicIncident.getIncidentMessage());
        Assert.assertEquals((Object)incident.getExecutionId(), (Object)historicIncident.getExecutionId());
        Assert.assertEquals((Object)incident.getActivityId(), (Object)historicIncident.getActivityId());
        Assert.assertEquals((Object)incident.getProcessInstanceId(), (Object)historicIncident.getProcessInstanceId());
        Assert.assertEquals((Object)incident.getProcessDefinitionId(), (Object)historicIncident.getProcessDefinitionId());
        Assert.assertEquals((Object)PROCESS_DEFINITION_KEY, (Object)historicIncident.getProcessDefinitionKey());
        Assert.assertEquals((Object)incident.getCauseIncidentId(), (Object)historicIncident.getCauseIncidentId());
        Assert.assertEquals((Object)incident.getRootCauseIncidentId(), (Object)historicIncident.getRootCauseIncidentId());
        Assert.assertEquals((Object)incident.getConfiguration(), (Object)historicIncident.getConfiguration());
        Assert.assertEquals((Object)incident.getJobDefinitionId(), (Object)historicIncident.getJobDefinitionId());
        Assert.assertEquals((Object)jobLog.getId(), (Object)historicIncident.getHistoryConfiguration());
        Assert.assertNotNull((Object)historicIncident.getFailedActivityId());
        Assert.assertEquals((Object)incident.getFailedActivityId(), (Object)historicIncident.getFailedActivityId());
        Assert.assertTrue((boolean)historicIncident.isOpen());
        Assert.assertFalse((boolean)historicIncident.isDeleted());
        Assert.assertFalse((boolean)historicIncident.isResolved());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testCreateSecondHistoricIncident() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        this.testRule.executeAvailableJobs();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.resolved().count());
        query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)1L, (long)query.open().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testJobLogReferenceWithMultipleHistoricIncidents() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        this.testRule.executeAvailableJobs();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)2L, (long)query.count());
        List<HistoricJobLog> logs = this.getHistoricJobLogOrdered(jobId);
        Assert.assertEquals((Object)logs.get(1).getId(), (Object)((HistoricIncident)query.resolved().singleResult()).getHistoryConfiguration());
        query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((Object)logs.get(0).getId(), (Object)((HistoricIncident)query.open().singleResult()).getHistoryConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testSetHistoricIncidentToResolved() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assert.assertNotNull((Object)historicIncident);
        Assert.assertNotNull((Object)historicIncident.getEndTime());
        Assert.assertFalse((boolean)historicIncident.isOpen());
        Assert.assertFalse((boolean)historicIncident.isDeleted());
        Assert.assertTrue((boolean)historicIncident.isResolved());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testSetHistoricIncidentToResolvedRecursive() {
        this.startProcessInstance("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        List historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        for (HistoricIncident historicIncident : historicIncidents) {
            Assert.assertNotNull((Object)historicIncident.getEndTime());
            Assert.assertFalse((boolean)historicIncident.isOpen());
            Assert.assertFalse((boolean)historicIncident.isDeleted());
            Assert.assertTrue((boolean)historicIncident.isResolved());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testSetHistoricIncidentToDeleted() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assert.assertNotNull((Object)historicIncident);
        Assert.assertNotNull((Object)historicIncident.getEndTime());
        Assert.assertFalse((boolean)historicIncident.isOpen());
        Assert.assertTrue((boolean)historicIncident.isDeleted());
        Assert.assertFalse((boolean)historicIncident.isResolved());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testSetHistoricIncidentToDeletedRecursive() {
        this.startProcessInstance("process");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult()).getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        List historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        for (HistoricIncident historicIncident : historicIncidents) {
            Assert.assertNotNull((Object)historicIncident.getEndTime());
            Assert.assertFalse((boolean)historicIncident.isOpen());
            Assert.assertTrue((boolean)historicIncident.isDeleted());
            Assert.assertFalse((boolean)historicIncident.isResolved());
        }
    }

    @Deployment
    @Test
    public void testCreateHistoricIncidentForNestedExecution() {
        this.startProcessInstance("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("serviceTask").singleResult();
        Assert.assertNotNull((Object)execution);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assert.assertNotNull((Object)historicIncident);
        HistoricJobLog jobLog = this.getHistoricJobLogOrdered(historicIncident.getConfiguration()).get(0);
        Assert.assertEquals((Object)execution.getId(), (Object)historicIncident.getExecutionId());
        Assert.assertEquals((Object)"serviceTask", (Object)historicIncident.getActivityId());
        Assert.assertEquals((Object)jobLog.getId(), (Object)historicIncident.getHistoryConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testCreateRecursiveHistoricIncidents() {
        this.startProcessInstance("process");
        ProcessInstance pi1 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").singleResult();
        Assert.assertNotNull((Object)pi1);
        ProcessInstance pi2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        Assert.assertNotNull((Object)pi2);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncident rootCauseHistoricIncident = (HistoricIncident)query.processInstanceId(pi2.getId()).singleResult();
        Assert.assertNotNull((Object)rootCauseHistoricIncident);
        Assert.assertEquals((Object)rootCauseHistoricIncident.getId(), (Object)rootCauseHistoricIncident.getCauseIncidentId());
        Assert.assertEquals((Object)rootCauseHistoricIncident.getId(), (Object)rootCauseHistoricIncident.getRootCauseIncidentId());
        HistoricIncident historicIncident = (HistoricIncident)query.processInstanceId(pi1.getId()).singleResult();
        Assert.assertNotNull((Object)historicIncident);
        Assert.assertEquals((Object)rootCauseHistoricIncident.getId(), (Object)historicIncident.getCauseIncidentId());
        Assert.assertEquals((Object)rootCauseHistoricIncident.getId(), (Object)historicIncident.getRootCauseIncidentId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testJobLogReferenceForRecursiveHistoricIncident() {
        this.startProcessInstance("process");
        ProcessInstance pi1 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").singleResult();
        ProcessInstance pi2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        HistoricIncident rootCauseHistoricIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().processInstanceId(pi2.getId()).singleResult();
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().processInstanceId(pi1.getId()).singleResult();
        List<HistoricJobLog> logs = this.getHistoricJobLogOrdered(rootCauseHistoricIncident.getConfiguration());
        Assert.assertEquals((Object)logs.get(0).getId(), (Object)rootCauseHistoricIncident.getHistoryConfiguration());
        Assert.assertNull((Object)historicIncident.getHistoryConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentTest.testCreateRecursiveHistoricIncidentsForNestedCallActivities.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testCreateRecursiveHistoricIncidentsForNestedCallActivities() {
        this.startProcessInstance("process1");
        ProcessInstance pi1 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process1").singleResult();
        Assert.assertNotNull((Object)pi1);
        ProcessInstance pi2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").singleResult();
        Assert.assertNotNull((Object)pi2);
        ProcessInstance pi3 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        Assert.assertNotNull((Object)pi3);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        HistoricIncident rootCauseHistoricIncident = (HistoricIncident)query.processInstanceId(pi3.getId()).singleResult();
        Assert.assertNotNull((Object)rootCauseHistoricIncident);
        Assert.assertEquals((Object)rootCauseHistoricIncident.getId(), (Object)rootCauseHistoricIncident.getCauseIncidentId());
        Assert.assertEquals((Object)rootCauseHistoricIncident.getId(), (Object)rootCauseHistoricIncident.getRootCauseIncidentId());
        HistoricIncident causeHistoricIncident = (HistoricIncident)query.processInstanceId(pi2.getId()).singleResult();
        Assert.assertNotNull((Object)causeHistoricIncident);
        Assert.assertEquals((Object)rootCauseHistoricIncident.getId(), (Object)causeHistoricIncident.getCauseIncidentId());
        Assert.assertEquals((Object)rootCauseHistoricIncident.getId(), (Object)causeHistoricIncident.getRootCauseIncidentId());
        HistoricIncident historicIncident = (HistoricIncident)query.processInstanceId(pi1.getId()).singleResult();
        Assert.assertNotNull((Object)historicIncident);
        Assert.assertEquals((Object)causeHistoricIncident.getId(), (Object)historicIncident.getCauseIncidentId());
        Assert.assertEquals((Object)rootCauseHistoricIncident.getId(), (Object)historicIncident.getRootCauseIncidentId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testDoNotCreateNewIncident() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(pi.getId());
        HistoricIncident incident = (HistoricIncident)query.singleResult();
        Assert.assertNotNull((Object)incident);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 1);
        HistoricIncident tmp = (HistoricIncident)query.singleResult();
        Assert.assertEquals((Object)incident.getId(), (Object)tmp.getId());
        Assert.assertNull((Object)tmp.getEndTime());
        Assert.assertTrue((boolean)tmp.isOpen());
        this.testRule.executeAvailableJobs();
        Assert.assertEquals((long)1L, (long)query.count());
        tmp = (HistoricIncident)query.singleResult();
        Assert.assertEquals((Object)incident.getId(), (Object)tmp.getId());
        Assert.assertNull((Object)tmp.getEndTime());
        Assert.assertTrue((boolean)tmp.isOpen());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testJobLogReferenceWithNoNewIncidentCreatedOnFailure() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(pi.getId());
        HistoricIncident incident = (HistoricIncident)query.singleResult();
        String jobId = incident.getConfiguration();
        List<HistoricJobLog> logs = this.getHistoricJobLogOrdered(jobId);
        Assert.assertEquals((Object)logs.get(0).getId(), (Object)incident.getHistoryConfiguration());
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 2);
        this.testRule.executeAvailableJobs(false);
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricIncident incidentNew = (HistoricIncident)query.singleResult();
        List<HistoricJobLog> logsNew = this.getHistoricJobLogOrdered(jobId);
        Assert.assertEquals((Object)incident.getId(), (Object)incidentNew.getId());
        Assert.assertEquals((Object)incident.getHistoryConfiguration(), (Object)incidentNew.getHistoryConfiguration());
        Assert.assertTrue((logsNew.size() > logs.size() ? 1 : 0) != 0);
        this.testRule.executeAvailableJobs(false);
        Assert.assertEquals((long)1L, (long)query.count());
        incidentNew = (HistoricIncident)query.singleResult();
        logsNew = this.getHistoricJobLogOrdered(jobId);
        Assert.assertTrue((logsNew.size() > logs.size() ? 1 : 0) != 0);
        Assert.assertEquals((Object)incident.getId(), (Object)incidentNew.getId());
        Assert.assertNotEquals((Object)incident.getHistoryConfiguration(), (Object)incidentNew.getHistoryConfiguration());
        Assert.assertEquals((Object)logsNew.get(0).getId(), (Object)incidentNew.getHistoryConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testJobLogReferenceWithNewIncidentCreatedOnSetRetriesAfterFailure() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY, false);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ClockUtil.offset((Long)2000L);
        this.testRule.executeAvailableJobs(false);
        List<HistoricJobLog> logs = this.getHistoricJobLogOrdered(job.getId());
        Assert.assertEquals((long)2L, (long)logs.size());
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(pi.getId());
        Assert.assertEquals((long)0L, (long)query.count());
        this.managementService.setJobRetries(job.getId(), 0);
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricIncident incident = (HistoricIncident)query.singleResult();
        Assert.assertEquals((Object)logs.get(0).getId(), (Object)incident.getHistoryConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void testSetRetriesByJobDefinitionIdResolveIncident() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(pi.getId());
        HistoricIncident incident = (HistoricIncident)query.singleResult();
        Assert.assertNotNull((Object)incident);
        this.runtimeService.setVariable(pi.getId(), "fail", (Object)false);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 1);
        HistoricIncident tmp = (HistoricIncident)query.singleResult();
        Assert.assertEquals((Object)incident.getId(), (Object)tmp.getId());
        Assert.assertNull((Object)tmp.getEndTime());
        Assert.assertTrue((boolean)tmp.isOpen());
        this.testRule.executeAvailableJobs();
        Assert.assertEquals((long)1L, (long)query.count());
        tmp = (HistoricIncident)query.singleResult();
        Assert.assertEquals((Object)incident.getId(), (Object)tmp.getId());
        Assert.assertNotNull((Object)tmp.getEndTime());
        Assert.assertTrue((boolean)tmp.isResolved());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void shouldPropagateSetAnnotationToHistoricIncident() {
        String annotation = "my annotation";
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery historicIncidentQuery = this.historyService.createHistoricIncidentQuery();
        HistoricIncident historicIncident = (HistoricIncident)historicIncidentQuery.singleResult();
        Assertions.assertThat((String)historicIncident.getAnnotation()).isNull();
        this.runtimeService.setAnnotationForIncidentById(historicIncident.getId(), annotation);
        Assertions.assertThat((String)((HistoricIncident)historicIncidentQuery.singleResult()).getAnnotation()).isEqualTo((Object)annotation);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    @Test
    public void shouldPropagateClearAnnotationToHistoricIncident() {
        String annotation = "my annotation";
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery historicIncidentQuery = this.historyService.createHistoricIncidentQuery();
        HistoricIncident historicIncident = (HistoricIncident)historicIncidentQuery.singleResult();
        this.runtimeService.setAnnotationForIncidentById(historicIncident.getId(), annotation);
        Assertions.assertThat((String)((HistoricIncident)historicIncidentQuery.singleResult()).getAnnotation()).isEqualTo((Object)annotation);
        this.runtimeService.clearAnnotationForIncidentById(historicIncident.getId());
        Assertions.assertThat((String)((HistoricIncident)historicIncidentQuery.singleResult()).getAnnotation()).isNull();
    }

    protected void startProcessInstance(String key) {
        this.startProcessInstances(key, 1, true);
    }

    protected void startProcessInstance(String key, boolean recursive) {
        this.startProcessInstances(key, 1, recursive);
    }

    protected void startProcessInstances(String key, int numberOfInstances, boolean recursive) {
        for (int i = 0; i < numberOfInstances; ++i) {
            this.runtimeService.startProcessInstanceByKey(key);
        }
        this.testRule.executeAvailableJobs(recursive);
    }

    protected List<HistoricJobLog> getHistoricJobLogOrdered(String jobId) {
        return ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().failureLog().jobId(jobId).orderPartiallyByOccurrence().desc()).list();
    }
}

