/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.CompositeProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class CompositeProcessEnginePluginTest {
    private static final ProcessEnginePlugin PLUGIN_A = CompositeProcessEnginePluginTest.processEnginePlugin("PluginA");
    private static final ProcessEnginePlugin PLUGIN_B = CompositeProcessEnginePluginTest.processEnginePlugin("PluginB");
    private static final InOrder ORDER = Mockito.inOrder((Object[])new Object[]{PLUGIN_A, PLUGIN_B});
    private static final ProcessEngineConfigurationImpl CONFIGURATION = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
    private static final ProcessEngine ENGINE = (ProcessEngine)Mockito.mock(ProcessEngine.class);

    @Test
    public void addPlugin() throws Exception {
        CompositeProcessEnginePlugin composite = new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[0]);
        Assertions.assertThat((List)composite.getPlugins()).hasSize(1);
        Assertions.assertThat((Object)((ProcessEnginePlugin)composite.getPlugins().get(0))).isEqualTo((Object)PLUGIN_A);
        composite.addProcessEnginePlugin(PLUGIN_B, new ProcessEnginePlugin[0]);
        Assertions.assertThat((List)composite.getPlugins()).hasSize(2);
        Assertions.assertThat((Object)((ProcessEnginePlugin)composite.getPlugins().get(1))).isEqualTo((Object)PLUGIN_B);
    }

    @Test
    public void addPlugins() throws Exception {
        CompositeProcessEnginePlugin composite = new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[0]);
        composite.addProcessEnginePlugins(Arrays.asList(PLUGIN_B));
        Assertions.assertThat((List)composite.getPlugins()).hasSize(2);
        Assertions.assertThat((Object)((ProcessEnginePlugin)composite.getPlugins().get(0))).isEqualTo((Object)PLUGIN_A);
        Assertions.assertThat((Object)((ProcessEnginePlugin)composite.getPlugins().get(1))).isEqualTo((Object)PLUGIN_B);
    }

    @Test
    public void allPluginsOnPreInit() throws Exception {
        new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[]{PLUGIN_B}).preInit(CONFIGURATION);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_A)).preInit(CONFIGURATION);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_B)).preInit(CONFIGURATION);
    }

    @Test
    public void allPluginsOnPostInit() throws Exception {
        new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[]{PLUGIN_B}).postInit(CONFIGURATION);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_A)).postInit(CONFIGURATION);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_B)).postInit(CONFIGURATION);
    }

    @Test
    public void allPluginsOnPostProcessEngineBuild() throws Exception {
        new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[]{PLUGIN_B}).postProcessEngineBuild(ENGINE);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_A)).postProcessEngineBuild(ENGINE);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_B)).postProcessEngineBuild(ENGINE);
    }

    @Test
    public void verifyToString() throws Exception {
        Assertions.assertThat((String)new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[]{PLUGIN_B}).toString()).isEqualTo((Object)"CompositeProcessEnginePlugin[PluginA, PluginB]");
    }

    private static ProcessEnginePlugin processEnginePlugin(String name) {
        ProcessEnginePlugin plugin = (ProcessEnginePlugin)Mockito.mock(ProcessEnginePlugin.class);
        Mockito.when((Object)plugin.toString()).thenReturn((Object)name);
        return plugin;
    }
}

