/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class MessageStartEventTest
extends PluggableProcessEngineTest {
    @Test
    public void testDeploymentCreatesSubscriptions() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)1L, (long)eventSubscriptions.size());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSameMessageNameFails() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/otherProcessWithNewInvoiceMessage.bpmn20.xml").deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("there already is a message event subscription for the message with name"));
        }
        finally {
            List deployments = this.repositoryService.createDeploymentQuery().list();
            for (org.camunda.bpm.engine.repository.Deployment deployment : deployments) {
                this.repositoryService.deleteDeployment(deployment.getId(), true);
            }
            this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().clear();
        }
    }

    @Test
    public void testEmptyMessageNameFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testEmptyMessageNameFails.bpmn20.xml").deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot have a message event subscription with an empty or missing name"));
            Assert.assertEquals((Object)"theStart", (Object)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId());
        }
    }

    @Test
    public void testSameMessageNameInSameProcessFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/testSameMessageNameInSameProcessFails.bpmn20.xml").deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot have more than one message event subscription with name 'newInvoiceMessage' for scope"));
        }
    }

    @Test
    public void testUpdateProcessVersionCancelsSubscriptions() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)eventSubscriptions.size());
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        String newDeploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml").deploy().getId();
        List newEventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        List newProcessDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)newEventSubscriptions.size());
        Assert.assertEquals((long)2L, (long)newProcessDefinitions.size());
        for (ProcessDefinition processDefinition : newProcessDefinitions) {
            EventSubscriptionEntity subscriptionEntity;
            if (processDefinition.getVersion() == 1) {
                for (EventSubscription subscription : newEventSubscriptions) {
                    subscriptionEntity = (EventSubscriptionEntity)subscription;
                    Assert.assertFalse((boolean)subscriptionEntity.getConfiguration().equals(processDefinition.getId()));
                }
                continue;
            }
            for (EventSubscription subscription : newEventSubscriptions) {
                subscriptionEntity = (EventSubscriptionEntity)subscription;
                Assert.assertTrue((boolean)subscriptionEntity.getConfiguration().equals(processDefinition.getId()));
            }
        }
        Assert.assertFalse((boolean)eventSubscriptions.equals(newEventSubscriptions));
        this.repositoryService.deleteDeployment(deploymentId);
        this.repositoryService.deleteDeployment(newDeploymentId);
    }

    @Deployment
    @Test
    public void testSingleMessageStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage");
        Assert.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("singleMessageStartEvent");
        Assert.assertFalse((boolean)processInstance.isEnded());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testMessageStartEventAndNoneStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterNoneStart").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage");
        Assert.assertFalse((boolean)processInstance.isEnded());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessageStart").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testMultipleMessageStartEvents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage");
        Assert.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessageStart").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage2");
        Assert.assertFalse((boolean)processInstance.isEnded());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessageStart2").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((String)("different exception expected, not " + e.getMessage()), (boolean)e.getMessage().contains("has no default start activity"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment
    @Test
    public void testDeployStartAndIntermediateEventWithSameMessageInSameProcess() {
        ProcessInstance pi = null;
        try {
            this.runtimeService.startProcessInstanceByMessage("message");
            pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assertions.assertThat((boolean)pi.isEnded()).isFalse();
            String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testDeployStartAndIntermediateEventWithSameMessageInSameProcess.bpmn").name("deployment2").deploy().getId();
            Assertions.assertThat((Object)((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult())).isNotNull();
        }
        finally {
            this.runtimeService.deleteProcessInstance(pi.getId(), "failure");
            List deployments = this.repositoryService.createDeploymentQuery().list();
            for (org.camunda.bpm.engine.repository.Deployment d : deployments) {
                this.repositoryService.deleteDeployment(d.getId(), true);
            }
            this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testDeployStartAndIntermediateEventWithSameMessageDifferentProcesses.bpmn"})
    @Test
    public void testDeployStartAndIntermediateEventWithSameMessageDifferentProcessesFirstStartEvent() {
        ProcessInstance pi = null;
        try {
            this.runtimeService.startProcessInstanceByMessage("message");
            pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assertions.assertThat((boolean)pi.isEnded()).isFalse();
            String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testDeployStartAndIntermediateEventWithSameMessageDifferentProcesses2.bpmn").name("deployment2").deploy().getId();
            Assertions.assertThat((Object)((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult())).isNotNull();
        }
        finally {
            this.runtimeService.deleteProcessInstance(pi.getId(), "failure");
            List deployments = this.repositoryService.createDeploymentQuery().list();
            for (org.camunda.bpm.engine.repository.Deployment d : deployments) {
                this.repositoryService.deleteDeployment(d.getId(), true);
            }
            this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testDeployStartAndIntermediateEventWithSameMessageDifferentProcesses2.bpmn"})
    @Test
    public void testDeployStartAndIntermediateEventWithSameMessageDifferentProcessesFirstIntermediateEvent() {
        ProcessInstance pi = null;
        try {
            this.runtimeService.startProcessInstanceByKey("Process_2");
            pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
            Assertions.assertThat((boolean)pi.isEnded()).isFalse();
            String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testDeployStartAndIntermediateEventWithSameMessageDifferentProcesses.bpmn").name("deployment2").deploy().getId();
            Assertions.assertThat((Object)((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult())).isNotNull();
        }
        finally {
            this.runtimeService.deleteProcessInstance(pi.getId(), "failure");
            List deployments = this.repositoryService.createDeploymentQuery().list();
            for (org.camunda.bpm.engine.repository.Deployment d : deployments) {
                this.repositoryService.deleteDeployment(d.getId(), true);
            }
            this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().clear();
        }
    }

    @Test
    public void testUsingExpressionWithDollarTagInMessageStartEventNameThrowsException() {
        String processDefinition = "org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testUsingExpressionWithDollarTagInMessageStartEventNameThrowsException.bpmn20.xml";
        try {
            this.repositoryService.createDeployment().addClasspathResource(processDefinition).deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid message name"));
            Assert.assertTrue((boolean)e.getMessage().contains("expressions in the message start event name are not allowed!"));
        }
    }

    @Test
    public void testUsingExpressionWithHashTagInMessageStartEventNameThrowsException() {
        String processDefinition = "org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testUsingExpressionWithHashTagInMessageStartEventNameThrowsException.bpmn20.xml";
        try {
            this.repositoryService.createDeployment().addClasspathResource(processDefinition).deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid message name"));
            Assert.assertTrue((boolean)e.getMessage().contains("expressions in the message start event name are not allowed!"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testMessageStartEventUsingCorrelationEngine.bpmn"})
    @Test
    public void testMessageStartEventUsingCorrelationEngineAndLocalVariable() {
        ProcessInstance processInstance = this.runtimeService.createMessageCorrelation("newCorrelationStartMessage").setVariableLocal("var", (Object)"value").correlateWithResult().getProcessInstance();
        String processInstanceValue = (String)this.runtimeService.getVariableLocal(processInstance.getId(), "var");
        Assertions.assertThat((String)processInstanceValue).isEqualTo((Object)"value");
    }
}

