/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.pvm;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.test.standalone.pvm.activities.Automatic;
import org.camunda.bpm.engine.test.standalone.pvm.activities.End;
import org.camunda.bpm.engine.test.standalone.pvm.activities.ParallelGateway;
import org.camunda.bpm.engine.test.standalone.pvm.activities.WaitState;
import org.junit.Assert;
import org.junit.Test;

public class PvmParallelTest {
    @Test
    public void testSimpleAutmaticConcurrency() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).transition("c1").transition("c2").endActivity().createActivity("c1").behavior((ActivityBehavior)new Automatic()).transition("join").endActivity().createActivity("c2").behavior((ActivityBehavior)new Automatic()).transition("join").endActivity().createActivity("join").behavior((ActivityBehavior)new ParallelGateway()).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Test
    public void testSimpleWaitStateConcurrency() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).transition("c1").transition("c2").endActivity().createActivity("c1").behavior((ActivityBehavior)new WaitState()).transition("join").endActivity().createActivity("c2").behavior((ActivityBehavior)new WaitState()).transition("join").endActivity().createActivity("join").behavior((ActivityBehavior)new ParallelGateway()).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmExecution activityInstanceC1 = processInstance.findExecution("c1");
        Assert.assertNotNull((Object)activityInstanceC1);
        PvmExecution activityInstanceC2 = processInstance.findExecution("c2");
        Assert.assertNotNull((Object)activityInstanceC2);
        activityInstanceC1.signal(null, null);
        activityInstanceC2.signal(null, null);
        List activityNames = processInstance.findActiveActivityIds();
        ArrayList<String> expectedActivityNames = new ArrayList<String>();
        expectedActivityNames.add("end");
        Assert.assertEquals(expectedActivityNames, (Object)activityNames);
    }

    @Test
    public void testUnstructuredConcurrencyTwoJoins() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).transition("c1").transition("c2").transition("c3").endActivity().createActivity("c1").behavior((ActivityBehavior)new Automatic()).transition("join1").endActivity().createActivity("c2").behavior((ActivityBehavior)new Automatic()).transition("join1").endActivity().createActivity("c3").behavior((ActivityBehavior)new Automatic()).transition("join2").endActivity().createActivity("join1").behavior((ActivityBehavior)new ParallelGateway()).transition("c4").endActivity().createActivity("c4").behavior((ActivityBehavior)new Automatic()).transition("join2").endActivity().createActivity("join2").behavior((ActivityBehavior)new ParallelGateway()).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        Assert.assertNotNull((Object)processInstance.findExecution("end"));
    }

    @Test
    public void testUnstructuredConcurrencyTwoForks() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("fork1").endActivity().createActivity("fork1").behavior((ActivityBehavior)new ParallelGateway()).transition("c1").transition("c2").transition("fork2").endActivity().createActivity("c1").behavior((ActivityBehavior)new Automatic()).transition("join").endActivity().createActivity("c2").behavior((ActivityBehavior)new Automatic()).transition("join").endActivity().createActivity("fork2").behavior((ActivityBehavior)new ParallelGateway()).transition("c3").transition("c4").endActivity().createActivity("c3").behavior((ActivityBehavior)new Automatic()).transition("join").endActivity().createActivity("c4").behavior((ActivityBehavior)new Automatic()).transition("join").endActivity().createActivity("join").behavior((ActivityBehavior)new ParallelGateway()).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        Assert.assertNotNull((Object)processInstance.findExecution("end"));
    }

    @Test
    public void testJoinForkCombinedInOneParallelGateway() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).transition("c1").transition("c2").transition("c3").endActivity().createActivity("c1").behavior((ActivityBehavior)new Automatic()).transition("join1").endActivity().createActivity("c2").behavior((ActivityBehavior)new Automatic()).transition("join1").endActivity().createActivity("c3").behavior((ActivityBehavior)new Automatic()).transition("join2").endActivity().createActivity("join1").behavior((ActivityBehavior)new ParallelGateway()).transition("c4").transition("c5").transition("c6").endActivity().createActivity("c4").behavior((ActivityBehavior)new Automatic()).transition("join2").endActivity().createActivity("c5").behavior((ActivityBehavior)new Automatic()).transition("join2").endActivity().createActivity("c6").behavior((ActivityBehavior)new Automatic()).transition("join2").endActivity().createActivity("join2").behavior((ActivityBehavior)new ParallelGateway()).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        Assert.assertNotNull((Object)processInstance.findExecution("end"));
    }
}

