/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.Collection;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobFailureCollector;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class JobExecutorLogger
extends ProcessEngineLogger {
    public void debugAcquiredJobNotFound(String jobId) {
        this.logDebug("001", "Acquired job with id '{}' not found.", new Object[]{jobId});
    }

    public void exceptionWhileExecutingJob(JobEntity job, Throwable exception) {
        this.logWarn("002", "Exception while executing job {}: ", new Object[]{job, exception});
    }

    public void debugFallbackToDefaultRetryStrategy() {
        this.logDebug("003", "Falling back to default retry strategy", new Object[0]);
    }

    public void debugDecrementingRetriesForJob(String id) {
        this.logDebug("004", "Decrementing retries of job {}", new Object[]{id});
    }

    public void debugInitiallyAppyingRetryCycleForJob(String id, int times) {
        this.logDebug("005", "Applying job retry time cycle for the first time for job {}, retires {}", new Object[]{id, times});
    }

    public void exceptionWhileExecutingJob(String nextJobId, Throwable t) {
        if (t instanceof OptimisticLockingException && !this.isDebugEnabled()) {
            this.logWarn("006", "Exception while executing job {}: {}. To see the full stacktrace set logging level to DEBUG.", new Object[]{nextJobId, t.getClass().getSimpleName()});
        } else {
            this.logWarn("006", "Exception while executing job {}: ", new Object[]{nextJobId, t});
        }
    }

    public void couldNotDeterminePriority(ExecutionEntity execution, Object value, ProcessEngineException e) {
        this.logWarn("007", "Could not determine priority for job created in context of execution {}. Using default priority {}", new Object[]{execution, value, e});
    }

    public void debugAddingNewExclusiveJobToJobExecutorCOntext(String jobId) {
        this.logDebug("008", "Adding new exclusive job to job executor context. Job Id='{}'", new Object[]{jobId});
    }

    public void timeoutDuringShutdown() {
        this.logWarn("009", "Timeout during shutdown of job executor. The current running jobs could not end within 60 seconds after shutdown operation", new Object[0]);
    }

    public void interruptedWhileShuttingDownjobExecutor(InterruptedException e) {
        this.logWarn("010", "Interrupted while shutting down the job executor", new Object[]{e});
    }

    public void debugJobAcquisitionThreadSleeping(long millis) {
        this.logDebug("011", "Job acquisition thread sleeping for {} millis", new Object[]{millis});
    }

    public void jobExecutorThreadWokeUp() {
        this.logDebug("012", "Job acquisition thread woke up", new Object[0]);
    }

    public void jobExecutionWaitInterrupted() {
        this.logDebug("013", "Job Execution wait interrupted", new Object[0]);
    }

    public void startingUpJobExecutor(String name) {
        this.logInfo("014", "Starting up the JobExecutor[{}].", new Object[]{name});
    }

    public void shuttingDownTheJobExecutor(String name) {
        this.logInfo("015", "Shutting down the JobExecutor[{}]", new Object[]{name});
    }

    public void ignoringSuspendedJob(ProcessDefinition processDefinition) {
        this.logDebug("016", "Ignoring job of suspended {}", new Object[]{processDefinition});
    }

    public void debugNotifyingJobExecutor(String string) {
        this.logDebug("017", "Notifying Job Executor of new job {}", new Object[]{string});
    }

    public void startingToAcquireJobs(String name) {
        this.logInfo("018", "{} starting to acquire jobs", new Object[]{name});
    }

    public void exceptionDuringJobAcquisition(Exception e) {
        this.logError("019", "Exception during job acquisition {}", new Object[]{e.getMessage(), e});
    }

    public void stoppedJobAcquisition(String name) {
        this.logInfo("020", "{} stopped job acquisition", new Object[]{name});
    }

    public void exceptionWhileUnlockingJob(String jobId, Throwable t) {
        this.logWarn("021", "Exception while unaquiring job {}: ", new Object[]{jobId, t});
    }

    public void acquiredJobs(String processEngine, AcquiredJobs acquiredJobs) {
        this.logDebug("022", "Acquired {} jobs for process engine '{}': {}", new Object[]{acquiredJobs.size(), processEngine, acquiredJobs.getJobIdBatches()});
    }

    public void executeJobs(String processEngine, Collection<String> jobs) {
        this.logDebug("023", "Execute jobs for process engine '{}': {}", new Object[]{processEngine, jobs});
    }

    public void debugFailedJobNotFound(String jobId) {
        this.logDebug("024", "Failed job with id '{}' not found.", new Object[]{jobId});
    }

    public ProcessEngineException wrapJobExecutionFailure(JobFailureCollector jobFailureCollector, Throwable cause) {
        JobEntity job = jobFailureCollector.getJob();
        if (job != null) {
            return new ProcessEngineException(this.exceptionMessage("025", "Exception while executing job {}: ", new Object[]{jobFailureCollector.getJob()}), cause);
        }
        return new ProcessEngineException(this.exceptionMessage("025", "Exception while executing job {}: ", new Object[]{jobFailureCollector.getJobId()}), cause);
    }

    public ProcessEngineException jobNotFoundException(String jobId) {
        return new ProcessEngineException(this.exceptionMessage("026", "No job found with id '{}'", new Object[]{jobId}));
    }

    public void exceptionWhileParsingExpression(String jobId, String exceptionMessage) {
        this.logWarn("027", "Falling back to default retry strategy. Exception while executing job {}: {}", new Object[]{jobId, exceptionMessage});
    }

    public void warnHistoryCleanupBatchWindowNotFound() {
        this.logWarn("028", "Batch window for history cleanup was not calculated. History cleanup job(s) will be suspended.", new Object[0]);
    }

    public void infoJobExecutorDoesNotHandleHistoryCleanupJobs(ProcessEngineConfigurationImpl config) {
        Long jobExecutorPriorityRangeMin = config.getJobExecutorPriorityRangeMin();
        Long jobExecutorPriorityRangeMax = config.getJobExecutorPriorityRangeMax();
        this.logInfo("029", "JobExecutor is configured for priority range {}-{}. History cleanup jobs will not be handled, because they are outside the priority range ({}).", new Object[]{jobExecutorPriorityRangeMin == null ? 0L : jobExecutorPriorityRangeMin, jobExecutorPriorityRangeMax == null ? Long.MAX_VALUE : jobExecutorPriorityRangeMax, config.getHistoryCleanupJobPriority()});
    }

    public void infoJobExecutorDoesNotHandleBatchJobs(ProcessEngineConfigurationImpl config) {
        Long jobExecutorPriorityRangeMin = config.getJobExecutorPriorityRangeMin();
        Long jobExecutorPriorityRangeMax = config.getJobExecutorPriorityRangeMax();
        this.logInfo("030", "JobExecutor is configured for priority range {}-{}. Batch jobs will not be handled, because they are outside the priority range ({}).", new Object[]{jobExecutorPriorityRangeMin == null ? 0L : jobExecutorPriorityRangeMin, jobExecutorPriorityRangeMax == null ? Long.MAX_VALUE : jobExecutorPriorityRangeMax, config.getBatchJobPriority()});
    }

    public void debugFailedJobListenerSkipped(String jobId) {
        this.logDebug("031", "Failed job listener skipped for job {} because it's been already re-acquired", new Object[]{jobId});
    }

    public ProcessEngineException jobExecutorPriorityRangeException(String reason) {
        return new ProcessEngineException(this.exceptionMessage("031", "Invalid configuration for job executor priority range. Reason: {}", new Object[]{reason}));
    }
}

