/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry.reporter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.IsTelemetryEnabledCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.metrics.util.MetricsUtil;
import org.camunda.bpm.engine.impl.telemetry.CommandCounter;
import org.camunda.bpm.engine.impl.telemetry.TelemetryLogger;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServerImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.CommandImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.InternalsImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.MetricImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.ProductImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import org.camunda.bpm.engine.impl.util.ConnectUtil;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.impl.util.TelemetryUtil;
import org.camunda.bpm.engine.telemetry.Command;
import org.camunda.bpm.engine.telemetry.Metric;
import org.camunda.connect.spi.CloseableConnectorResponse;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorRequest;

public class TelemetrySendingTask
extends TimerTask {
    protected static final Set<String> METRICS_TO_REPORT = new HashSet<String>();
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;
    protected static final String UUID4_PATTERN = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-4[0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}";
    protected CommandExecutor commandExecutor;
    protected String telemetryEndpoint;
    protected TelemetryDataImpl staticData;
    protected Connector<? extends ConnectorRequest<?>> httpConnector;
    protected int telemetryRequestRetries;
    protected TelemetryRegistry telemetryRegistry;
    protected MetricsRegistry metricsRegistry;
    protected int telemetryRequestTimeout;

    public TelemetrySendingTask(CommandExecutor commandExecutor, String telemetryEndpoint, int telemetryRequestRetries, TelemetryDataImpl data, Connector<? extends ConnectorRequest<?>> httpConnector, TelemetryRegistry telemetryRegistry, MetricsRegistry metricsRegistry, int telemetryRequestTimeout) {
        this.commandExecutor = commandExecutor;
        this.telemetryEndpoint = telemetryEndpoint;
        this.telemetryRequestRetries = telemetryRequestRetries;
        this.staticData = data;
        this.httpConnector = httpConnector;
        this.telemetryRegistry = telemetryRegistry;
        this.metricsRegistry = metricsRegistry;
        this.telemetryRequestTimeout = telemetryRequestTimeout;
    }

    @Override
    public void run() {
        LOG.startTelemetrySendingTask();
        if (!this.isTelemetryEnabled()) {
            LOG.telemetryDisabled();
            return;
        }
        TelemetryUtil.toggleLocalTelemetry(true, this.telemetryRegistry, this.metricsRegistry);
        this.performDataSend(() -> this.updateAndSendData(true, true));
    }

    public TelemetryDataImpl updateAndSendData(boolean sendData, boolean addLegacyNames) {
        this.updateStaticData();
        InternalsImpl dynamicData = this.resolveDynamicData(sendData, addLegacyNames);
        TelemetryDataImpl mergedData = new TelemetryDataImpl(this.staticData);
        mergedData.mergeInternals(dynamicData);
        if (sendData) {
            try {
                this.sendData(mergedData);
            }
            catch (Exception e) {
                this.restoreDynamicData(dynamicData);
                throw e;
            }
        }
        return mergedData;
    }

    protected void updateStaticData() {
        InternalsImpl internals = this.staticData.getProduct().getInternals();
        if (internals.getApplicationServer() == null) {
            ApplicationServerImpl applicationServer = this.telemetryRegistry.getApplicationServer();
            internals.setApplicationServer(applicationServer);
        }
        if (internals.isTelemetryEnabled() == null) {
            internals.setTelemetryEnabled(true);
        }
        internals.setLicenseKey(this.telemetryRegistry.getLicenseKey());
        internals.setWebapps(this.telemetryRegistry.getWebapps());
    }

    protected boolean isTelemetryEnabled() {
        Boolean telemetryEnabled = this.commandExecutor.execute(new IsTelemetryEnabledCmd());
        return telemetryEnabled != null && telemetryEnabled != false;
    }

    protected void sendData(TelemetryDataImpl dataToSend) {
        String telemetryData = JsonUtil.asString(dataToSend);
        Map<String, Object> requestParams = ConnectUtil.assembleRequestParameters("POST", this.telemetryEndpoint, "application/json", telemetryData);
        requestParams = ConnectUtil.addRequestTimeoutConfiguration(requestParams, this.telemetryRequestTimeout);
        ConnectorRequest request = this.httpConnector.createRequest();
        request.setRequestParameters(requestParams);
        LOG.sendingTelemetryData(telemetryData);
        CloseableConnectorResponse response = (CloseableConnectorResponse)request.execute();
        if (response == null) {
            LOG.unexpectedResponseWhileSendingTelemetryData();
        } else {
            int responseCode = (Integer)response.getResponseParameter("statusCode");
            if (this.isSuccessStatusCode(responseCode)) {
                if (responseCode != 202) {
                    LOG.unexpectedResponseSuccessCode(responseCode);
                }
                LOG.telemetrySentSuccessfully();
            } else {
                throw LOG.unexpectedResponseWhileSendingTelemetryData(responseCode);
            }
        }
    }

    protected boolean isSuccessStatusCode(int statusCode) {
        return statusCode / 100 == 2;
    }

    protected void restoreDynamicData(InternalsImpl internals) {
        Map<String, Command> commands = internals.getCommands();
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            this.telemetryRegistry.markOccurrence(entry.getKey(), entry.getValue().getCount());
        }
        if (this.metricsRegistry != null) {
            Map<String, Metric> metrics = internals.getMetrics();
            for (String metricToReport : METRICS_TO_REPORT) {
                Metric metricValue = metrics.get(metricToReport);
                this.metricsRegistry.markTelemetryOccurrence(metricToReport, metricValue.getCount());
            }
        }
    }

    protected InternalsImpl resolveDynamicData(boolean reset, boolean addLegacyNames) {
        InternalsImpl result = new InternalsImpl();
        Map<String, Metric> metrics = this.calculateMetrics(reset, addLegacyNames);
        result.setMetrics(metrics);
        Map<String, Command> commands = this.fetchAndResetCommandCounts(reset);
        result.setCommands(commands);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Command> fetchAndResetCommandCounts(boolean reset) {
        Map<String, CommandCounter> originalCounts;
        HashMap<String, Command> commandsToReport = new HashMap<String, Command>();
        Map<String, CommandCounter> map = originalCounts = this.telemetryRegistry.getCommands();
        synchronized (map) {
            for (Map.Entry<String, CommandCounter> counter : originalCounts.entrySet()) {
                long occurrences = counter.getValue().get(reset);
                commandsToReport.put(counter.getKey(), new CommandImpl(occurrences));
            }
        }
        return commandsToReport;
    }

    protected Map<String, Metric> calculateMetrics(boolean reset, boolean addLegacyNames) {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        if (this.metricsRegistry != null) {
            Map<String, Meter> telemetryMeters = this.metricsRegistry.getTelemetryMeters();
            for (String metricToReport : METRICS_TO_REPORT) {
                long value = telemetryMeters.get(metricToReport).get(reset);
                if (addLegacyNames) {
                    metrics.put(metricToReport, new MetricImpl(value));
                }
                metrics.put(MetricsUtil.resolvePublicName(metricToReport), new MetricImpl(value));
            }
        }
        return metrics;
    }

    protected void performDataSend(Runnable runnable) {
        if (this.validateData(this.staticData).booleanValue()) {
            int triesLeft = this.telemetryRequestRetries + 1;
            boolean requestSuccessful = false;
            do {
                try {
                    --triesLeft;
                    runnable.run();
                    requestSuccessful = true;
                }
                catch (Exception e) {
                    LOG.exceptionWhileSendingTelemetryData(e);
                }
            } while (!requestSuccessful && triesLeft > 0);
        } else {
            LOG.sendingTelemetryDataFails(this.staticData);
        }
    }

    protected Boolean validateData(TelemetryDataImpl dataToSend) {
        boolean validProductData;
        ProductImpl product = dataToSend.getProduct();
        String installationId = dataToSend.getInstallation();
        String edition = product.getEdition();
        String version = product.getVersion();
        String name = product.getName();
        boolean bl = validProductData = StringUtil.hasText(name) && StringUtil.hasText(version) && StringUtil.hasText(edition) && StringUtil.hasText(installationId);
        if (validProductData) {
            validProductData = validProductData && installationId.matches(UUID4_PATTERN);
        }
        return validProductData;
    }

    static {
        METRICS_TO_REPORT.add("root-process-instance-start");
        METRICS_TO_REPORT.add("executed-decision-instances");
        METRICS_TO_REPORT.add("executed-decision-elements");
        METRICS_TO_REPORT.add("activity-instance-start");
    }
}

