/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.suspensionstate;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.repository.ResourceDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyProcessDefinitionSuspensionStateTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().camundaAsyncBefore()).endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.testRule.deploy(PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
    }

    @Test
    public void suspendAndActivateProcessDefinitionsForAllTenants() {
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
    }

    @Test
    public void suspendProcessDefinitionForTenant() {
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessDefinitionForNonTenant() {
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessDefinitionForTenant() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessDefinitionForNonTenant() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendAndActivateProcessDefinitionsIncludeInstancesForAllTenants() {
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).activate();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
    }

    @Test
    public void suspendProcessDefinitionIncludeInstancesForTenant() {
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).includeProcessInstances(true).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessDefinitionIncludeInstancesForNonTenant() {
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().includeProcessInstances(true).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessDefinitionIncludeInstancesForTenant() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).suspend();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).includeProcessInstances(true).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessDefinitionIncludeInstancesForNonTenant() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).suspend();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().includeProcessInstances(true).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void delayedSuspendProcessDefinitionsForAllTenants() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).executionDate(this.tomorrow()).suspend();
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        List expectedDeploymentIds = query.active().list().stream().map(ResourceDefinition::getDeploymentId).collect(Collectors.toList());
        Assertions.assertThat(expectedDeploymentIds).contains((Object[])new String[]{job.getDeploymentId()});
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
    }

    @Test
    public void delayedSuspendProcessDefinitionsForTenant() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).executionDate(this.tomorrow()).suspend();
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        String expectedDeploymentId = ((ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().active().tenantIdIn(new String[]{TENANT_ONE}).singleResult()).getDeploymentId();
        Assertions.assertThat((String)job.getDeploymentId()).isEqualTo((Object)expectedDeploymentId);
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void delayedSuspendProcessDefinitionsForNonTenant() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().executionDate(this.tomorrow()).suspend();
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        String expectedDeploymentId = ((ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().active().withoutTenantId().singleResult()).getDeploymentId();
        Assertions.assertThat((String)job.getDeploymentId()).isEqualTo((Object)expectedDeploymentId);
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void delayedActivateProcessDefinitionsForAllTenants() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).executionDate(this.tomorrow()).activate();
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        List expectedDeploymentIds = query.suspended().list().stream().map(ResourceDefinition::getDeploymentId).collect(Collectors.toList());
        Assertions.assertThat(expectedDeploymentIds).contains((Object[])new String[]{job.getDeploymentId()});
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
    }

    @Test
    public void delayedActivateProcessDefinitionsForTenant() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).executionDate(this.tomorrow()).activate();
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        String expectedDeploymentId = ((ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().suspended().tenantIdIn(new String[]{TENANT_ONE}).singleResult()).getDeploymentId();
        Assertions.assertThat((String)job.getDeploymentId()).isEqualTo((Object)expectedDeploymentId);
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void delayedActivateProcessDefinitionsForNonTenant() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().executionDate(this.tomorrow()).activate();
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        String expectedDeploymentId = ((ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().suspended().withoutTenantId().singleResult()).getDeploymentId();
        Assertions.assertThat((String)job.getDeploymentId()).isEqualTo((Object)expectedDeploymentId);
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessDefinitionIncludingJobDefinitionsForAllTenants() {
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
    }

    @Test
    public void suspendProcessDefinitionIncludingJobDefinitionsForTenant() {
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessDefinitionIncludingJobDefinitionsForNonTenant() {
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessDefinitionIncludingJobDefinitionsForAllTenants() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
    }

    @Test
    public void activateProcessDefinitionIncludingJobDefinitionsForTenant() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessDefinitionIncludingJobDefinitionsForNonTenant() {
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessDefinitionNoAuthenticatedTenants() {
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getIdentityService().clearAuthentication();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void failToSuspendProcessDefinitionByIdNoAuthenticatedTenants() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).suspend()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the process definition '" + processDefinition.getId() + "' because it belongs to no authenticated tenant");
    }

    @Test
    public void suspendProcessDefinitionWithAuthenticatedTenant() {
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getIdentityService().clearAuthentication();
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendProcessDefinitionDisabledTenantCheck() {
        ProcessDefinitionQuery query = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        processEngineConfiguration.setTenantCheckEnabled(false);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeProcessDefinitionsWithoutTenantId().count()).isEqualTo(3L);
    }

    protected Date tomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 1);
        return calendar.getTime();
    }

    @After
    public void tearDown() throws Exception {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-processdefinition");
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                return null;
            }
        });
    }
}

